#!/bin/sh
#
# xqt-debian-install.sh - program to install Pocketworkstation 
# version 0.3.9
#
# Copyright (C) 2006 hdluc@yahoo.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
######################################################################

echo ""
echo "Debian PocketWorkstation for Zaurus (X/Qt) Installer Version 0.3.9"
echo ""

# required disk space in order to install
HDSPACE=520
# debroot (default /hdd3/debroot)
DEBROOT=$1
if [ "$DEBROOT" = "/" ] || [ "$DEBROOT" = "/mnt" ] || [ "$DEBROOT" = "/hdd3" ]; then
  echo "error: debroot is invalid"
  exit 1
fi
# base install location (default /hdd3) 
DEBBASE=`dirname $DEBROOT 2>/dev/null`
if [ "$DEBBASE" = "/" ] || [ "$DEBBASE" = "/mnt" ]; then
  if [ "`mount|grep hdd3`" != "" ]; then
    FREESPACE=`df -m|grep hdd3|grep /dev/hd|awk '{print $4}'`
    if [ $FREESPACE -ge $HDSPACE ] || [ -f /hdd3/pocketworkstation ] || [ -f /hdd3/pocketworkstation.ext2 ]; then
      DEBBASE=/hdd3
    fi
  fi 
fi
if [ "$DEBBASE" = "/" ] || [ "$DEBBASE" = "/mnt" ]; then
  if [ "`mount|grep hdd2`" != "" ]; then
    FREESPACE=`df -m|grep hdd2|grep /dev/hd|awk '{print $4}'`
    if [ $FREESPACE -ge $HDSPACE ] || [ -f /hdd2/pocketworkstation ] || [ -f /hdd2/pocketworkstation.ext2 ]; then
      DEBBASE=/hdd2
    fi
  fi
fi
if [ "$DEBBASE" = "/" ] || [ "$DEBBASE" = "/mnt" ]; then
  if [ "`mount|grep cf`" != "" ]; then
    FREESPACE=`df -m|grep cf|grep /dev/hd|awk '{print $4}'`
    if [ $FREESPACE -ge $HDSPACE ] || [ -f /mnt/cf/pocketworkstation ] || [ -f /mnt/cf/pocketworkstation.ext2 ]; then
      DEBBASE=/mnt/cf
    fi
  fi
fi
if [ "$DEBBASE" = "/" ] || [ "$DEBBASE" = "/mnt" ]; then
  if [ "`mount|grep card`" != "" ]; then
    FREESPACE=`df -m|grep mmcda1|grep card|awk '{print $4}'`
    if [ $FREESPACE -ge $HDSPACE ] || [ -f /mnt/card/pocketworkstation ] || [ -f /mnt/card/pocketworkstation.ext2 ]; then
      DEBBASE=/mnt/card
    fi
  fi
fi
if [ "$DEBBASE" = "/" ] || [ "$DEBBASE" = "/mnt" ]; then
  echo "error: insufficient space available"
  exit 1
fi

###########################################################################
### default settings section start (these values can be modified)
###########################################################################

# swap filename (comment out to prevent creation)
SWAPFILE=$DEBBASE/swapfile
# swap size (in MB)
SWAPSIZE=64
# debian diskimage file (comment out to install to native ext2)
DEBIMG=$DEBBASE/pocketworkstation
# debian size (in MB)
DEBSIZE=512
# debian tarball (this file is required)
DEBTARBALL=zaurus-debian-jumbo-v18-b01.tar.gz
#DEBTARBALL=zaurus-debian-big-v1.0.tgz
# debian documentation tarball (this file is optional)
DOCTARBALL=zaurus-debian-doc-v18.tar.gz
# openoffice tarball (this file is optional)
OOTARBALL=zaurus-debian-openoffice114.tar.gz

###########################################################################
### default settings section end
###########################################################################


# function to create startd script
makenewstartd()
{
cat > $DEBROOT/startd.new << EOF
#!/bin/sh
### startup commands ###
if [ -f /etc/openoffice.conf ] && [ -f /usr/share/openoffice114.cramfs ]; then
  mount -o loop /usr/share/openoffice114.cramfs \`cat /etc/openoffice.conf\`
fi
export PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/bin/X11
export DISPLAY=0:0
if [ -f /home/zaurus/.xstart ]; then
    APP=\`cat /home/zaurus/.xstart\`
    \$APP &
    rm /home/zaurus/.xstart
else
    if [ -f /usr/bin/xterm ]; then
        xterm &
    fi
fi
/usr/bin/icewm-session

### shutdown commands ###
if [ -f /etc/openoffice.conf ]; then
  if [ "\`ps -ef|grep OpenOffice|grep org\`" != "" ]; then
    kill -9 \`ps -ef|grep OpenOffice|grep org|awk '{print \$2}'\` 2>/dev/null
  fi
  umount \`cat /etc/openoffice.conf\` 2>/dev/null
fi
if [ "\`ps -e|grep icewm\`" != "" ]; then
    kill \`ps -e|grep icewm|awk '{print \$1}'\` 2>/dev/null
fi

EOF

chmod 755 $DEBROOT/startd.new
}

# function to create openoffice menu 
makeoomenu()
{
cat > $DEBROOT/usr/lib/menu/openoffice << EOF
?package(openoffice):needs="X11" section="OpenOffice"\
  title="Writer" command="/home/zaurus/OpenOffice.org1.1.4/program/swriter"
?package(openoffice):needs="X11" section="OpenOffice"\
  title="Impress" command="/home/zaurus/OpenOffice.org1.1.4/program/simpress"
?package(openoffice):needs="X11" section="OpenOffice"\
  title="Draw" command="/home/zaurus/OpenOffice.org1.1.4/program/sdraw"
?package(openoffice):needs="X11" section="OpenOffice"\
  title="Math" command="/home/zaurus/OpenOffice.org1.1.4/program/smath"
?package(openoffice):needs="X11" section="OpenOffice"\
  title="Calc" command="/home/zaurus/OpenOffice.org1.1.4/program/scalc"

EOF
}

# begin installation

# check we are running as root
if [ "`id -u`" != "0" ]; then
  echo "error: you need to run this as root"
  exit 1 
fi

# check that debian-scripts has been installed
if [ "`which xlauncher`" = "" ]; then
    echo "warning: pdaXqtrom or X/Qt jumbo is not installed."
fi

# check that sudo has been installed
if [ "`which sudo`" = "" ]; then
    echo "warning: sudo is not installed."
fi

# check destination directory for debroot is provided
if [ "$DEBROOT" = "" ]; then
  echo "error: please specify install location"
  exit 1
else
  echo "...install base is $DEBBASE"
  echo "...debian root is $DEBROOT"
fi

# check if files are already extracted
if [ -f $DEBROOT/startd ] || [ -d $DEBROOT/INSTALL.d ]; then
  #echo "...found existing PocketWorkstation installation..."
  echo "...extracted debian binaries found under $DEBROOT"
else
# check debian tarball is available
  if [ ! -f $DEBTARBALL ] && [ ! -f $DEBROOT/startd ]; then
    DEBTARBALLORIG=zaurus-debian-big-v0.18.tgz
    if [ -f $DEBTARBALLORIG ]; then
        echo "warning: only found original debian tarball $DEBTARBALLORIG"
        DEBTARBALL=$DEBTARBALLORIG
    else
        echo "error: $DEBTARBALL not found."
        exit 1
    fi
  fi
# check tarball is not corrupt
  echo "...verifying $DEBTARBALL"
  gzip -tv $DEBTARBALL 2>/tmp/test
  if [ "`grep OK /tmp/test`" = "" ]; then
    echo "error: $DEBTARBALL is corrupted."
    exit 1
  else
    echo "$DEBTARBALL is ok."
  fi 
  /bin/rm /tmp/test 2>/dev/null
fi

# create swapfile if not exist
if [ "" != "$SWAPFILE" ] && [ ! -f $SWAPFILE ] && [ "`free|grep Swap|awk '{print $2}'`" = "0" ]; then
    echo "...creating swapfile $SWAPFILE"
    dd if=/dev/zero of=$SWAPFILE bs=1M count=$SWAPSIZE
    mkswap $SWAPFILE 
    echo "...swapfile $SWAPFILE created"
    swapon $SWAPFILE
else
    echo "...skipping swapfile creation"
fi

# start Debian installation
echo "Installing PocketWorkstation to $DEBROOT"
echo $DEBROOT > /etc/debroot

# create debroot directory
if [ ! -d $DEBROOT ]; then
    echo "...creating $DEBROOT"
    mkdir -p $DEBROOT
fi

# create pocketworkstation loop file system
if [ ! -d $DEBROOT/INSTALL.d ] && [ ! -f $DEBROOT/startd ]; then
  if [ "$DEBIMG" != "" ] && [ ! -f $DEBIMG ]; then
    if [ "`dirname $DEBROOT`" = "/mnt" ]; then
      LOOPIMG=yes
    else
      touch $DEBROOT/fstest
      ln -s $DEBROOT/fstest $DEBROOT/fslink 2>/dev/null
      if [ "$?" = "0" ]; then
        echo "...$DEBROOT is located on ext2 filesystem"
	LOOPIMG=no
      else
        echo "...$DEBROOT is located on fat filesystem"
	LOOPIMG=yes
      fi
      if [ -f $DEBROOT/fslink ]; then
        /bin/rm -rf $DEBROOT/fslink 2>/dev/null
      fi 
      /bin/rm -rf $DEBROOT/fstest 2>/dev/null
    fi
    if [ "$LOOPIMG" = "yes" ]; then
      if [ "`echo $DEBIMG|grep ext2`" = "" ]; then
        DEBIMG=${DEBIMG}.ext2
      fi
      echo "...generating ext2 loop filesystem $DEBIMG"
      dd if=/dev/zero of=$DEBIMG bs=1M count=$DEBSIZE 
      echo y|/sbin/mke2fs $DEBIMG
      echo $DEBIMG > /etc/debfs
      echo "...$DEBIMG created."
      #if [ "`grep $DEBIMG /opt/QtPalmtop/bin/startx-wrapper`" = "" ]; then
      #  /bin/cp /opt/QtPalmtop/bin/startx-wrapper /opt/QtPalmtop/bin/startx-wrapper.orig 2>/dev/null
      #  sed -e "s#DEBIMG=/hdd3/pocketworkstation#DEBIMG=$DEBIMG#g" /opt/QtPalmtop/bin/startx-wrapper.orig > /opt/QtPalmtop/bin/startx-wrapper
      #  echo "...xlauncher updated."
      #fi
    fi
  fi
fi

# create additional loop devices and mount pocketworkstation
if [ "$DEBIMG" != "" ] && [ -f $DEBIMG ]; then
  for i in 2 3 4 5 6 7
  do
    if [ ! -e /dev/loop$i ]; then
      mknod /dev/loop$i b 7 $i 2>/dev/null
    fi
  done
  if [ "`mount|grep loop|grep $DEBROOT`" = "" ] && [ -f $DEBIMG ]; then   
    mount -o loop -t ext2 $DEBIMG $DEBROOT
    echo "...$DEBIMG mounted"
  fi
fi

# install debian binaries to disk
if [ ! -f $DEBROOT/startd ] && [ ! -d $DEBROOT/INSTALL.d ]; then
  echo "...Extracting Debian binaries. This will take a while ..."
  if [ -f $DEBTARBALL ]; then
    zcat $DEBTARBALL|tar xvf - -C $DEBROOT > /dev/null
    if [ "$?" != "0" ]; then
      echo "error: debian extract failed."
      exit 1
    fi
  fi
else
  echo "Debian is already installed. Skipping file extraction"
fi

# create startd
makenewstartd
if [ ! -f $DEBROOT/startd ]; then
  echo "...creating startd"
  mv $DEBROOT/startd.new $DEBROOT/startd
else
  if [ "`diff $DEBROOT/startd $DEBROOT/startd.new`" != "" ]; then
    echo "upgrading startd..."
    mv $DEBROOT/startd $DEBROOT/startd.old 2>/dev/null
    mv $DEBROOT/startd.new $DEBROOT/startd
  fi
fi

# add zaurus user and qpe group
if [ "`grep zaurus $DEBROOT/etc/passwd`" = "" ]; then
  echo "...adding zaurus user"
  echo "zaurus:*:500:500:Zaurus User:/home/zaurus:/bin/bash" >> $DEBROOT/etc/passwd
fi
if [ "`grep qpe $DEBROOT/etc/group`" = "" ]; then
  echo "...adding qpe group"
  echo "qpe:*:500:" >> $DEBROOT/etc/group
fi

# create additional directories 
echo "...creating additional directories"
if [ ! -d $DEBROOT/mnt/card ]; then
    mkdir -p $DEBROOT/mnt/card
fi
if [ ! -d $DEBROOT/mnt/cf ]; then
    mkdir -p $DEBROOT/mnt/cf
fi
if [ ! -d $DEBROOT/home/zaurus/Documents ]; then
    mkdir -p $DEBROOT/home/zaurus/Documents
fi
if [ ! -d $DEBROOT/hdd3/Documents ] && [ -d /hdd3 ]; then
    mkdir -p $DEBROOT/hdd3/Documents
fi

# make xterm launcher for Eterm
if [ -f $DEBROOT/usr/bin/Eterm ]; then
  if [ ! -f $DEBROOT/usr/bin/xterm ]; then 
    echo "...generating xterm wrapper"
    echo "Eterm -T x-term -0 2>/dev/null &" > $DEBROOT/usr/bin/xterm
    chmod 755 $DEBROOT/usr/bin/xterm
    else
    if [ "`grep Eterm $DEBROOT/usr/bin/xterm`" != "" ]; then
      echo "...updating xterm wrapper"
      echo "Eterm -T x-term -0 2>/dev/null &" > $DEBROOT/usr/bin/xterm
    fi
  fi
fi

# update apt sources
if [ "`grep sarge $DEBROOT/etc/apt/sources.list`" = "" ]; then
  echo "...updating sources.list"
  echo "deb http://ftp.debian.org/debian sarge contrib" >> $DEBROOT/etc/apt/sources.list
fi 

# prepare icewm profile
if [ ! -d $DEBROOT/home/zaurus/.icewm ]; then
  echo "...creating default icewm profile" 
  if [ -d $DEBROOT/INSTALL.d ]; then
  /bin/cp -R $DEBROOT/INSTALL.d/debroot/root/.icewm $DEBROOT/home/zaurus
  chown -R zaurus:qpe $DEBROOT/home/zaurus/.icewm
else
  mkdir -p $DEBROOT/home/zaurus/.icewm
fi
  /bin/cp $DEBROOT/etc/X11/icewm/* $DEBROOT/home/zaurus/.icewm/
  chown -R zaurus:qpe $DEBROOT/home/zaurus/.icewm
fi
if [ -d $DEBROOT/home/root/.icewm ]; then
  /bin/mv $DEBROOT/home/root/.icewm $DEBROOT/home/root/icewm.old 2> /dev/null
fi
chroot $DEBROOT /bin/ln -s /home/zaurus/.icewm /home/root/.icewm 2> /dev/null

# install documentation
if [ -f $DOCTARBALL ]; then
  echo "...Extracting Debian documentation files"
  zcat $DOCTARBALL|tar xvf - -C $DEBROOT/usr/share/doc > /dev/null
  if [ "$?" = "0" ]; then
    echo "...documentation extracted."
  else
    echo "warning: failed to extract documentation."
  fi
fi

# clean up install
if [ -d $DEBROOT/INSTALL.d ]; then
  echo "...cleaning up install files"
  /bin/cp $DEBROOT/INSTALL.d/debroot/usr/local/bin/* $DEBROOT/usr/local/bin > /dev/null
  /bin/cp $DEBROOT/INSTALL.d/native/bin/* /usr/local/bin > /dev/null
  /bin/cp $DEBROOT/INSTALL.d/native/debroot.conf /etc
  /bin/rm -r $DEBROOT/INSTALL.d 2>/dev/null
fi

#echo "Debian files extracted."

# setup auto loop creation
if [ ! -f /etc/rc.d/init.d/mntloop ] && [ -f $DEBROOT/root/mntloop ]; then
  echo "...setting up mntloop"
  /bin/cp $DEBROOT/root/mntloop /etc/rc.d/init.d/mntloop
  chmod 755 /etc/rc.d/init.d/mntloop
  if [ ! -f /etc/rc.d/rc5.d/S50mnt ]; then
    ln -s /etc/rc.d/init.d/mntloop /etc/rc.d/rc5.d/S50mnt
  fi
  if [ ! -f /etc/rc.d/rc6.d/K50mnt ]; then
    ln -s /etc/rc.d/init.d/mntloop /etc/rc.d/rc6.d/K50mnt
  fi
fi
if [ ! -f /etc/rc.d/init.d/mntloop ]; then
   echo "warning: automounter (mntloop) is not installed. please install it."
fi

# install openoffice
if [ -f $OOTARBALL ]; then
  echo "...Extracting OpenOffice binaries"
  if [ ! -d $DEBROOT/home/zaurus/OpenOffice.org1.1.4 ]; then
    mkdir -p $DEBROOT/home/zaurus/OpenOffice.org1.1.4
  fi
  echo /home/zaurus/OpenOffice.org1.1.4 > $DEBROOT/etc/openoffice.conf
  if [ ! -f $DEBROOT/usr/share/openoffice114.cramfs ]; then
    zcat $OOTARBALL|tar xvf - -C $DEBROOT > /dev/null
    if [ "$?" = "0" ]; then
      echo "...OpenOffice files extracted."
    else
      echo "error: failed to extract OpenOffice files."
    fi
  else
    echo "...OpenOffice binaries already installed."
  fi
  if [ ! -f $DEBROOT/usr/bin/soffice ]; then 
    echo "/home/zaurus/OpenOffice.org1.1.4/soffice &" > $DEBROOT/usr/bin/soffice
    chmod 755 $DEBROOT/usr/bin/soffice
  fi
  if [ ! -f $DEBROOT/usr/lib/menu/openoffice ]; then
    makeoomenu
    if [ -f $DEBROOT/usr/bin/update-menus ]; then
      chroot $DEBROOT /usr/bin/update-menus
    fi
  fi
fi

# configure shared network
echo "...preparing your network"
/bin/cp /etc/hosts $DEBROOT/etc/hosts
/bin/cp /etc/resolv.conf $DEBROOT/etc/resolv.conf

# done
echo ""
echo "Debian has been installed."
echo "You can launch Debian from the Qt desktop via its icon or use:"
echo "xlauncher debian" 
echo ""
