/****************************************************************************
** trayicon_x11.cpp - X11 tray app (for use with KDE and GNOME)
****************************************************************************/

#include <qapplication.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qcursor.h>
#include <qlabel.h>
#include <qtooltip.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "trayicon.h"

/*static QPixmap buildIcon(const QPixmap &_in)
{
        QImage image(22,22,32);
        image.fill(0);
        image.setAlphaBuffer(TRUE);
        QImage in = _in.convertToImage();
        //QImage in(22,22,32);
        // make sure it is no bigger than 22x22
        if(in.width() > 22 || in.height() > 22)
                in = in.smoothScale(22,22);
        // draw the pixmap onto the 22x22 image
        int xo = (image.width() - in.width()) / 2;
        int yo = (image.height() - in.height()) / 2;
        for(int n2 = 0; n2 < in.height(); ++n2) {
                for(int n = 0; n < in.width(); ++n) {
                        if(qAlpha(in.pixel(n,n2))) {
                                image.setPixel(n+xo, n2+yo, in.pixel(n,n2));
                        }
                }
        }
        // convert to pixmap and return
        QPixmap icon;
        icon.convertFromImage(image);
        return icon;
}*/

class TrayIcon::TrayIconPrivate : public QLabel
{
public:
    TrayIconPrivate( TrayIcon *object, const QPixmap &pm )
    : QLabel( 0 ), iconObject(object)
    {
        setWFlags(WRepaintNoErase);
        QPixmap pix = pm; //buildIcon(pm);
        setPixmap(pix);
        resize(22,22);
        update();
        //setMask(*pix.mask());

        // dock the widget (adapted from Gabber / gdk)
        Display *dsp = x11Display(); // get the display
        WId win = winId(); // get the window
        int r;
        int data = 1;
        r = XInternAtom(dsp, "KWM_DOCKWINDOW", false);
        XChangeProperty(dsp, win, r, r, 32, 0, (uchar *)&data, 1);
        r = XInternAtom(dsp, "_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", false);
        XChangeProperty(dsp, win, r, XA_WINDOW, 32, 0, (uchar *)&data, 1);
    }

    ~TrayIconPrivate()
    { }

    void mouseMoveEvent( QMouseEvent *e )
    {
        QApplication::sendEvent( iconObject, e );
    }

    void mousePressEvent( QMouseEvent *e )
    {
        QApplication::sendEvent( iconObject, e );
    }

    void mouseReleaseEvent( QMouseEvent *e )
    {
        QApplication::sendEvent( iconObject, e );
    }

    void mouseDoubleClickEvent( QMouseEvent *e )
    {
        QApplication::sendEvent( iconObject, e );
    }

//private:
    TrayIcon *iconObject;
};


void TrayIcon::sysInstall()
{
    if ( d )
        return;

    d = new TrayIconPrivate( this, pm );
    QToolTip::add( d, tip );
    d->show();
}

void TrayIcon::sysRemove()
{
    if ( !d )
        return;

    delete d;
    d = 0;
}

void TrayIcon::sysUpdateIcon()
{
    if ( !d )
        return;

    QPixmap pix = pm; //buildIcon(pm);
    d->setPixmap( pix );
    //d->setMask(*pix.mask());
    d->repaint();
}

void TrayIcon::sysUpdateToolTip()
{
    if ( !d )
        return;

    if(tip.isEmpty())
    {
        QToolTip::remove( d );
    }
    else
    {
        QToolTip::add( d, tip );
    }
}
