/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMSMANAGERSMSRECEIVER_H
#define SMSMANAGERSMSRECEIVER_H

#include <qobject.h>
#include <qprocess.h>
#include "smsmessage.h"
#include <qstringlist.h>
#include <qtimer.h>
#include <qregexp.h>
#include "qwaitingbox.h"

/*
	"Message type: SMS-DELIVER\n"
	"SC address: '33689004000'\n"
	"More messages to send: 1\n"
	"Reply path: 0\n"
	"User data header indicator: 0\n"
	"Status report indication: 0\n"
	"Originating address: '33682619704'\n"
	"Protocol identifier: 0x0\n"
	"Data coding scheme: default alphabet\n"
	"SC timestamp: 01.04.2005 16:15:43 (+0200)\n"
	"User data length: 13\n"
	"User data header: 0x\n"
	"User data: 'test final :)'\n"
*/
#define MESSAGE_PATTERN QString("*---------------------\n*:*\n---------------------*")
#define SMSH_MESSAGE_TYPE QString("Message type")
#define SMSH_SENDER QString("Originating address")
#define SMSH_DATA_LENGTH QString("User data length")
#define SMSH_DATA_HEADER QString("User data header")
#define SMSH_DATA_DATA QString("User data")

#include "misch.h"

extern QApplication* current_app;

namespace SMSManager {

/**
@author GUILLAUME Nicolas
*/
	class SMSReceiver : public QObject
	{
	Q_OBJECT
	
	private:
		QProcess *deamon;
		SMSDeviceConfig dev_cfg;
		bool flag_stop;
		bool flag_stop_wanted;
		SMSMessage createSMSMessage(const QString&);
		
	private slots:
		void readFromStdout();
		void readFromStderr();
		void processExited();
		void timeOut();
		
	signals:
		void incomingSMS(SMSManager::SMSMessage);
		void stopped();
		void deamonError(const QString&);
	public:
		SMSReceiver(const SMSDeviceConfig& cfg, QObject *parent = 0, const char *name = 0);
		~SMSReceiver();
	
		bool isRunning();
		bool start();
		void stop();
	
	};

};

#endif
