/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MISCH_H
#define MISCH_H

#include <qstring.h>
//APP INFO

#define APP_NAME "SMS Manager"
#define APP_VERSION_MAJOR 1
#define APP_VERSION_MINOR 0
#define APP_VERSION_REVISION 3
#define APP_VERSION_COMMENT "(alpha)"
#define APP_VERSION QString("%1.%2.%3 %4")	.arg(APP_VERSION_MAJOR) \
						.arg(APP_VERSION_MINOR) \
						.arg(APP_VERSION_REVISION) \
						.arg(APP_VERSION_COMMENT) \

//FIN APP INFO

//CONFIG

#define CFG_DIRNAME QDir::homeDirPath() + "/.SMSManager"
/*#if defined(Q_WS_X11)
#define CFG_DIRNAME "~/.SMSManager"
#endif

#ifdef Q_WS_WIN
#define CFG_DIRNAME "C:/SMSManager"
#endif*/

// la base ca avait un sens d'utiliser des strings
#define PREF_CT_PATTERN1 "PREF_CT_PATTERN1" //nom
#define PREF_CT_PATTERN2 "PREF_CT_PATTERN2" //numero
#define PREF_CT_PATTERN3 "PREF_CT_PATTERN3" //les 2

#define PREF_DEFAULT_IMG QString("popup_txt.png")
#define PREF_DEFAULT_SND QString("popup_snd.wav")

//FIN CONFIG

//DEBUG :

#include <iostream>

#define DB_MSG(txt) std::cout << "_DEBUG : " << txt << std::endl
#define DB_VAR(txt) std::cout << "_DEBUG_VAR : " << (#txt) << " = " << (txt) << std::endl
#define DB_MSG_D(txt) std::cout << "_DEAMON : " << txt << std::endl
#define DB_MSG_B(txt) std::cout << "_FILEBOX : " << txt << std::endl
#define DB_MSG_N(txt) std::cout << "_NEWSMS : " << txt << std::endl
#define DB_MSG_S(txt) std::cout << "_SMSCLS : " << txt << std::endl
#define DB_NI(fct) std::cout << "_Not Yet Implemented : " << fct << std::endl
#define DB_ERROR(txt) std::cerr << txt << std::endl;

//FIN DEBUG

//MISC

#define QSTRING_EMPTY QString("")
#define QSTRING_CHECK_NULL(str) (str).isNull() ? QSTRING_EMPTY : (str)

#define FMA_SEP QString("\",\"")
#define PB_SEP '|'

#define LV_HIDE_COLUMN(index) hideColumn(index)
#define LV_SHOW_COLUMN(index) setColumnWidth(index, 50)

#define ADD_QUOTE(txt) '"' << txt << '"'
#define ADD_QUOTE2(txt) '"' + txt + '"'

#define BT_INBOX 40
#define BT_OUTBOX 60
#define BT_SENTBOX 80
#define BT_BIN 100
#define BT_DRAFT 120
#define BT_CONTACTS 140

#define BT_INBOX_STR QString("inbox")
#define BT_OUTBOX_STR QString("outbox")
#define BT_SENTBOX_STR QString("sentbox")
#define BT_BIN_STR QString("bin")
#define BT_DRAFT_STR QString("draft")



namespace misc {
	QString index2pattern(int index);
	int pattern2index(const QString& pattern);
};

//FIN MISC

#endif // MISCH_H
