/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/

#include "formmain.h"
#include <iostream>

FormMain::FormMain(QWidget* parent, const char* name, WFlags fl)
: FormMainBase(parent,name,fl), flag_quit(false)
{
	using namespace SMSManager;
	
	this->setCaption( QString("%1 %2").arg(APP_NAME).arg(APP_VERSION) );
	
	//menus contextuels
	pop_systray = new QPopupMenu( this );
	pop_systrayAfficher_SMS_ManagerAction->addTo( pop_systray );
	pop_systray->insertSeparator();
	messageNouveau_messageAction->addTo( pop_systray );
	configurationConfigurerAction->addTo( pop_systray );
	pop_systray->insertSeparator();
	messageQuitterAction->addTo( pop_systray );
	
	pop_contact = new QPopupMenu( this );
	pop_contactEnvoyer_un_messageAction->addTo( pop_contact );
	pop_contact->insertSeparator();
	contactEditer_le_contactAction->addTo( pop_contact );
	contactSupprimerAction->addTo( pop_contact );
	pop_contact->insertSeparator();
	contactSupprimer_tout_les_contactsAction->addTo( pop_contact );
	contactSynchroniser_avec_le_tlphoneAction->addTo( pop_contact );
	
	pop_message = new QPopupMenu( this );
	messageRepondreAction->addTo( pop_message );
	messageTransmettreAction->addTo( pop_message );
	messageR_diterAction->addTo( pop_message );
	messageSupprimerAction->addTo( pop_message );
    
    	//system tray
	tray = new TrayIcon( *this->icon(), this->caption(), pop_systray, this  );
	tray->show();
	
	//gnr par Qt, utilis ici pr pouvoir mettre le setSorting() avt.
	lvTree->setSorting(-1);
	
	QListViewItem * item_3 = new QListViewItem( lvTree, 0 );
	item_3->setPixmap( 0, QPixmap::fromMimeSource("home_2222.png") );
	item_3->setText( 0,tr( "Tlphone" ));
	item_3->setOpen( true );
	
	QListViewItem * item_2 = new QListViewItem( item_3, 0 );
	item_2->setPixmap( 0, QPixmap::fromMimeSource("local_folder_1616.png") );
	item_2->setText( 0,tr( "Dossiers locaux" ));
	item_2->setOpen( true );
	
	QListViewItem * item = new QListViewItem( item_2, 0 );
	item->setText( 0,tr( "Bote de rception" ));
	item->setPixmap( 0, QPixmap::fromMimeSource("folder_inbox_1616.png") );
	
	item = new QListViewItem( item_2, item );
	item->setText( 0, tr( "Bote d'envoi" ) );
	item->setPixmap( 0, QPixmap::fromMimeSource("folder_outbox_1616.png") );
	
	item = new QListViewItem( item_2, item );
	item->setText( 0, tr( "Messages envoys" ) );
	item->setPixmap( 0, QPixmap::fromMimeSource("folder_sent_mail_1616.png") );
	
	item = new QListViewItem( item_2, item );
	item->setText( 0, tr( "Corbeille" ) );
	item->setPixmap( 0, QPixmap::fromMimeSource("trashcan_empty_1616.png") );

	item = new QListViewItem( item_2, item );
	item->setText( 0, tr( "Brouillons" ) );
	item->setPixmap( 0, QPixmap::fromMimeSource("draft_1616.png") );
	
	contact_item = new QListViewItem( item_3, item_2 );
	contact_item->setText( 0, tr( "Contacts" ) );
	contact_item->setPixmap( 0, QPixmap::fromMimeSource("2guys_1616.png") );
	contact_item->setOpen( true );
	
	current_contacts.loadFromFile( cfg.phoneBookFilePath() );

	refreshContactList();

	DB_MSG_D("creating deamon");
	sms_deamon = new SMSReceiver( cfg.deviceConfig() , this);

	connect( sms_deamon, SIGNAL(incomingSMS(SMSManager::SMSMessage)),
		this, SLOT(incomingSMS(SMSManager::SMSMessage)) );

	connect( sms_deamon, SIGNAL(stopped()),
		this, SLOT(deamonStopped()) );

	connect( sms_deamon, SIGNAL(deamonError(const QString&)),
		this, SLOT(deamonError(const QString&)) );

#if defined(DEAMON_ACTIVE)
	DB_MSG_D("starting deamon");
	if ( cfg.autoStartDeamon() )
		startDeamon();
#endif

	openBox(BT_INBOX_STR);

	QTimer::singleShot( 1500, this, SLOT( sendWaitingMessages() ) );

	if( cfg.startMin() )
		QTimer::singleShot( 100, this, SLOT( close() ) );
}

FormMain::~FormMain()
{
	//current_contacts.replaceIndex();
	current_contacts.saveToFile();
	
	for(std::vector<QWidget*>::iterator it = child.begin(); it != child.end(); it++)
	{
		if( (*it) != NULL)
		{
			(*it)->close();
			delete (*it);
		}
	}
	child.clear();
	DB_MSG_D("stopping deamon");

	stopDeamon();
}

void FormMain::startDeamon()
{
	DB_MSG_D("starting deamon");
	if( sms_deamon->isRunning() )
		QMessageBox::information(0, tr("Dmon"),
					    tr("Le dmon est dj dmarr !"));
	else
	{
		if (sms_deamon->start())
		{
			deamon1Action->setEnabled(false);
			deamon2Action->setEnabled(true);
		}
		else
		{
			QMessageBox::warning(0, tr("Erreur"),
						tr("Impossible de dmarrer le dmon de rception des messages !"));
		}
	}
}

void FormMain::stopDeamon()
{
	if( sms_deamon->isRunning() )
		sms_deamon->stop();
		
	deamon1Action->setEnabled(true);
	deamon2Action->setEnabled(false);
}

void FormMain::deamonStopped()
{
	stopDeamon();
}

void FormMain::actionQuit()
{
	flag_quit = true;
	this->close();
}

void FormMain::closeEvent(QCloseEvent* e)
{
	this->hide();
	
	if(flag_quit)
		e->accept();
	else
		e->ignore();
}

void FormMain::refreshContactList()
{
	QListViewItemIterator it(lvTree);
	while ( it.current() )
	{
		if( it.current()->parent() == contact_item )
			delete it.current();
		it++;
	}
	
	current_contacts.sortContacts();
    
	static QPixmap icon = QPixmap::fromMimeSource("1guys_1616.png");
	static QPixmap icon2 = QPixmap::fromMimeSource("phone_1616.png");
	
	QString last_name(QSTRING_EMPTY);
	QListViewItem *contact_name = contact_item;
	
	for(int i = 0; i < current_contacts.contactsCount(); i++)
	{
		SMSManager::SMSContact contact_d( current_contacts.contact(i) );
		
		
		if(last_name != contact_d.Name)
		{
			contact_name = new QListViewItem(contact_item, contact_name);
			contact_name->setText(0,  contact_d.Name);
			contact_name->setPixmap(0,  icon);
		}
		
		(new QListViewItemTagInt(contact_name, i, contact_d.Address))->setPixmap(0, icon2);
		
		last_name = contact_d.Name;
	}
}

void FormMain::openBox(const QString& name)
{
	DB_MSG_B("openBox(" << name << ")");
	
	current_box_id = name;

	/*DB_MSG("lvMessages->LV_HIDE_COLUMN(0);");
	DB_MSG("lvMessages->LV_HIDE_COLUMN(1);");
	
	if( name == BT_INBOX_STR ||  name == BT_BIN_STR )
		DB_MSG("lvMessages->LV_SHOW_COLUMN(0);");
	
	if( name == BT_OUTBOX_STR || name == BT_BIN_STR ||
	    name == BT_DRAFT_STR || name == BT_SENTBOX_STR )
		DB_MSG("lvMessages->LV_SHOW_COLUMN(1);");*/
	
	lvMessages->clear();
	current_box.clear();
	txtShow->setText( tr("<font color=grey><i>Slectionnez un message  afficher.</i></font>") );
	
	DB_MSG_B(cfg.boxFilePath(name));
	
	current_box.refreshFromFile(cfg.boxFilePath(name));
	for(int i = 0; i < current_box.messagesCount(); i++)
	{
		addMessageToLV( current_box.message(i), i );
	}
}

void FormMain::addMessageToLV(const SMSManager::SMSMessage& s_sms, int index)
{
	static QPixmap icon_mail( QPixmap::fromMimeSource("mail_1616.png") );
	
	SMSManager::SMSMessage sms(s_sms);
	
	sms.setTo( current_contacts.getContactName( sms.to() , false) );
	sms.setFrom( current_contacts.getContactName( sms.from() , false) );
	
	current_box.setMessage( index, sms );
	
	(new QListViewItemSMS( lvMessages, sms, index, cfg.contactPattern() ))->setPixmap(2, icon_mail);
}

void FormMain::createSMSWin(const QString& num, const QString& msg)
{
	FormNew* frm = new FormNew( 0, num, msg );
	
	connect( frm, SIGNAL(messageReady(SMSManager::SMSMessage)),
		this, SLOT(newMessageToSend(SMSManager::SMSMessage)) );

	connect( frm, SIGNAL(messageInDraft(SMSManager::SMSMessage)),
		this, SLOT(newDraftToSave(SMSManager::SMSMessage)) );
				
	child.push_back( frm );
	frm->show();
}

void FormMain::lvDblClick(QListViewItem* lv_item)
{
	QListViewItemSMS* item = dynamic_cast<QListViewItemSMS*>(lv_item);
	if(item != NULL)
	{
		txtShow->setText( current_box.message( item->index() ).toStringHTML() );
	}
}

void FormMain::actionNewClick()
{
	createSMSWin();
}

void FormMain::actionReplyClick()
{
	QListViewItemSMS* item = dynamic_cast<QListViewItemSMS*>( lvMessages->currentItem() );
	if(item != NULL)
		createSMSWin( current_box.message( item->index() ).from().Address );
}

void FormMain::actionFwClick()
{
	QListViewItemSMS* item = dynamic_cast<QListViewItemSMS*>( lvMessages->currentItem() );
	if(item != NULL)
		createSMSWin( QSTRING_EMPTY, current_box.message( item->index() ).message() );
}

void FormMain::addMessageInBox(const QString& box, const SMSManager::SMSMessage& sms)
{
	if(current_box_id == box)
	{
		current_box.addMessage( sms );
		addMessageToLV( sms, (current_box.messagesCount()) - 1 );
		current_box.saveToFile();
	}
	else
	{
		BoxFile tmp;
		tmp.refreshFromFile( cfg.boxFilePath(box) );
		tmp.addMessage( sms );
		tmp.saveToFile();
	}
}

void FormMain::showPopup()
{
	QPopupDialog* frm = new QPopupDialog(cfg.popupPixmap(), cfg.popupSound(), 0);
	
	connect( frm, SIGNAL(popupClicked()),
		 this, SLOT(popupClicked()) );
	
	frm->show();
	child.push_back(frm);
}

void FormMain::incomingSMS(SMSManager::SMSMessage sms)
{
	DB_MSG_N( "incomingSMS(\"" << sms.message() << "\")" );
	
	sms.setTo( cfg.localContact() );
	
	if(cfg.prefixIncomingNumber())
	{
		SMSManager::SMSContact from( sms.from() );
		from.Address = '+' + from.Address;
		sms.setFrom( from );
	}
		
	addMessageInBox(BT_INBOX_STR, sms);
	
	showPopup();
}

void FormMain::deamonError(const QString& str)
{
	if(cfg.showDeamonError())
		QMessageBox::warning(this, tr("Erreur"), str);
		
	DB_MSG_D( str );
}

void FormMain::newDraftToSave(SMSManager::SMSMessage sms)
{
	sms.setFrom( cfg.localContact() );
	addMessageInBox(BT_DRAFT_STR, sms);
}

void FormMain::newMessageToSend(SMSManager::SMSMessage sms)
{
	DB_MSG( "newMessageToSend(\"" << sms.message() << "\")" );
	
	sms.setFrom( cfg.localContact() );
	addMessageInBox(BT_OUTBOX_STR, sms);
	
	QTimer::singleShot( 800, this, SLOT( sendWaitingMessages() ) );

}

void FormMain::sendWaitingMessages()
{
	//on peut tt relire mm si elle est affiche
	//y aura jms bcp de message ds la boite d'envoi
	BoxFile box;
	box.refreshFromFile( cfg.boxFilePath(BT_OUTBOX_STR) );
	
	
	int mcount = box.messagesCount();
	if( mcount > 0 )
	{
		for(int i = 0; i < mcount; i++)
		{
			statusBar()->message( tr("Envoi du message %1 sur %2 en cours...")
								.arg(i + 1)
								.arg(mcount)
					);
			SMSManager::SMSMessage sms(box.message(i));
			if( !sms.sendSMS( cfg.deviceConfig() ) )
			{
				QMessageBox::warning(this, tr("Erreur"),
						tr("Envoi du message %1 chou !").arg(i + 1) );
				return;
			}
			
			addMessageInBox(BT_SENTBOX_STR, sms);
		}
		
		box.removeAll();
		box.saveToFile();
		
		if( current_box_id == BT_OUTBOX_STR )
			openBox(BT_OUTBOX_STR);
		
		statusBar()->message( tr("Envois termins.") );
	}
}

void FormMain::tvClick(QListViewItem* item)
{
	if(item != NULL)
	{
		DB_MSG(item->itemPos());
		switch(item->itemPos())
		{
			case BT_INBOX:
				openBox(BT_INBOX_STR);
				break;
			case BT_OUTBOX:
				openBox(BT_OUTBOX_STR);
				break;
			case BT_SENTBOX:
				openBox(BT_SENTBOX_STR);
				break;
			case BT_BIN:
				openBox(BT_BIN_STR);
				break;	
			case BT_DRAFT:
				openBox(BT_DRAFT_STR);
				break;	
			default:
				QListViewItemTagInt* c_item = dynamic_cast<QListViewItemTagInt*>(item);
				if(c_item != NULL)
					statusBar()->message(
						current_contacts.contact( c_item->tag() ).toString()
							    );
		}
	}
}

void FormMain::actionRedit()
{
	QListViewItemSMS* item = dynamic_cast<QListViewItemSMS*>( lvMessages->currentItem() );
	if(item != NULL)
		createSMSWin( current_box.message( item->index() ).to().Address,
			      current_box.message( item->index() ).message() );
}

void FormMain::actionNewContact()
{
	NewContact frm(&current_contacts, QSTRING_EMPTY, this);
	
	if (frm.exec() )
		refreshContactList();
}

QString FormMain::getSelectedContactName() const
{
	QString strName;
	QListViewItem *item = lvTree->currentItem();
	//on a slectionn qqch ?
	if(item != NULL)
	{
		//on a slectionn un numro ?
		QListViewItemTagInt* c_item = dynamic_cast<QListViewItemTagInt*>(item);
		
		if(c_item != NULL)
		{
			strName = current_contacts.contact( c_item->tag() ).Name;
		}
		else //on a slectionn un nom ?
		{
			if( item->parent() == contact_item )
				strName = item->text(0);
		}
	}
	return strName;
}

QString FormMain::getSelectedContactAddress() const
{
	QString strNum;
	QListViewItem *item = lvTree->currentItem();
	//on a slectionn qqch ?
	if(item != NULL)
	{
		//on a slectionn un numro ?
		QListViewItemTagInt* c_item = dynamic_cast<QListViewItemTagInt*>(item);
		
		if(c_item != NULL)
		{
			strNum = c_item->text(0);
		}
		else //on a slectionn un nom ?
		{
			if( item->parent() == contact_item )
			{
				//alors on prend le premier enfant (donc numro)
				//normalement il existe toujours mais en sait jms...
				item = item->firstChild();
				if(item != NULL)
					strNum = item->text(0);
			}
		}
	}
	return strNum;
}

void FormMain::actionModifContact()
{
	QString strName( getSelectedContactName() );
	
	if( !strName.isEmpty() )
	{
		NewContact frm(&current_contacts, strName, this);
	
		if (frm.exec() )
			refreshContactList();
	}
	else
		QMessageBox::warning(0, tr("Erreur"),
					tr("Veuillez slectionner un contact !") );

}

void FormMain::actionDelContact()
{
	QString strName( getSelectedContactName() );
	
	if( !strName.isEmpty() )
	{
		if( !QMessageBox::question( this,tr("Suppression"),
	    		tr("Voulez-vous vraiment supprimer le contact '%1' ?").arg(strName),
            		tr("&Oui"), tr("&Non"), QString::null, 0, 1 ) )
		{
			bool delete_more = true;
			while(delete_more)
			{
				delete_more = false;
				for(int i = 0; i < current_contacts.contactsCount(); i++)
				{	
					if( current_contacts.contact(i).Name == strName)
					{
						current_contacts.removeContact(i);
						delete_more = true;
					}
				}
			}
			refreshContactList();
		}
	}
	else
		QMessageBox::warning(0, tr("Erreur"),
					tr("Veuillez slectionner un contact !") );

}

void FormMain::actionImportContactPhone()
{
	statusBar()->message( tr( "Importation des contacts en cours..."  ));
	
	current_contacts.importFromPhone( cfg.deviceConfig(), cfg.remotePhoneBook() );
	
	refreshContactList();
	
	statusBar()->message( tr( "Importation termine." ) );
}

void FormMain::actionImportContactFile()
{
	DB_NI("void FormMain::actionImportContactFile()");
}

void FormMain::actionExportContactFile()
{
	DB_NI("void FormMain::actionExportContactFile()");
}

void FormMain::actionExportContactPhone()
{
	DB_NI("void FormMain::actionExportContactPhone()");
}

void FormMain::actionSyncContact()
{
	DB_NI("void FormMain::actionSyncContact()");
}

void FormMain::actionImportMess()
{
	DB_NI("void FormMain::actionImportMess()");
}

void FormMain::actionExportMess()
{
	DB_NI("void FormMain::actionExportMess()");
}

void FormMain::actionConfig()
{
	FormCfg frm(this, &cfg);
	frm.exec();
}

void FormMain::actionDelete()
{
	QListViewItemSMS* item = dynamic_cast<QListViewItemSMS*>( lvMessages->currentItem() );
	if(item != NULL)
	{
		//on est ds la corbeille ?
		if(current_box_id == BT_BIN_STR)
		{
			if( !QMessageBox::question( this,tr("Suppression"),
				tr("Supprimer dfinitivement le message ?"),
				tr("&Oui"), tr("&Non"), QString::null, 0, 1 ) )
			{
				current_box.removeMessage( item->index() );
				current_box.saveToFile();
				openBox(BT_BIN_STR);
			}
		}
		else
		{
			if( !QMessageBox::question( this,tr("Suppression"),
				tr("Envoyer le message  la corbeille ?"),
				tr("&Oui"), tr("&Non"), QString::null, 0, 1 ) )
			{
				SMSManager::SMSMessage sms( current_box.message( item->index() ) );
				addMessageInBox(BT_BIN_STR, sms);
				current_box.removeMessage( item->index() );
				current_box.saveToFile();
				openBox(current_box_id);
			}
		}
	}
}


void FormMain::actionDeleteAllContact()
{
	if( !QMessageBox::question( this,tr("Suppression"),
	    tr("Ceci va supprimer tous les contacts, tes-vous sr ?"),
            tr("&Oui"), tr("&Non"), QString::null, 0, 1 ) )
	{
		current_contacts.removeAll();
		refreshContactList();
	}
}

void FormMain::popupClicked()
{
	show();
	openBox( BT_INBOX_STR );
}

void FormMain::actionShowHide()
{
	if( isVisible() )
		hide();
	else
		show();
}

void FormMain::actionNewContactMess()
{
	QString strNum( getSelectedContactAddress() );
	
	if( !strNum.isEmpty() )
		createSMSWin( strNum );
}

void FormMain::lvMessRightClick( QListViewItem* item, const QPoint& pt)
{
	if( item != NULL )
		pop_message->popup(pt);
}

void FormMain::lvTreeRightClick( QListViewItem* item, const QPoint& pt)
{
	//on a bien un contact ?
	if( item != NULL && !getSelectedContactName().isEmpty() )
		pop_contact->popup(pt);
}

void FormMain::actionAbout()
{
	QMessageBox::about(this, aideAProposAction->text(), tr("<b>SMS Manager</b> - Gestion de l'envoi et de la rception  travers un tlphone mobile ou un modem.<br><br>Logiciel libre sous licence <b>GPL</b><br><br><i>Copyright  Nicolas GUILLAUME 2005</i>") );
}


/*$SPECIALIZATION$*/


