# The Config class defines settings specific to the StorageMode.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::StorageMode::Config;

our @ISA = qw(CMSsh::Config);

use strict;
use utf8;

################################################################################
# Configuration parameters

my $settings = {
    DIR_STORAGE =>       'storage',
};

################################################################################
# Do not edit below this line

sub new ($) {
    my ($class_name) = @_;

    my $self = CMSsh::Config->new;

    $self->_install_gloss($settings);
    $self->_install_param('ROOT_STORAGE', $self->get('ROOT_HTDOCS') . '/' .
                                          $self->get('DIR_STORAGE'));

    bless $self, $class_name;
    return $self;
}

1
