# ImgManager handles administration requests related to images.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::GalleryMode::ImgManager;

our @ISA = qw(CMSsh::Administration::PublicationManager);

use strict;
use CMSsh::Administration::PublicationManager;
use CMSsh::GalleryMode::Messages;
use CMSsh::GalleryMode::Config;
use CMSsh::GalleryMode::Image;
use CMSsh::GalleryMode::Album;

my $Msg = CMSsh::GalleryMode::Messages->new;
my $Cfg = CMSsh::GalleryMode::Config->new;

sub new ($) {
    my ($class_name, $mode) = @_;

    my $self = CMSsh::Administration::PublicationManager->new($mode);
    $self->{_syntax}->{mk} = { handler => sub { $self->_mk(@_) },
                               src => { is_file_path => 1 },
                               dst => 1 };

    bless $self, $class_name;
    return $self;
}

sub get_symbol (;$) {
    return 'i';
}

sub get_pub_type (;$) {
    return CMSsh::GalleryMode::Image->get_type;
}

sub _mk ($$) {
    my ($self, $params) = @_;

    my $dest_alb = CMSsh::GalleryMode::Album->new($params->{dst})
        or die $Msg->get('WRONG_DST');

    foreach (@{$params->{src}}) {
        my $file = $self->_get_input_file($_);
        my $img_file = CMSsh::FileSystem::ImgFile->new($file->get_path)
            or die $Msg->get('CANT_INST_FSO', $file->get_path);

        $dest_alb->create_subimg($img_file) or die $Msg->get('CANT_MAKE_PUB');
    }
}

1
