# TypedFile binds an extention to a particular file type.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::FileSystem::TypedFile;

our @ISA = qw(CMSsh::FileSystem::File);

use strict;
use CMSsh::FileSystem::File;
use CMSsh::Messages;

my $Msg = CMSsh::Messages->new;

sub new ($$$) {
    my ($class_name, $abs_path, $ext) = @_;

    my $self = CMSsh::FileSystem::File->new($abs_path);
    unless ($self) {
        warn $Msg->get('CANT_INST_FSO', $abs_path);
        return undef;
    }
    unless ($ext eq $self->get_ext) {
        warn $Msg->get('WRONG_SRC_EXT', $ext);
        return undef;
    }
    
    bless $self, $class_name;
    return $self;
}

# This method is static for typed files
sub get_ext () {
    die $Msg->get('ABSTRACT_CLASS');
}

sub rename ($$) {
    my ($self, $new_basename) = @_;
    return $self->SUPER::rename($new_basename . '.' . $self->get_ext);
}

1
