# ImgFile is a type of file. On the file system layer it contains an image.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::FileSystem::ImgFile;

our @ISA = qw(CMSsh::FileSystem::TypedFile);

use strict;
use GD;
use CMSsh::FileSystem::TypedFile;
use CMSsh::Config;
use CMSsh::Messages;

my $Msg = CMSsh::Messages->new;
my $Cfg = CMSsh::Config->new;

sub new ($$) {
    my ($class_name, $abs_path) = @_;

    my $self = CMSsh::FileSystem::TypedFile->new($abs_path, get_ext());
    unless ($self) {
        warn $Msg->get('CANT_INST_FSO', $abs_path);
        return undef;
    }

    bless $self, $class_name;
    return $self;
}

sub get_ext (;$) {
    return $Cfg->get('EXT_IMG');
}

sub copy_resized ($$$$) {
    my ($self, $dest_dir, $img_width, $img_height) = @_;

    GD::Image->trueColor(1);

    my $this_img = GD::Image->new($self->{_path});
    unless ($this_img) {
        warn $Msg->get('CANT_INST_GD_IMG', $self->{_path});
        return 0;
    }

    if ($this_img->width > $this_img->height) {
        $img_height = ($this_img->height / $this_img->width) * $img_width;
    } else {
        $img_width = ($this_img->width / $this_img->height) * $img_height;
    }
    my $dest_img = GD::Image->new($img_width, $img_height, 1);
    unless ($dest_img) {
        warn $Msg->get('CANT_INST_GD_IMG', "$img_width, $img_height");
        return 0;
    }

    $dest_img->copyResampled($this_img, 0, 0, 0, 0,
                             $dest_img->getBounds, $this_img->getBounds);

    open(DST, '>', $dest_dir->get_path . '/' . $self->{_name})
    or do {
        warn $Msg->get('LOW_LEVEL_IO_ERR', $!);
        return 0;
    };
    binmode DST;
    print DST $dest_img->jpeg($Cfg->get('IMG_QUALITY'));
    close DST;

    return 1; 
};

1
