#!/usr/bin/perl -w

# video.pl shows a single video file or provides a download link if html5 video
# is not supported by user agent.
#
# Accepts one mandatory parameter:
#   path - encoded URI to a video to be shown.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

BEGIN {
    push (@INC, "../lib");
}

use 5.8.8;
use strict;
use CGI;
use CMSsh::Presentation::TemplateHandler;
use CMSsh::Presentation::Utils qw(cgi_die);
use CMSsh::VideoMode;

my $mode = CMSsh::VideoMode->new;
my $msg = $mode->get_messages;
my $cfg = $mode->get_config;

my $cgi = CGI->new;
my $uri = '/' . ($cgi->param('path') || '');

my $publication = $mode->find_publication($uri);
cgi_die $msg->get('CANT_FIND_PUB') unless ($publication);
cgi_die $msg->get('UNKNOWN_PUB_TYPE',
                  $publication->get_uri, $publication->get_type)
    unless ($publication->get_type eq 'VideoMode::Video');

my $view = $publication->get_view;
my $vars = {
    video => $view,
    title => 'Video - ' . $view->{caption},
};

my $th = CMSsh::Presentation::TemplateHandler->new($mode->get_view);
$th->process('video', $vars, $publication);

