/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame3.driver;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.openrdf.OpenRDFUtil;
import org.openrdf.query.QueryLanguage;
import org.openrdf.repository.RepositoryMetaData;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.openrdf.sail.helpers.SailMetaDataImpl;
import virtuoso.sesame3.driver.VirtuosoRepository;

public class VirtuosoRepositoryMetaData
implements RepositoryMetaData {
    private VirtuosoRepository repository;

    VirtuosoRepositoryMetaData(VirtuosoRepository virtuosoRepository) {
        this.repository = virtuosoRepository;
    }

    public String[] getInferenceRules() {
        return new String[0];
    }

    public URL getLocation() {
        return null;
    }

    public int getMaxLiteralLength() {
        return 0;
    }

    public int getMaxURILength() {
        return 0;
    }

    public String[] getQueryFunctions() {
        return new String[0];
    }

    public String[] getReasoners() {
        return new String[0];
    }

    public int getSesameMajorVersion() {
        String string = this.getSesameVersion();
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(46);
        if (n < 0) {
            return 0;
        }
        try {
            return Integer.parseInt(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getSesameMinorVersion() {
        String string = this.getSesameVersion();
        if (string == null) {
            return 0;
        }
        int n = string.indexOf(46);
        if (n < 0) {
            return 0;
        }
        int n2 = string.indexOf(46, n + 1);
        int n3 = string.indexOf(45, n + 1);
        if (n2 < 0 && n3 < 0) {
            return 0;
        }
        int n4 = 0 < n2 && n2 < n3 ? n2 : n3;
        try {
            return Integer.parseInt(string.substring(n + 1, n4));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getSesameVersion() {
        return OpenRDFUtil.findVersion(SailMetaDataImpl.class, (String)"org.openrdf.sesame", (String)"sesame-sail-api");
    }

    public boolean isHierarchicalInferencing() {
        return false;
    }

    public boolean isInferencing() {
        return false;
    }

    public boolean isMatchingOnlySameTerm() {
        return false;
    }

    public boolean isOWLInferencing() {
        return false;
    }

    public boolean isRDFSInferencing() {
        return false;
    }

    public QueryLanguage[] getQueryLanguages() {
        QueryLanguage[] queryLanguageArray = new QueryLanguage[]{QueryLanguage.SPARQL};
        return queryLanguageArray;
    }

    public RDFFormat[] getAddRDFFormats() {
        Collection collection = RDFParserRegistry.getInstance().getAll();
        ArrayList<RDFFormat> arrayList = new ArrayList<RDFFormat>(collection.size());
        for (RDFParserFactory rDFParserFactory : collection) {
            arrayList.add(rDFParserFactory.getRDFFormat());
        }
        return arrayList.toArray(new RDFFormat[arrayList.size()]);
    }

    public RDFFormat[] getExportRDFFormats() {
        Collection collection = RDFWriterRegistry.getInstance().getAll();
        ArrayList<RDFFormat> arrayList = new ArrayList<RDFFormat>(collection.size());
        for (RDFWriterFactory rDFWriterFactory : collection) {
            arrayList.add(rDFWriterFactory.getRDFFormat());
        }
        return arrayList.toArray(new RDFFormat[arrayList.size()]);
    }

    public boolean isRemoteDatasetSupported() {
        return true;
    }

    public boolean isReadOnly() {
        return this.repository.isReadOnly();
    }

    public boolean isEmbedded() {
        return false;
    }

    public String getStoreName() {
        return "Virtuoso";
    }

    public String getStoreVersion() {
        return "1.1";
    }

    public int getStoreMajorVersion() {
        return 1;
    }

    public int getStoreMinorVersion() {
        return 1;
    }

    public boolean isContextSupported() {
        return true;
    }

    public boolean isContextBNodesSupported() {
        return true;
    }

    public boolean isBNodeIDPreserved() {
        return false;
    }

    public boolean isLiteralDatatypePreserved() {
        return true;
    }

    public boolean isLiteralLabelPreserved() {
        return true;
    }
}

