/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiAttributeSet
implements AttributeSet {
    AttributeSet[] multi;

    MultiAttributeSet() {
    }

    MultiAttributeSet(AttributeSet[] m) {
        this.init(m);
    }

    void init(AttributeSet[] m) {
        this.multi = m;
    }

    @Override
    public boolean containsAttribute(Object name, Object value) {
        boolean ret = false;
        int i = 0;
        while (i < this.multi.length && !ret) {
            if (this.multi[i].containsAttribute(name, value)) {
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    @Override
    public boolean containsAttributes(AttributeSet attributes) {
        boolean ret = true;
        Enumeration<?> e = attributes.getAttributeNames();
        while (ret && e.hasMoreElements()) {
            Object key = e.nextElement();
            ret = attributes.getAttribute(key).equals(this.getAttribute(key));
        }
        return ret;
    }

    @Override
    public AttributeSet copyAttributes() {
        SimpleAttributeSet copy = new SimpleAttributeSet();
        int i = 0;
        while (i < this.multi.length) {
            copy.addAttributes(this.multi[i]);
            ++i;
        }
        return copy;
    }

    @Override
    public Object getAttribute(Object key) {
        Object ret = null;
        int i = 0;
        while (i < this.multi.length && ret == null) {
            ret = this.multi[i].getAttribute(key);
            ++i;
        }
        return ret;
    }

    @Override
    public int getAttributeCount() {
        int n = 0;
        int i = 0;
        while (i < this.multi.length) {
            n += this.multi[i].getAttributeCount();
            ++i;
        }
        return n;
    }

    @Override
    public Enumeration<?> getAttributeNames() {
        return new MultiNameEnumeration();
    }

    @Override
    public AttributeSet getResolveParent() {
        return null;
    }

    @Override
    public boolean isDefined(Object attrName) {
        boolean ret = false;
        int i = 0;
        while (i < this.multi.length && !ret) {
            ret = this.multi[i].isDefined(attrName);
            ++i;
        }
        return ret;
    }

    @Override
    public boolean isEqual(AttributeSet attr) {
        return this.getAttributeCount() == attr.getAttributeCount() && this.containsAttributes(attr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiNameEnumeration
    implements Enumeration<Object> {
        private int index = 0;
        private Enumeration<?> current;

        MultiNameEnumeration() {
            this.current = MultiAttributeSet.this.multi[0].getAttributeNames();
        }

        @Override
        public boolean hasMoreElements() {
            return this.current.hasMoreElements() || this.index < MultiAttributeSet.this.multi.length - 1;
        }

        @Override
        public Object nextElement() {
            if (!this.current.hasMoreElements()) {
                if (this.index < MultiAttributeSet.this.multi.length - 1) {
                    ++this.index;
                    this.current = MultiAttributeSet.this.multi[this.index].getAttributeNames();
                } else {
                    throw new NoSuchElementException();
                }
            }
            return this.current.nextElement();
        }
    }
}

