/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    private static final String SERVICE = "Cipher";
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int PUBLIC_KEY = 1;
    public static final int SECRET_KEY = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static final int INITIAL_STATE = 0;
    private CipherSpi cipherSpi;
    private Provider provider;
    private String transformation;
    private int state;

    public static final Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        NoSuchPaddingException lastPaddingException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return Cipher.getInstance(transformation, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                lastPaddingException = null;
            }
            catch (NoSuchPaddingException x) {
                lastPaddingException = x;
            }
            ++i;
        }
        if (lastPaddingException != null) {
            throw lastPaddingException;
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(transformation);
    }

    public static final Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Cipher.getInstance(transformation, p);
    }

    public static final Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Exception cause;
        StringBuilder sb = new StringBuilder().append("Cipher transformation [").append(transformation).append("] from provider [").append(provider).append("] ");
        if (transformation.indexOf(47) < 0) {
            try {
                Object spi = Engine.getInstance(SERVICE, transformation, provider);
                return new Cipher((CipherSpi)spi, provider, transformation);
            }
            catch (Exception e) {
                if (e instanceof NoSuchAlgorithmException) {
                    throw (NoSuchAlgorithmException)e;
                }
                cause = e;
            }
        } else {
            StringTokenizer tok = new StringTokenizer(transformation, "/");
            if (tok.countTokens() != 3) {
                throw new NoSuchAlgorithmException(sb.append("is malformed").toString());
            }
            String alg = tok.nextToken();
            String mode = tok.nextToken();
            String pad = tok.nextToken();
            try {
                Object spi = Engine.getInstance(SERVICE, transformation, provider);
                return new Cipher((CipherSpi)spi, provider, transformation);
            }
            catch (Exception e) {
                cause = e;
                try {
                    Object spi = Engine.getInstance(SERVICE, String.valueOf(alg) + '/' + mode, provider);
                    CipherSpi result = (CipherSpi)spi;
                    result.engineSetPadding(pad);
                    return new Cipher(result, provider, transformation);
                }
                catch (Exception e2) {
                    if (e2 instanceof NoSuchPaddingException) {
                        throw (NoSuchPaddingException)e2;
                    }
                    cause = e2;
                    try {
                        Object spi = Engine.getInstance(SERVICE, String.valueOf(alg) + "//" + pad, provider);
                        CipherSpi result = (CipherSpi)spi;
                        result.engineSetMode(mode);
                        return new Cipher(result, provider, transformation);
                    }
                    catch (Exception e3) {
                        cause = e3;
                        try {
                            Object spi = Engine.getInstance(SERVICE, alg, provider);
                            CipherSpi result = (CipherSpi)spi;
                            result.engineSetMode(mode);
                            result.engineSetPadding(pad);
                            return new Cipher(result, provider, transformation);
                        }
                        catch (Exception e4) {
                            if (e4 instanceof NoSuchPaddingException) {
                                throw (NoSuchPaddingException)e4;
                            }
                            cause = e4;
                        }
                    }
                }
            }
        }
        sb.append("could not be created");
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = transformation;
        this.state = 0;
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetBlockSize();
        }
        return 1;
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final byte[] getIV() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetIV();
        }
        return null;
    }

    public final AlgorithmParameters getParameters() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetParameters();
        }
        return null;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(new byte[0], 0, 0);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLength) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipherSpi == null) {
            byte[] b = new byte[inputLength];
            System.arraycopy(input, inputOffset, b, 0, inputLength);
            return b;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLength);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.cipherSpi == null) {
            return 0;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineDoFinal(new byte[0], 0, 0, output, outputOffset);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.cipherSpi == null) {
            if (inputLength > output.length - outputOffset) {
                throw new ShortBufferException();
            }
            System.arraycopy(input, inputOffset, output, outputOffset, inputLength);
            return inputLength;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLength, output, outputOffset);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return this.doFinal(input, inputOffset, inputLength, output, 0);
    }

    public final int doFinal(ByteBuffer input, ByteBuffer output) throws ReadOnlyBufferException, ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (input == output) {
            throw new IllegalArgumentException("input and output buffers cannot be the same");
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("not initialized for encrypting or decrypting");
        }
        return this.cipherSpi.engineDoFinal(input, output);
    }

    public final int getOutputSize(int inputLength) throws IllegalStateException {
        if (this.cipherSpi == null) {
            return inputLength;
        }
        return this.cipherSpi.engineGetOutputSize(inputLength);
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        this.init(opmode, certificate, new SecureRandom());
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, new SecureRandom());
        }
        this.state = opmode;
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        boolean[] keyInfo;
        if (certificate instanceof X509Certificate && (keyInfo = ((X509Certificate)certificate).getKeyUsage()) != null) {
            switch (opmode) {
                case 2: {
                    if (!keyInfo[3]) {
                        throw new InvalidKeyException("the certificate's key cannot be used for transforming data");
                    }
                    if (!keyInfo[7]) break;
                    throw new InvalidKeyException("the certificate's key can only be used for encryption");
                }
                case 1: {
                    if (!keyInfo[3]) {
                        throw new InvalidKeyException("the certificate's key cannot be used for transforming data");
                    }
                    if (!keyInfo[8]) break;
                    throw new InvalidKeyException("the certificate's key can only be used for decryption");
                }
                case 4: {
                    if (keyInfo[2] && !keyInfo[7]) break;
                    throw new InvalidKeyException("the certificate's key cannot be used for key unwrapping");
                }
                case 3: {
                    if (keyInfo[2] && !keyInfo[8]) break;
                    throw new InvalidKeyException("the certificate's key cannot be used for key wrapping");
                }
            }
        }
        this.init(opmode, (Key)certificate.getPublicKey(), random);
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, random);
        }
        this.state = opmode;
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, params, new SecureRandom());
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, params, new SecureRandom());
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, params, random);
        }
        this.state = opmode;
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, params, random);
        }
        this.state = opmode;
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.cipherSpi == null) {
            return null;
        }
        if (this.state != 4) {
            throw new IllegalStateException("instance is not for unwrapping");
        }
        return this.cipherSpi.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public final byte[] update(byte[] input) throws IllegalStateException {
        return this.update(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLength) throws IllegalStateException {
        if (this.cipherSpi == null) {
            byte[] b = new byte[inputLength];
            System.arraycopy(input, inputOffset, b, 0, inputLength);
            return b;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("cipher is not for encrypting or decrypting");
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLength);
    }

    public final int update(byte[] input, int inputOffset, int inputLength, byte[] output) throws IllegalStateException, ShortBufferException {
        return this.update(input, inputOffset, inputLength, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException {
        if (this.cipherSpi == null) {
            if (inputLength > output.length - outputOffset) {
                throw new ShortBufferException();
            }
            System.arraycopy(input, inputOffset, output, outputOffset, inputLength);
            return inputLength;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("cipher is not for encrypting or decrypting");
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLength, output, outputOffset);
    }

    public final int update(ByteBuffer input, ByteBuffer output) throws ReadOnlyBufferException, ShortBufferException {
        if (input == output) {
            throw new IllegalArgumentException("input and output buffers must be different");
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("not initialized for encryption or decryption");
        }
        return this.cipherSpi.engineUpdate(input, output);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (this.cipherSpi == null) {
            return null;
        }
        if (this.state != 3) {
            throw new IllegalStateException("instance is not for key wrapping");
        }
        return this.cipherSpi.engineWrap(key);
    }
}

