/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.provider.DefaultPolicy;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Policy {
    private static Policy currentPolicy;
    private Map pd2pc = null;

    public static Policy getPolicy() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("getPolicy"));
        }
        return Policy.getCurrentPolicy();
    }

    public static void setPolicy(Policy policy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        Policy.setup(policy);
        currentPolicy = policy;
    }

    private static void setup(Policy policy) {
        ProtectionDomain pd;
        if (policy.pd2pc == null) {
            policy.pd2pc = Collections.synchronizedMap(new LinkedHashMap());
        }
        if ((pd = policy.getClass().getProtectionDomain()).getCodeSource() != null) {
            PermissionCollection pc = null;
            if (currentPolicy != null) {
                pc = currentPolicy.getPermissions(pd);
            }
            if (pc == null) {
                pc = new Permissions();
                pc.add(new AllPermission());
            }
            policy.pd2pc.put(pd, pc);
        }
    }

    static Policy getCurrentPolicy() {
        if (currentPolicy == null) {
            String pp = System.getProperty("policy.provider");
            if (pp != null) {
                try {
                    currentPolicy = (Policy)Class.forName(pp).newInstance();
                }
                catch (Exception exception) {}
            }
            if (currentPolicy == null) {
                currentPolicy = new DefaultPolicy();
            }
        }
        return currentPolicy;
    }

    static boolean isLoaded() {
        return currentPolicy != null;
    }

    public abstract PermissionCollection getPermissions(CodeSource var1);

    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection pc;
        PermissionCollection result;
        if (domain == null) {
            return new Permissions();
        }
        if (this.pd2pc == null) {
            Policy.setup(this);
        }
        if ((result = (PermissionCollection)this.pd2pc.get(domain)) != null) {
            Permissions realResult = new Permissions();
            Enumeration<Permission> e = result.elements();
            while (e.hasMoreElements()) {
                realResult.add(e.nextElement());
            }
            return realResult;
        }
        result = this.getPermissions(domain.getCodeSource());
        if (result == null) {
            result = new Permissions();
        }
        if ((pc = domain.getPermissions()) != null) {
            Enumeration<Permission> e = pc.elements();
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
        }
        return result;
    }

    public boolean implies(ProtectionDomain domain, Permission permission) {
        PermissionCollection pc;
        if (this.pd2pc == null) {
            Policy.setup(this);
        }
        if ((pc = (PermissionCollection)this.pd2pc.get(domain)) != null) {
            return pc.implies(permission);
        }
        boolean result = false;
        pc = this.getPermissions(domain);
        if (pc != null) {
            result = pc.implies(permission);
            this.pd2pc.put(domain, pc);
        }
        return result;
    }

    public abstract void refresh();
}

