/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.text.Collator;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Character
implements Serializable,
Comparable<Character> {
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final Class<Character> TYPE = VMClassLoader.getPrimitiveClass('C');
    public static final int SIZE = 16;
    private static final int MAX_CACHE = 127;
    private static Character[] charCache = new Character[128];
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte SURROGATE = 19;
    public static final byte PRIVATE_USE = 18;
    public static final byte UNASSIGNED = 0;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    private static final int TYPE_MASK = 31;
    private static final int NO_BREAK_MASK = 32;
    private static final int MIRROR_MASK = 64;

    private static native char readChar(char var0);

    private static native char readCodePoint(int var0);

    public Character(char value) {
        this.value = value;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Character && this.value == ((Character)o).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static String toString(char ch) {
        return String.valueOf(ch);
    }

    public static boolean isLowerCase(char ch) {
        return Character.getType(ch) == 2;
    }

    public static boolean isLowerCase(int codePoint) {
        return Character.getType(codePoint) == 2;
    }

    public static boolean isUpperCase(char ch) {
        return Character.getType(ch) == 1;
    }

    public static boolean isUpperCase(int codePoint) {
        return Character.getType(codePoint) == 1;
    }

    public static boolean isTitleCase(char ch) {
        return Character.getType(ch) == 3;
    }

    public static boolean isTitleCase(int codePoint) {
        return Character.getType(codePoint) == 3;
    }

    public static boolean isDigit(char ch) {
        return Character.getType(ch) == 9;
    }

    public static boolean isDigit(int codePoint) {
        return Character.getType(codePoint) == 9;
    }

    public static boolean isDefined(char ch) {
        return Character.getType(ch) != 0;
    }

    public static boolean isDefined(int codePoint) {
        return Character.getType(codePoint) != 0;
    }

    public static boolean isLetter(char ch) {
        return (1 << Character.getType(ch) & 0x3E) != 0;
    }

    public static boolean isLetter(int codePoint) {
        return (1 << Character.getType(codePoint) & 0x3E) != 0;
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        int len = seq.length();
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        int numToGo = codePointOffset;
        int offset = index;
        if (numToGo >= 0) {
            while (numToGo > 0) {
                --numToGo;
                if (Character.isHighSurrogate(seq.charAt(offset)) && offset + 1 < len && Character.isLowSurrogate(seq.charAt(offset + 1))) {
                    ++offset;
                }
                ++offset;
            }
            return offset;
        }
        numToGo *= -1;
        while (numToGo > 0) {
            --numToGo;
            if (!Character.isLowSurrogate(seq.charAt(--offset)) || offset - 1 < 0 || !Character.isHighSurrogate(seq.charAt(offset - 1))) continue;
            --offset;
        }
        return offset;
    }

    public static int offsetByCodePoints(char[] a, int start, int count, int index, int codePointOffset) {
        int len = a.length;
        int end = start + count;
        if (start < 0 || count < 0 || end > len || index < start || index > end) {
            throw new IndexOutOfBoundsException();
        }
        int numToGo = codePointOffset;
        int offset = index;
        if (numToGo >= 0) {
            while (numToGo > 0) {
                --numToGo;
                if (Character.isHighSurrogate(a[offset]) && offset + 1 < len && Character.isLowSurrogate(a[offset + 1])) {
                    ++offset;
                }
                ++offset;
            }
            return offset;
        }
        numToGo *= -1;
        while (numToGo > 0) {
            --numToGo;
            if (Character.isLowSurrogate(a[--offset]) && offset - 1 >= 0 && Character.isHighSurrogate(a[offset - 1])) {
                --offset;
            }
            if (offset >= start) continue;
            throw new IndexOutOfBoundsException();
        }
        return offset;
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        int len = seq.length();
        if (beginIndex < 0 || endIndex > len || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        int count = 0;
        int i = beginIndex;
        while (i < endIndex) {
            ++count;
            if (Character.isHighSurrogate(seq.charAt(i)) && i + 1 < endIndex && Character.isLowSurrogate(seq.charAt(i + 1))) {
                ++i;
            }
            ++i;
        }
        return count;
    }

    public static int codePointCount(char[] a, int offset, int count) {
        int len = a.length;
        int end = offset + count;
        if (offset < 0 || count < 0 || end > len) {
            throw new IndexOutOfBoundsException();
        }
        int counter = 0;
        int i = offset;
        while (i < end) {
            ++counter;
            if (Character.isHighSurrogate(a[i]) && i + 1 < end && Character.isLowSurrogate(a[i + 1])) {
                ++i;
            }
            ++i;
        }
        return counter;
    }

    public static boolean isLetterOrDigit(char ch) {
        return (1 << Character.getType(ch) & 0x23E) != 0;
    }

    public static boolean isLetterOrDigit(int codePoint) {
        return (1 << Character.getType(codePoint) & 0x23E) != 0;
    }

    public static boolean isJavaLetter(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isJavaIdentifierStart(int codePoint) {
        return (1 << Character.getType(codePoint) & 0x480043E) != 0;
    }

    public static boolean isJavaLetterOrDigit(char ch) {
        return Character.isJavaIdentifierPart(ch);
    }

    public static boolean isJavaIdentifierStart(char ch) {
        return (1 << Character.getType(ch) & 0x480043E) != 0;
    }

    public static boolean isJavaIdentifierPart(char ch) {
        int category = Character.getType(ch);
        return (1 << category & 0x481077E) != 0 || category == 15 && Character.isIdentifierIgnorable(ch);
    }

    public static boolean isJavaIdentifierPart(int codePoint) {
        int category = Character.getType(codePoint);
        return (1 << category & 0x481077E) != 0 || category == 15 && Character.isIdentifierIgnorable(codePoint);
    }

    public static boolean isUnicodeIdentifierStart(char ch) {
        return (1 << Character.getType(ch) & 0x43E) != 0;
    }

    public static boolean isUnicodeIdentifierStart(int codePoint) {
        return (1 << Character.getType(codePoint) & 0x43E) != 0;
    }

    public static boolean isUnicodeIdentifierPart(char ch) {
        int category = Character.getType(ch);
        return (1 << category & 0x81077E) != 0 || category == 15 && Character.isIdentifierIgnorable(ch);
    }

    public static boolean isUnicodeIdentifierPart(int codePoint) {
        int category = Character.getType(codePoint);
        return (1 << category & 0x81077E) != 0 || category == 15 && Character.isIdentifierIgnorable(codePoint);
    }

    public static boolean isIdentifierIgnorable(char ch) {
        return ch <= '\u009f' && (ch < '\t' || ch >= '\u007f' || ch <= '\u001b' && ch >= '\u000e') || Character.getType(ch) == 16;
    }

    public static boolean isIdentifierIgnorable(int codePoint) {
        return codePoint >= 0 && codePoint <= 8 || codePoint >= 14 && codePoint <= 27 || codePoint >= 127 && codePoint <= 159 || Character.getType(codePoint) == 16;
    }

    public static native char toLowerCase(char var0);

    public static native int toLowerCase(int var0);

    public static native char toUpperCase(char var0);

    public static native int toUpperCase(int var0);

    public static native char toTitleCase(char var0);

    public static native int toTitleCase(int var0);

    public static native int digit(char var0, int var1);

    public static native int digit(int var0, int var1);

    public static native int getNumericValue(char var0);

    public static native int getNumericValue(int var0);

    public static boolean isSpace(char ch) {
        char c = ch;
        ch = (char)(c - '\u0001');
        return c <= ' ' && ('\u0001' << ch & 0x80001B00) != 0;
    }

    public static boolean isSpaceChar(char ch) {
        return (1 << Character.getType(ch) & 0x7000) != 0;
    }

    public static boolean isSpaceChar(int codePoint) {
        return (1 << Character.getType(codePoint) & 0x7000) != 0;
    }

    public static boolean isWhitespace(char ch) {
        char attr = Character.readChar(ch);
        return (1 << (attr & 0x1F) & 0x7000) != 0 && (attr & 0x20) == 0 || ch <= '\u001f' && ('\u0001' << ch & 0xF0003E00) != 0;
    }

    public static boolean isWhitespace(int codePoint) {
        int plane = codePoint >>> 16;
        if (plane > 2 && plane != 14) {
            return false;
        }
        char attr = Character.readCodePoint(codePoint);
        return (1 << (attr & 0x1F) & 0x7000) != 0 && (attr & 0x20) == 0 || codePoint <= 31 && (1 << codePoint & 0xF0003E00) != 0;
    }

    public static boolean isISOControl(char ch) {
        return Character.getType(ch) == 15;
    }

    public static boolean isISOControl(int codePoint) {
        return Character.getType(codePoint) == 15;
    }

    public static native int getType(char var0);

    public static native int getType(int var0);

    public static char forDigit(int digit, int radix) {
        if (radix < 2 || radix > 36 || digit < 0 || digit >= radix) {
            return '\u0000';
        }
        return (char)(digit < 10 ? 48 + digit : 87 + digit);
    }

    public static native byte getDirectionality(char var0);

    public static native byte getDirectionality(int var0);

    public static boolean isMirrored(char ch) {
        return (Character.readChar(ch) & 0x40) != 0;
    }

    public static boolean isMirrored(int codePoint) {
        int plane = codePoint >>> 16;
        if (plane > 2 && plane != 14) {
            return false;
        }
        return (Character.readCodePoint(codePoint) & 0x40) != 0;
    }

    @Override
    public int compareTo(Character anotherCharacter) {
        return this.value - anotherCharacter.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Character valueOf(char val) {
        if (val > '\u007f') {
            return new Character(val);
        }
        Character[] characterArray = charCache;
        synchronized (charCache) {
            if (charCache[val - '\u0000'] == null) {
                Character.charCache[val - '\u0000'] = new Character(val);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return charCache[val - '\u0000'];
        }
    }

    public static char reverseBytes(char val) {
        return (char)(val >> 8 & 0xFF | val << 8 & 0xFF00);
    }

    public static char[] toChars(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException("Illegal Unicode code point : " + codePoint);
        }
        char[] result = new char[Character.charCount(codePoint)];
        Character.toChars(codePoint, result, 0);
        return result;
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        int result;
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException("not a valid code point: " + codePoint);
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            int cp2 = codePoint - 65536;
            dst[dstIndex + 1] = (char)(cp2 % 1024 + 56320);
            dst[dstIndex] = (char)(cp2 / 1024 + 55296);
            result = 2;
        } else {
            dst[dstIndex] = (char)codePoint;
            result = 1;
        }
        return result;
    }

    public static int charCount(int codePoint) {
        return codePoint >= 65536 ? 2 : 1;
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return codePoint >= 65536 && codePoint <= 0x10FFFF;
    }

    public static boolean isValidCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 0x10FFFF;
    }

    public static boolean isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    public static boolean isLowSurrogate(char ch) {
        return ch >= '\udc00' && ch <= '\udfff';
    }

    public static boolean isSurrogatePair(char ch1, char ch2) {
        return Character.isHighSurrogate(ch1) && Character.isLowSurrogate(ch2);
    }

    public static int toCodePoint(char high, char low) {
        return (high - 55296) * 1024 + (low - 56320) + 65536;
    }

    public static int codePointAt(CharSequence sequence, int index) {
        int len = sequence.length();
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = sequence.charAt(index);
        if (!Character.isHighSurrogate(high) || ++index >= len) {
            return high;
        }
        char low = sequence.charAt(index);
        if (!Character.isLowSurrogate(low)) {
            return high;
        }
        return Character.toCodePoint(high, low);
    }

    public static int codePointAt(char[] chars, int index) {
        return Character.codePointAt(chars, index, chars.length);
    }

    public static int codePointAt(char[] chars, int index, int limit) {
        if (index < 0 || index >= limit || limit < 0 || limit > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        char high = chars[index];
        if (!Character.isHighSurrogate(high) || ++index >= limit) {
            return high;
        }
        char low = chars[index];
        if (!Character.isLowSurrogate(low)) {
            return high;
        }
        return Character.toCodePoint(high, low);
    }

    public static int codePointBefore(char[] chars, int index) {
        return Character.codePointBefore(chars, index, 1);
    }

    public static int codePointBefore(char[] chars, int index, int start) {
        char low;
        if (index < start || index > chars.length || start < 0 || start >= chars.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!Character.isLowSurrogate(low = chars[--index]) || --index < start) {
            return low;
        }
        char high = chars[index];
        if (!Character.isHighSurrogate(high)) {
            return low;
        }
        return Character.toCodePoint(high, low);
    }

    public static int codePointBefore(CharSequence sequence, int index) {
        char low;
        int len = sequence.length();
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        if (!Character.isLowSurrogate(low = sequence.charAt(--index)) || --index < 0) {
            return low;
        }
        char high = sequence.charAt(index);
        if (!Character.isHighSurrogate(high)) {
            return low;
        }
        return Character.toCodePoint(high, low);
    }

    public static class Subset {
        private final String name;

        protected Subset(String name) {
            this.name = name.toString();
        }

        public final boolean equals(Object o) {
            return o == this;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }

    public static final class UnicodeBlock
    extends Subset {
        private final int start;
        private final int end;
        private final String canonicalName;
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock(0, 127, "BASIC_LATIN", "Basic Latin");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock(128, 255, "LATIN_1_SUPPLEMENT", "Latin-1 Supplement");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock(256, 383, "LATIN_EXTENDED_A", "Latin Extended-A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock(384, 591, "LATIN_EXTENDED_B", "Latin Extended-B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock(592, 687, "IPA_EXTENSIONS", "IPA Extensions");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock(688, 767, "SPACING_MODIFIER_LETTERS", "Spacing Modifier Letters");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock(768, 879, "COMBINING_DIACRITICAL_MARKS", "Combining Diacritical Marks");
        public static final UnicodeBlock GREEK = new UnicodeBlock(880, 1023, "GREEK", "Greek");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock(1024, 1279, "CYRILLIC", "Cyrillic");
        public static final UnicodeBlock CYRILLIC_SUPPLEMENTARY = new UnicodeBlock(1280, 1327, "CYRILLIC_SUPPLEMENTARY", "Cyrillic Supplementary");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock(1328, 1423, "ARMENIAN", "Armenian");
        public static final UnicodeBlock HEBREW = new UnicodeBlock(1424, 1535, "HEBREW", "Hebrew");
        public static final UnicodeBlock ARABIC = new UnicodeBlock(1536, 1791, "ARABIC", "Arabic");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock(1792, 1871, "SYRIAC", "Syriac");
        public static final UnicodeBlock THAANA = new UnicodeBlock(1920, 1983, "THAANA", "Thaana");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock(2304, 2431, "DEVANAGARI", "Devanagari");
        public static final UnicodeBlock BENGALI = new UnicodeBlock(2432, 2559, "BENGALI", "Bengali");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock(2560, 2687, "GURMUKHI", "Gurmukhi");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock(2688, 2815, "GUJARATI", "Gujarati");
        public static final UnicodeBlock ORIYA = new UnicodeBlock(2816, 2943, "ORIYA", "Oriya");
        public static final UnicodeBlock TAMIL = new UnicodeBlock(2944, 3071, "TAMIL", "Tamil");
        public static final UnicodeBlock TELUGU = new UnicodeBlock(3072, 3199, "TELUGU", "Telugu");
        public static final UnicodeBlock KANNADA = new UnicodeBlock(3200, 3327, "KANNADA", "Kannada");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock(3328, 3455, "MALAYALAM", "Malayalam");
        public static final UnicodeBlock SINHALA = new UnicodeBlock(3456, 3583, "SINHALA", "Sinhala");
        public static final UnicodeBlock THAI = new UnicodeBlock(3584, 3711, "THAI", "Thai");
        public static final UnicodeBlock LAO = new UnicodeBlock(3712, 3839, "LAO", "Lao");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock(3840, 4095, "TIBETAN", "Tibetan");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock(4096, 4255, "MYANMAR", "Myanmar");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock(4256, 4351, "GEORGIAN", "Georgian");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock(4352, 4607, "HANGUL_JAMO", "Hangul Jamo");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock(4608, 4991, "ETHIOPIC", "Ethiopic");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock(5024, 5119, "CHEROKEE", "Cherokee");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock(5120, 5759, "UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", "Unified Canadian Aboriginal Syllabics");
        public static final UnicodeBlock OGHAM = new UnicodeBlock(5760, 5791, "OGHAM", "Ogham");
        public static final UnicodeBlock RUNIC = new UnicodeBlock(5792, 5887, "RUNIC", "Runic");
        public static final UnicodeBlock TAGALOG = new UnicodeBlock(5888, 5919, "TAGALOG", "Tagalog");
        public static final UnicodeBlock HANUNOO = new UnicodeBlock(5920, 5951, "HANUNOO", "Hanunoo");
        public static final UnicodeBlock BUHID = new UnicodeBlock(5952, 5983, "BUHID", "Buhid");
        public static final UnicodeBlock TAGBANWA = new UnicodeBlock(5984, 6015, "TAGBANWA", "Tagbanwa");
        public static final UnicodeBlock KHMER = new UnicodeBlock(6016, 6143, "KHMER", "Khmer");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock(6144, 6319, "MONGOLIAN", "Mongolian");
        public static final UnicodeBlock LIMBU = new UnicodeBlock(6400, 6479, "LIMBU", "Limbu");
        public static final UnicodeBlock TAI_LE = new UnicodeBlock(6480, 6527, "TAI_LE", "Tai Le");
        public static final UnicodeBlock KHMER_SYMBOLS = new UnicodeBlock(6624, 6655, "KHMER_SYMBOLS", "Khmer Symbols");
        public static final UnicodeBlock PHONETIC_EXTENSIONS = new UnicodeBlock(7424, 7551, "PHONETIC_EXTENSIONS", "Phonetic Extensions");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock(7680, 7935, "LATIN_EXTENDED_ADDITIONAL", "Latin Extended Additional");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock(7936, 8191, "GREEK_EXTENDED", "Greek Extended");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock(8192, 8303, "GENERAL_PUNCTUATION", "General Punctuation");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock(8304, 8351, "SUPERSCRIPTS_AND_SUBSCRIPTS", "Superscripts and Subscripts");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock(8352, 8399, "CURRENCY_SYMBOLS", "Currency Symbols");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock(8400, 8447, "COMBINING_MARKS_FOR_SYMBOLS", "Combining Marks for Symbols");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock(8448, 8527, "LETTERLIKE_SYMBOLS", "Letterlike Symbols");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock(8528, 8591, "NUMBER_FORMS", "Number Forms");
        public static final UnicodeBlock ARROWS = new UnicodeBlock(8592, 8703, "ARROWS", "Arrows");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock(8704, 8959, "MATHEMATICAL_OPERATORS", "Mathematical Operators");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock(8960, 9215, "MISCELLANEOUS_TECHNICAL", "Miscellaneous Technical");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock(9216, 9279, "CONTROL_PICTURES", "Control Pictures");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock(9280, 9311, "OPTICAL_CHARACTER_RECOGNITION", "Optical Character Recognition");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock(9312, 9471, "ENCLOSED_ALPHANUMERICS", "Enclosed Alphanumerics");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock(9472, 9599, "BOX_DRAWING", "Box Drawing");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock(9600, 9631, "BLOCK_ELEMENTS", "Block Elements");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock(9632, 9727, "GEOMETRIC_SHAPES", "Geometric Shapes");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock(9728, 9983, "MISCELLANEOUS_SYMBOLS", "Miscellaneous Symbols");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock(9984, 10175, "DINGBATS", "Dingbats");
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock(10176, 10223, "MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", "Miscellaneous Mathematical Symbols-A");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_A = new UnicodeBlock(10224, 10239, "SUPPLEMENTAL_ARROWS_A", "Supplemental Arrows-A");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock(10240, 10495, "BRAILLE_PATTERNS", "Braille Patterns");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_B = new UnicodeBlock(10496, 10623, "SUPPLEMENTAL_ARROWS_B", "Supplemental Arrows-B");
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock(10624, 10751, "MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", "Miscellaneous Mathematical Symbols-B");
        public static final UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock(10752, 11007, "SUPPLEMENTAL_MATHEMATICAL_OPERATORS", "Supplemental Mathematical Operators");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock(11008, 11263, "MISCELLANEOUS_SYMBOLS_AND_ARROWS", "Miscellaneous Symbols and Arrows");
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock(11904, 12031, "CJK_RADICALS_SUPPLEMENT", "CJK Radicals Supplement");
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock(12032, 12255, "KANGXI_RADICALS", "Kangxi Radicals");
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock(12272, 12287, "IDEOGRAPHIC_DESCRIPTION_CHARACTERS", "Ideographic Description Characters");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock(12288, 12351, "CJK_SYMBOLS_AND_PUNCTUATION", "CJK Symbols and Punctuation");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock(12352, 12447, "HIRAGANA", "Hiragana");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock(12448, 12543, "KATAKANA", "Katakana");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock(12544, 12591, "BOPOMOFO", "Bopomofo");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock(12592, 12687, "HANGUL_COMPATIBILITY_JAMO", "Hangul Compatibility Jamo");
        public static final UnicodeBlock KANBUN = new UnicodeBlock(12688, 12703, "KANBUN", "Kanbun");
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock(12704, 12735, "BOPOMOFO_EXTENDED", "Bopomofo Extended");
        public static final UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock(12784, 12799, "KATAKANA_PHONETIC_EXTENSIONS", "Katakana Phonetic Extensions");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock(12800, 13055, "ENCLOSED_CJK_LETTERS_AND_MONTHS", "Enclosed CJK Letters and Months");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock(13056, 13311, "CJK_COMPATIBILITY", "CJK Compatibility");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock(13312, 19903, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", "CJK Unified Ideographs Extension A");
        public static final UnicodeBlock YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock(19904, 19967, "YIJING_HEXAGRAM_SYMBOLS", "Yijing Hexagram Symbols");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock(19968, 40959, "CJK_UNIFIED_IDEOGRAPHS", "CJK Unified Ideographs");
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock(40960, 42127, "YI_SYLLABLES", "Yi Syllables");
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock(42128, 42191, "YI_RADICALS", "Yi Radicals");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock(44032, 55215, "HANGUL_SYLLABLES", "Hangul Syllables");
        public static final UnicodeBlock HIGH_SURROGATES = new UnicodeBlock(55296, 56191, "HIGH_SURROGATES", "High Surrogates");
        public static final UnicodeBlock HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock(56192, 56319, "HIGH_PRIVATE_USE_SURROGATES", "High Private Use Surrogates");
        public static final UnicodeBlock LOW_SURROGATES = new UnicodeBlock(56320, 57343, "LOW_SURROGATES", "Low Surrogates");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock(57344, 63743, "PRIVATE_USE_AREA", "Private Use Area");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock(63744, 64255, "CJK_COMPATIBILITY_IDEOGRAPHS", "CJK Compatibility Ideographs");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock(64256, 64335, "ALPHABETIC_PRESENTATION_FORMS", "Alphabetic Presentation Forms");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock(64336, 65023, "ARABIC_PRESENTATION_FORMS_A", "Arabic Presentation Forms-A");
        public static final UnicodeBlock VARIATION_SELECTORS = new UnicodeBlock(65024, 65039, "VARIATION_SELECTORS", "Variation Selectors");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock(65056, 65071, "COMBINING_HALF_MARKS", "Combining Half Marks");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock(65072, 65103, "CJK_COMPATIBILITY_FORMS", "CJK Compatibility Forms");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock(65104, 65135, "SMALL_FORM_VARIANTS", "Small Form Variants");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock(65136, 65279, "ARABIC_PRESENTATION_FORMS_B", "Arabic Presentation Forms-B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock(65280, 65519, "HALFWIDTH_AND_FULLWIDTH_FORMS", "Halfwidth and Fullwidth Forms");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock(65520, 65535, "SPECIALS", "Specials");
        public static final UnicodeBlock LINEAR_B_SYLLABARY = new UnicodeBlock(65536, 65663, "LINEAR_B_SYLLABARY", "Linear B Syllabary");
        public static final UnicodeBlock LINEAR_B_IDEOGRAMS = new UnicodeBlock(65664, 65791, "LINEAR_B_IDEOGRAMS", "Linear B Ideograms");
        public static final UnicodeBlock AEGEAN_NUMBERS = new UnicodeBlock(65792, 65855, "AEGEAN_NUMBERS", "Aegean Numbers");
        public static final UnicodeBlock OLD_ITALIC = new UnicodeBlock(66304, 66351, "OLD_ITALIC", "Old Italic");
        public static final UnicodeBlock GOTHIC = new UnicodeBlock(66352, 66383, "GOTHIC", "Gothic");
        public static final UnicodeBlock UGARITIC = new UnicodeBlock(66432, 66463, "UGARITIC", "Ugaritic");
        public static final UnicodeBlock DESERET = new UnicodeBlock(66560, 66639, "DESERET", "Deseret");
        public static final UnicodeBlock SHAVIAN = new UnicodeBlock(66640, 66687, "SHAVIAN", "Shavian");
        public static final UnicodeBlock OSMANYA = new UnicodeBlock(66688, 66735, "OSMANYA", "Osmanya");
        public static final UnicodeBlock CYPRIOT_SYLLABARY = new UnicodeBlock(67584, 67647, "CYPRIOT_SYLLABARY", "Cypriot Syllabary");
        public static final UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock(118784, 119039, "BYZANTINE_MUSICAL_SYMBOLS", "Byzantine Musical Symbols");
        public static final UnicodeBlock MUSICAL_SYMBOLS = new UnicodeBlock(119040, 119295, "MUSICAL_SYMBOLS", "Musical Symbols");
        public static final UnicodeBlock TAI_XUAN_JING_SYMBOLS = new UnicodeBlock(119552, 119647, "TAI_XUAN_JING_SYMBOLS", "Tai Xuan Jing Symbols");
        public static final UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock(119808, 120831, "MATHEMATICAL_ALPHANUMERIC_SYMBOLS", "Mathematical Alphanumeric Symbols");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock(131072, 173791, "CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", "CJK Unified Ideographs Extension B");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock(194560, 195103, "CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", "CJK Compatibility Ideographs Supplement");
        public static final UnicodeBlock TAGS = new UnicodeBlock(917504, 917631, "TAGS", "Tags");
        public static final UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock(917760, 917999, "VARIATION_SELECTORS_SUPPLEMENT", "Variation Selectors Supplement");
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock(983040, 1048575, "SUPPLEMENTARY_PRIVATE_USE_AREA_A", "Supplementary Private Use Area-A");
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock(0x100000, 0x10FFFF, "SUPPLEMENTARY_PRIVATE_USE_AREA_B", "Supplementary Private Use Area-B");
        @Deprecated
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock(55296, 57343, "SURROGATES_AREA", "Surrogates Area");
        private static final UnicodeBlock[] sets = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, CYRILLIC_SUPPLEMENTARY, ARMENIAN, HEBREW, ARABIC, SYRIAC, THAANA, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, TAGALOG, HANUNOO, BUHID, TAGBANWA, KHMER, MONGOLIAN, LIMBU, TAI_LE, KHMER_SYMBOLS, PHONETIC_EXTENSIONS, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, SUPPLEMENTAL_ARROWS_A, BRAILLE_PATTERNS, SUPPLEMENTAL_ARROWS_B, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, SUPPLEMENTAL_MATHEMATICAL_OPERATORS, MISCELLANEOUS_SYMBOLS_AND_ARROWS, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, KATAKANA_PHONETIC_EXTENSIONS, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, YIJING_HEXAGRAM_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, HANGUL_SYLLABLES, HIGH_SURROGATES, HIGH_PRIVATE_USE_SURROGATES, LOW_SURROGATES, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, VARIATION_SELECTORS, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS, LINEAR_B_SYLLABARY, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, OLD_ITALIC, GOTHIC, UGARITIC, DESERET, SHAVIAN, OSMANYA, CYPRIOT_SYLLABARY, BYZANTINE_MUSICAL_SYMBOLS, MUSICAL_SYMBOLS, TAI_XUAN_JING_SYMBOLS, MATHEMATICAL_ALPHANUMERIC_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, TAGS, VARIATION_SELECTORS_SUPPLEMENT, SUPPLEMENTARY_PRIVATE_USE_AREA_A, SUPPLEMENTARY_PRIVATE_USE_AREA_B};

        private UnicodeBlock(int start, int end, String name, String canonicalName) {
            super(name);
            this.start = start;
            this.end = end;
            this.canonicalName = canonicalName;
        }

        public static UnicodeBlock of(char ch) {
            return UnicodeBlock.of((int)ch);
        }

        public static UnicodeBlock of(int codePoint) {
            if (codePoint > 0x10FFFF) {
                throw new IllegalArgumentException("The supplied integer value is too large to be a codepoint.");
            }
            int low = 0;
            int hi = sets.length - 1;
            while (low <= hi) {
                int mid = low + hi >> 1;
                UnicodeBlock b = sets[mid];
                if (codePoint < b.start) {
                    hi = mid - 1;
                    continue;
                }
                if (codePoint > b.end) {
                    low = mid + 1;
                    continue;
                }
                return b;
            }
            return null;
        }

        public static final UnicodeBlock forName(String blockName) {
            NameType type = blockName.indexOf(32) != -1 ? NameType.CANONICAL : (blockName.indexOf(95) != -1 ? NameType.CONSTANT : NameType.NO_SPACES);
            Collator usCollator = Collator.getInstance(Locale.US);
            usCollator.setStrength(0);
            switch (type) {
                case CANONICAL: {
                    if (usCollator.compare(blockName, "Surrogates Area") != 0) break;
                    return SURROGATES_AREA;
                }
                case NO_SPACES: {
                    if (usCollator.compare(blockName, "SurrogatesArea") != 0) break;
                    return SURROGATES_AREA;
                }
                case CONSTANT: {
                    if (usCollator.compare(blockName, "SURROGATES_AREA") != 0) break;
                    return SURROGATES_AREA;
                }
            }
            switch (type) {
                case CANONICAL: {
                    UnicodeBlock[] unicodeBlockArray = sets;
                    int n = sets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UnicodeBlock block = unicodeBlockArray[n2];
                        if (usCollator.compare(blockName, block.canonicalName) == 0) {
                            return block;
                        }
                        ++n2;
                    }
                    break;
                }
                case NO_SPACES: {
                    UnicodeBlock[] unicodeBlockArray = sets;
                    int n = sets.length;
                    int n3 = 0;
                    while (n3 < n) {
                        UnicodeBlock block = unicodeBlockArray[n3];
                        String nsName = block.canonicalName.replaceAll(" ", "");
                        if (usCollator.compare(blockName, nsName) == 0) {
                            return block;
                        }
                        ++n3;
                    }
                    break;
                }
                case CONSTANT: {
                    UnicodeBlock[] unicodeBlockArray = sets;
                    int n = sets.length;
                    int n4 = 0;
                    while (n4 < n) {
                        UnicodeBlock block = unicodeBlockArray[n4];
                        if (usCollator.compare(blockName, block.toString()) == 0) {
                            return block;
                        }
                        ++n4;
                    }
                    break;
                }
            }
            throw new IllegalArgumentException("No Unicode block found for " + blockName + ".");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum NameType {
            CANONICAL,
            NO_SPACES,
            CONSTANT;

        }
    }
}

