/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class ByteType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};
    static final String MAX_VALUE = "127";
    static final String MIN_VALUE = "128";
    static final int LENGTH = "127".length();

    ByteType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "byte"), TypeLibrary.SHORT);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValue(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        if (len == 0) {
            throw new DatatypeException(0, "invalid byte value");
        }
        int i = 0;
        int off = 0;
        boolean compare = false;
        String compareTo = MAX_VALUE;
        char c = value.charAt(0);
        if (c == '+') {
            ++i;
        } else if (c == '-') {
            compareTo = MIN_VALUE;
            ++i;
        }
        if (len - i > LENGTH) {
            throw new DatatypeException(0, "invalid byte value");
        }
        if (len - i == LENGTH) {
            compare = true;
        }
        while (i < len) {
            c = value.charAt(i);
            if (c >= '0' && c <= '9') {
                if (compare) {
                    char d = compareTo.charAt(off);
                    if (Character.digit(c, 10) > Character.digit(d, 10)) {
                        throw new DatatypeException(i, "invalid byte value");
                    }
                }
                ++off;
            } else {
                throw new DatatypeException(i, "invalid byte value");
            }
            ++i;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new Byte(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

