/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

public class Length {
    private String value;
    protected float floatValue;
    private boolean isPercentage = false;
    private boolean isFontEMRelative = false;
    private boolean isFontEXRelative = false;
    private float emBase;
    private float exBase;

    public Length(String val) {
        this.value = val;
        int i = this.value.indexOf("px");
        int percent = this.value.indexOf("%");
        int em = this.value.indexOf("em");
        int ex = this.value.indexOf("ex");
        try {
            this.floatValue = 0.0f;
            if (i != -1) {
                String sub = this.value.substring(0, i);
                this.floatValue = Float.parseFloat(sub);
            } else if (percent != -1) {
                this.isPercentage = true;
                String sub = this.value.substring(0, percent);
                this.floatValue = Float.parseFloat(sub) / 100.0f;
            } else if (em != -1) {
                this.isFontEMRelative = true;
                String sub = this.value.substring(0, em);
                this.floatValue = Float.parseFloat(sub);
            } else if (ex != -1) {
                this.isFontEXRelative = true;
                String sub = this.value.substring(0, ex);
                this.floatValue = Float.parseFloat(sub);
            } else {
                this.floatValue = Float.parseFloat(this.value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("couldn't parse: " + val);
        }
    }

    public float getValue() {
        return this.floatValue;
    }

    public float getValue(float base) {
        float span = this.floatValue;
        if (this.isPercentage) {
            span *= base;
        } else if (this.isFontEMRelative) {
            span *= this.emBase;
        } else if (this.isFontEXRelative) {
            span *= this.exBase;
        }
        return span;
    }

    public void setEMBase(float base) {
        this.emBase = base;
    }

    public void setEXBase(float base) {
        this.exBase = base;
    }

    public void setFontBases(float emBase, float exBase) {
        this.setEMBase(emBase);
        this.setEXBase(exBase);
    }

    public boolean isFontEMRelative() {
        return this.isFontEMRelative;
    }

    public boolean isFontEXRelative() {
        return this.isFontEXRelative;
    }

    public boolean isPercentage() {
        return this.isPercentage;
    }

    public static boolean isValid(String value) {
        boolean isValid = true;
        int px = value.indexOf("px");
        int em = value.indexOf("em");
        int ex = value.indexOf("ex");
        int pc = value.indexOf(37);
        try {
            if (px != -1) {
                Integer.parseInt(value.substring(0, px));
            } else if (em != -1) {
                Integer.parseInt(value.substring(0, em));
            } else if (ex != -1) {
                Integer.parseInt(value.substring(0, ex));
            } else if (pc != -1) {
                Integer.parseInt(value.substring(0, ex));
            } else {
                Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            isValid = false;
        }
        return isValid;
    }

    public String toString() {
        return this.value;
    }
}

