/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Signature;
import gnu.classpath.jdwp.value.Value;
import gnu.classpath.jdwp.value.ValueFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public class ReferenceTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeSignature(bb, os);
                    break;
                }
                case 2: {
                    this.executeClassLoader(bb, os);
                    break;
                }
                case 3: {
                    this.executeModifiers(bb, os);
                    break;
                }
                case 4: {
                    this.executeFields(bb, os);
                    break;
                }
                case 5: {
                    this.executeMethods(bb, os);
                    break;
                }
                case 6: {
                    this.executeGetValues(bb, os);
                    break;
                }
                case 7: {
                    this.executeSourceFile(bb, os);
                    break;
                }
                case 8: {
                    this.executeNestedTypes(bb, os);
                    break;
                }
                case 9: {
                    this.executeStatus(bb, os);
                    break;
                }
                case 10: {
                    this.executeInterfaces(bb, os);
                    break;
                }
                case 11: {
                    this.executeClassObject(bb, os);
                    break;
                }
                case 12: {
                    this.executeSourceDebugExtension(bb, os);
                    break;
                }
                case 13: {
                    this.executeSignatureWithGeneric(bb, os);
                    break;
                }
                case 14: {
                    this.executeFieldWithGeneric(bb, os);
                    break;
                }
                case 15: {
                    this.executeMethodsWithGeneric(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ReferenceType Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeSignature(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        String sig = Signature.computeClassSignature(refId.getType());
        JdwpString.writeString(os, sig);
    }

    private void executeClassLoader(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ClassLoader loader = clazz.getClassLoader();
        ObjectId oid = this.idMan.getObjectId(loader);
        oid.write(os);
    }

    private void executeModifiers(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        os.writeInt(clazz.getModifiers());
    }

    private void executeFields(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Field[] fields = clazz.getFields();
        os.writeInt(fields.length);
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            this.idMan.getObjectId(field).write(os);
            JdwpString.writeString(os, field.getName());
            JdwpString.writeString(os, Signature.computeFieldSignature(field));
            os.writeInt(field.getModifiers());
            ++i;
        }
    }

    private void executeMethods(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        VMMethod[] methods = VMVirtualMachine.getAllClassMethods(clazz);
        os.writeInt(methods.length);
        int i = 0;
        while (i < methods.length) {
            VMMethod method = methods[i];
            method.writeId(os);
            JdwpString.writeString(os, method.getName());
            JdwpString.writeString(os, method.getSignature());
            os.writeInt(method.getModifiers());
            ++i;
        }
    }

    private void executeGetValues(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        int numFields = bb.getInt();
        os.writeInt(numFields);
        int i = 0;
        while (i < numFields) {
            ObjectId fieldId = this.idMan.readObjectId(bb);
            Field field = (Field)fieldId.getObject();
            Class<?> fieldClazz = field.getDeclaringClass();
            if (fieldClazz.isAssignableFrom(clazz)) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(null);
                    Value val = ValueFactory.createFromObject(value, field.getType());
                    val.writeTagged(os);
                }
                catch (IllegalArgumentException ex) {
                    throw new InvalidFieldException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new JdwpInternalErrorException(ex);
                }
            } else {
                throw new InvalidFieldException(fieldId.getId());
            }
            ++i;
        }
    }

    private void executeSourceFile(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        String sourceFileName = VMVirtualMachine.getSourceFile(clazz);
        JdwpString.writeString(os, sourceFileName);
    }

    private void executeNestedTypes(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Class<?>[] declaredClazzes = clazz.getDeclaredClasses();
        os.writeInt(declaredClazzes.length);
        int i = 0;
        while (i < declaredClazzes.length) {
            Class<?> decClazz = declaredClazzes[i];
            ReferenceTypeId clazzId = this.idMan.getReferenceTypeId(decClazz);
            clazzId.writeTagged(os);
            ++i;
        }
    }

    private void executeStatus(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        int status = VMVirtualMachine.getClassStatus(clazz);
        os.writeInt(status);
    }

    private void executeInterfaces(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        Class<?>[] interfaces = clazz.getInterfaces();
        os.writeInt(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class<?> interfaceClass = interfaces[i];
            ReferenceTypeId intId = this.idMan.getReferenceTypeId(interfaceClass);
            intId.write(os);
            ++i;
        }
    }

    private void executeClassObject(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        ObjectId clazzObjectId = this.idMan.getObjectId(clazz);
        clazzObjectId.write(os);
    }

    private void executeSourceDebugExtension(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String msg = "source debug extension is not supported";
        throw new NotImplementedException(msg);
    }

    private void executeSignatureWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command SignatureWithGeneric not implemented.");
    }

    private void executeFieldWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command executeFieldWithGeneric not implemented.");
    }

    private void executeMethodsWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        throw new NotImplementedException("Command executeMethodsWithGeneric not implemented.");
    }
}

