/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.security.util.Util;
import gnu.java.security.x509.X500DistinguishedName;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class GenKeyCmd
extends Command {
    private static final Logger log = Logger.getLogger(GenKeyCmd.class.getName());
    private static final int DEFAULT_KEY_SIZE = 1024;
    protected String _alias;
    protected String _keyAlgorithm;
    protected String _keySizeStr;
    protected String _sigAlgorithm;
    protected String _dName;
    protected String _password;
    protected String _validityStr;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    private int keySize;
    private X500DistinguishedName distinguishedName;

    GenKeyCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setKeyalg(String algorithm) {
        this._keyAlgorithm = algorithm;
    }

    public void setKeysize(String bits) {
        this._validityStr = bits;
    }

    public void setSigalg(String algorithm) {
        this._sigAlgorithm = algorithm;
    }

    public void setDname(String name) {
        this._dName = name;
    }

    public void setKeypass(String password) {
        this._password = password;
    }

    public void setValidity(String days) {
        this._validityStr = days;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(true, this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        this.setKeyPasswordParam(this._password);
        this.setAlgorithmParams(this._keyAlgorithm, this._sigAlgorithm);
        this.setKeySize(this._keySizeStr);
        this.setDName(this._dName);
        this.setValidityParam(this._validityStr);
        if (Configuration.DEBUG) {
            log.fine("-genkey handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -keyalg=" + this.keyPairGenerator.getAlgorithm());
            log.fine("  -keysize=" + this.keySize);
            log.fine("  -sigalg=" + this.signatureAlgorithm.getAlgorithm());
            log.fine("  -dname=" + this.distinguishedName);
            log.fine("  -validity=" + this.validityInDays);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException, KeyStoreException, InvalidKeyException, SignatureException, IOException, NoSuchAlgorithmException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
            log.fine("About to generate key-pair...");
        }
        this.keyPairGenerator.initialize(this.keySize);
        KeyPair kp = this.keyPairGenerator.generateKeyPair();
        PublicKey publicKey = kp.getPublic();
        PrivateKey privateKey = kp.getPrivate();
        if (Configuration.DEBUG) {
            log.fine("About to generate a self-signed certificate...");
        }
        byte[] derBytes = this.getSelfSignedCertificate(this.distinguishedName, publicKey, privateKey);
        if (Configuration.DEBUG) {
            log.fine(Util.dumpString((byte[])derBytes, (String)"derBytes "));
        }
        CertificateFactory x509Factory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(derBytes);
        Certificate certificate = x509Factory.generateCertificate(bais);
        if (Configuration.DEBUG) {
            log.fine("certificate = " + certificate);
        }
        Certificate[] chain = new Certificate[]{certificate};
        if (Configuration.DEBUG) {
            log.fine("About to store newly generated material in key store...");
        }
        this.store.setKeyEntry(this.alias, privateKey, this.keyPasswordChars, chain);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("genkey", true);
        result.setHeader(Messages.getString("GenKeyCmd.57"));
        result.setFooter(Messages.getString("GenKeyCmd.58"));
        OptionGroup options = new OptionGroup(Messages.getString("GenKeyCmd.59"));
        options.add(new Option("alias", Messages.getString("GenKeyCmd.60"), Messages.getString("GenKeyCmd.61")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._alias = argument;
            }
        });
        options.add(new Option("keyalg", Messages.getString("GenKeyCmd.62"), Messages.getString("GenKeyCmd.63")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._keyAlgorithm = argument;
            }
        });
        options.add(new Option("keysize", Messages.getString("GenKeyCmd.64"), Messages.getString("GenKeyCmd.65")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._keySizeStr = argument;
            }
        });
        options.add(new Option("sigalg", Messages.getString("GenKeyCmd.66"), Messages.getString("GenKeyCmd.63")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._sigAlgorithm = argument;
            }
        });
        options.add(new Option("dname", Messages.getString("GenKeyCmd.68"), Messages.getString("GenKeyCmd.69")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._dName = argument;
            }
        });
        options.add(new Option("keypass", Messages.getString("GenKeyCmd.70"), Messages.getString("GenKeyCmd.71")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._password = argument;
            }
        });
        options.add(new Option("validity", Messages.getString("GenKeyCmd.72"), Messages.getString("GenKeyCmd.73")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._validityStr = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("GenKeyCmd.74"), Messages.getString("GenKeyCmd.75")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("GenKeyCmd.76"), Messages.getString("GenKeyCmd.77")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("GenKeyCmd.78"), Messages.getString("GenKeyCmd.71")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("GenKeyCmd.80"), Messages.getString("GenKeyCmd.81")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("GenKeyCmd.82")){

            public void parsed(String argument) throws OptionException {
                GenKeyCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void setKeySize(String size) {
        if (size == null || size.trim().length() == 0) {
            this.keySize = 1024;
        } else {
            size = size.trim();
            this.keySize = Integer.parseInt(size);
            if (this.keySize < 1) {
                throw new IllegalArgumentException(Messages.getString("GenKeyCmd.54"));
            }
        }
    }

    private void setDName(String name) throws IOException, UnsupportedCallbackException {
        if (name != null && name.trim().length() > 0) {
            name = name.trim();
        } else {
            String dnTxt = Messages.getString("GenKeyCmd.0");
            String oDefault = Messages.getString("GenKeyCmd.6");
            String lDefault = Messages.getString("GenKeyCmd.7");
            String stDefault = Messages.getString("GenKeyCmd.8");
            String cDefault = Messages.getString("GenKeyCmd.9");
            String cnPrompt = Messages.getString("GenKeyCmd.10");
            String oPrompt = Messages.getFormattedString("GenKeyCmd.11", oDefault);
            String ouPrompt = Messages.getString("GenKeyCmd.13");
            String lPrompt = Messages.getFormattedString("GenKeyCmd.14", lDefault);
            String stPrompt = Messages.getFormattedString("GenKeyCmd.16", stDefault);
            String cPrompt = Messages.getFormattedString("GenKeyCmd.18", cDefault);
            TextOutputCallback dnCB = new TextOutputCallback(0, dnTxt);
            TextInputCallback cnCB = new TextInputCallback(cnPrompt);
            TextInputCallback oCB = new TextInputCallback(oPrompt, oDefault);
            TextInputCallback ouCB = new TextInputCallback(ouPrompt);
            TextInputCallback lCB = new TextInputCallback(lPrompt, lDefault);
            TextInputCallback sCB = new TextInputCallback(stPrompt, stDefault);
            TextInputCallback cCB = new TextInputCallback(cPrompt, cDefault);
            this.getCallbackHandler().handle(new Callback[]{dnCB, cnCB, oCB, ouCB, lCB, sCB, cCB});
            StringBuilder sb = new StringBuilder();
            name = this.parseUserPrompt(cnCB);
            if (name != null && name.length() > 0) {
                sb.append("CN=").append(name);
            }
            if ((name = this.parseUserPrompt(oCB)) != null && name.length() > 0) {
                sb.append(",O=").append(name);
            }
            if ((name = this.parseUserPrompt(ouCB)) != null && name.length() > 0) {
                sb.append(",OU=").append(name.trim());
            }
            if ((name = this.parseUserPrompt(lCB)) != null && name.length() > 0) {
                sb.append(",L=").append(name.trim());
            }
            if ((name = this.parseUserPrompt(sCB)) != null && name.length() > 0) {
                sb.append(",ST=").append(name.trim());
            }
            if ((name = this.parseUserPrompt(cCB)) != null && name.length() > 0) {
                sb.append(",C=").append(name.trim());
            }
            name = sb.toString().trim();
        }
        if (Configuration.DEBUG) {
            log.fine("dName=[" + name + "]");
        }
        this.distinguishedName = new X500DistinguishedName(name);
    }

    private String parseUserPrompt(TextInputCallback ticb) {
        Object result = ticb.getText();
        result = result == null || ((String)result).trim().length() == 0 ? ticb.getDefaultText() : (((String)result).trim().equals(".") ? null : ((String)result).trim());
        return result;
    }
}

