# shell include script

ZARAFA_LANG="${ZARAFA_USERSCRIPT_LOCALE:-${LC_MESSAGES:-C}}"
PATH=$PATH:/usr/local/bin
export ZARAFA_LANG PATH

if [ -z "${ZARAFA_USER_SCRIPTS}" ] ; then
    exec >&2
    echo "Do not execute this script directly"
    exit 1
fi

if [ ! -d "${ZARAFA_USER_SCRIPTS}" ] ; then
    exec >&2
    echo "${ZARAFA_USER_SCRIPTS} does not exist or is not a directory"
    exit 1
fi

if [ -z "${ZARAFA_USER}" -a -z "${ZARAFA_STOREGUID}" ] ; then
    exec >&2
    echo "ZARAFA_USER and ZARAFA_STOREGUID is not set."
    exit 1
fi

find ${ZARAFA_USER_SCRIPTS} -maxdepth 1 -type f -perm -u=x -and ! -name \*~ -and ! -name \#\* -exec {} \;
cd "$ZARAFA_USER_SCRIPTS"
find "${ZARAFA_USER_SCRIPTS}" -maxdepth 1 -type f -perm -u=x -not -name \*~ -not -name \#\* -not -name \*.rpm\* -not -name \*.bak -not -name \*.old -exec {} \;
