/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.owasp.jbrofuzz.fuzz.ui.FuzzingPanel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsRow;
import org.owasp.jbrofuzz.fuzz.ui.TransformsTableModel;
import org.owasp.jbrofuzz.version.ImageCreator;

public class TransformsToolBar
extends JToolBar {
    private static final long serialVersionUID = 9074400815038517325L;
    private JButton upAll;
    private JButton upOne;
    private JButton downOne;
    private JButton downAll;
    private JButton add;
    private JButton delete;
    private FuzzingPanel container;

    public TransformsToolBar(FuzzingPanel container) {
        this.container = container;
        this.upAll = new JButton(ImageCreator.IMG_UPALL);
        this.upOne = new JButton(ImageCreator.IMG_UP);
        this.downOne = new JButton(ImageCreator.IMG_DOWN);
        this.downAll = new JButton(ImageCreator.IMG_DOWNALL);
        this.delete = new JButton(ImageCreator.IMG_REMOVE);
        this.add = new JButton(ImageCreator.IMG_ADD);
        this.add(this.upAll);
        this.add(this.upOne);
        this.add(this.downOne);
        this.add(this.downAll);
        this.add(this.delete);
        this.add(this.add);
        this.setOrientation(1);
        this.setFloatable(false);
        this.addActionListeners();
        this.upAll.setToolTipText("Move selected encoder to the top");
        this.upOne.setToolTipText("Move selected encoder up one");
        this.downOne.setToolTipText("Move selected encoder down one");
        this.downAll.setToolTipText("Move selected encoder to the bottom");
        this.delete.setToolTipText("Remove the selected encoder");
        this.add.setToolTipText("Add a new encoder");
        this.disableAll();
    }

    public void disableAll() {
        this.disablePositionModifiers();
        this.disableDelete();
        this.disableAdd();
        this.container.updateUI();
    }

    public void enableAll() {
        this.enablePositionModifiers();
        this.enableDelete();
        this.enableAdd();
        this.container.updateUI();
    }

    public void enablePositionModifiers() {
        this.upAll.setEnabled(true);
        this.upOne.setEnabled(true);
        this.downAll.setEnabled(true);
        this.downOne.setEnabled(true);
        this.container.updateUI();
    }

    public void disablePositionModifiers() {
        this.upAll.setEnabled(false);
        this.upOne.setEnabled(false);
        this.downAll.setEnabled(false);
        this.downOne.setEnabled(false);
        this.container.updateUI();
    }

    public void enableAdd() {
        this.add.setEnabled(true);
        this.container.updateUI();
    }

    public void enableDelete() {
        this.delete.setEnabled(true);
        this.container.updateUI();
    }

    public void disableAdd() {
        this.add.setEnabled(false);
        this.container.updateUI();
    }

    public void disableDelete() {
        this.delete.setEnabled(false);
        this.container.updateUI();
    }

    private void addActionListeners() {
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int index = TransformsToolBar.this.container.getFuzzersPanel().getFuzzersTable().getSelectedRow();
                if (index != -1) {
                    TransformsTableModel tl = TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index);
                    tl.addRow(new TransformsRow());
                    if (tl.getRowCount() == 1) {
                        TransformsToolBar.this.enableDelete();
                    } else if (tl.getRowCount() == 2) {
                        TransformsToolBar.this.enablePositionModifiers();
                    }
                    if (TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().editCellAt(TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).getRowCount() - 1, 0)) {
                        TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().changeSelection(TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).getRowCount() - 1, 0, true, false);
                    }
                }
            }
        });
        this.upAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int index = TransformsToolBar.this.container.getFuzzersPanel().getFuzzersTable().getSelectedRow();
                if (index != -1) {
                    int selectedRow = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedRow();
                    int selectedColumn = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedColumn();
                    if (selectedRow > 0) {
                        TransformsToolBar.this.stopEdit();
                        TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).moveRowUpAll(selectedRow);
                        if (TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().editCellAt(0, selectedColumn)) {
                            TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().changeSelection(0, selectedColumn, false, false);
                        }
                    }
                }
            }
        });
        this.upOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int selectedRow;
                int index = TransformsToolBar.this.container.getFuzzersPanel().getFuzzersTable().getSelectedRow();
                int selectedColumn = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedColumn();
                if (index != -1 && (selectedRow = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedRow()) > 0) {
                    TransformsToolBar.this.stopEdit();
                    TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).moveRowUpOne(selectedRow);
                    if (TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().editCellAt(selectedRow - 1, selectedColumn)) {
                        TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().changeSelection(selectedRow - 1, selectedColumn, false, false);
                    }
                }
            }
        });
        this.downOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int index = TransformsToolBar.this.container.getFuzzersPanel().getFuzzersTable().getSelectedRow();
                if (index != -1) {
                    int selectedRow = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedRow();
                    int selectedColumn = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedColumn();
                    if (selectedRow > -1 && selectedRow < TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).getRowCount() - 1) {
                        TransformsToolBar.this.stopEdit();
                        TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).moveRowDownOne(selectedRow);
                        if (TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().editCellAt(selectedRow + 1, selectedColumn)) {
                            TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().changeSelection(selectedRow + 1, selectedColumn, false, false);
                        }
                    }
                }
            }
        });
        this.downAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int index = TransformsToolBar.this.container.getFuzzersPanel().getFuzzersTable().getSelectedRow();
                if (index != -1) {
                    int selectedRow = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedRow();
                    int selectedColumn = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedColumn();
                    if (selectedRow > -1 && selectedRow < TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).getRowCount() - 1) {
                        TransformsToolBar.this.stopEdit();
                        TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).moveRowDownAll(selectedRow);
                        if (TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().editCellAt(TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).getRowCount() - 1, selectedColumn)) {
                            TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().changeSelection(TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).getRowCount() - 1, selectedColumn, false, false);
                        }
                    }
                }
            }
        });
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int selectedRow;
                int index = TransformsToolBar.this.container.getFuzzersPanel().getFuzzersTable().getSelectedRow();
                if (index != -1 && (selectedRow = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getSelectedRow()) != -1) {
                    TransformsToolBar.this.stopEdit();
                    TransformsToolBar.this.container.getTransformsPanel().getTransformsTableModel(index).removeRow(selectedRow);
                    int numRows = TransformsToolBar.this.container.getTransformsPanel().getTransformsTable().getRowCount();
                    if (numRows == 0) {
                        TransformsToolBar.this.disableDelete();
                    } else if (numRows == 1) {
                        TransformsToolBar.this.disablePositionModifiers();
                    }
                }
            }
        });
    }

    private void stopEdit() {
        if (this.container.getTransformsPanel().getTransformsTable().getCellEditor() != null) {
            this.container.getTransformsPanel().getTransformsTable().getCellEditor().stopCellEditing();
        }
    }
}

