/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.t2k.CharToGlyphMapper;
import com.sun.t2k.Disposer;
import com.sun.t2k.DisposerRecord;
import com.sun.t2k.FontConstants;
import com.sun.t2k.FontFileReader;
import com.sun.t2k.FontFileWriter;
import com.sun.t2k.OpenTypeGlyphMapper;
import com.sun.t2k.T2KFontFactory;
import com.sun.t2k.T2KFontStrike;
import com.sun.t2k.T2KFontStrikeDesc;
import com.sun.t2k.T2KMetrics;
import com.sun.t2k.WoffDecoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class T2KFontFile
implements FontResource,
FontConstants {
    private static final int TRUETYPE_FONT = 1;
    Map<T2KFontStrikeDesc, WeakReference<T2KFontStrike>> strikeMap = new ConcurrentHashMap<T2KFontStrikeDesc, WeakReference<T2KFontStrike>>();
    private long pScaler = 0L;
    private boolean scalerInited = false;
    private ScalerDisposer scalerDisposer;
    private int fontInstallationType = -1;
    private String familyName;
    private String fullName;
    private String psName;
    private String localeFamilyName;
    private String localeFullName;
    private String styleName;
    private String localeStyleName;
    private String filename;
    private int filesize;
    private FontFileReader filereader;
    int numGlyphs = -1;
    private int fontIndex;
    private boolean isCFF;
    private boolean isCopy = false;
    private boolean isTracked = false;
    private boolean isDecoded = false;
    private boolean isRegistered = true;
    private static HashMap<String, T2KFontFile> fileNameToT2KFontResourceMap;
    private Object peer;
    int directoryCount = 1;
    int numTables;
    DirectoryEntry[] tableDirectory;
    private static final int fsSelectionItalicBit = 1;
    private static final int fsSelectionBoldBit = 32;
    private static final int MACSTYLE_BOLD_BIT = 1;
    private static final int MACSTYLE_ITALIC_BIT = 2;
    private boolean isBold;
    private boolean isItalic;
    private float upem;
    private float ascent;
    private float descent;
    private float linegap;
    private float xHeight;
    private int numHMetrics;
    public static final int MAC_PLATFORM_ID = 1;
    public static final int MACROMAN_SPECIFIC_ID = 0;
    public static final int MACROMAN_ENGLISH_LANG = 0;
    public static final int MS_PLATFORM_ID = 3;
    public static final short MS_ENGLISH_LOCALE_ID = 1033;
    public static final int FAMILY_NAME_ID = 1;
    public static final int STYLE_NAME_ID = 2;
    public static final int FULL_NAME_ID = 4;
    public static final int PS_NAME_ID = 6;
    private static Map<String, Short> lcidMap;
    static short nameLocaleID;
    private OpenTypeGlyphMapper mapper = null;
    char[] advanceWidths = null;
    int[][] bbArr = null;
    static final int[] EMPTY_BOUNDS;
    private float[] styleMetrics;

    static T2KFontFile createFontResource(String string, int n) {
        return T2KFontFile.createFontResource(string, n, true, false, false);
    }

    static T2KFontFile createFontResource(String string, int n, boolean bl, boolean bl2, boolean bl3) {
        String string2 = (string + n).toLowerCase();
        T2KFontFile t2KFontFile = fileNameToT2KFontResourceMap.get(string2);
        if (t2KFontFile != null) {
            return t2KFontFile;
        }
        try {
            t2KFontFile = new T2KFontFile(null, string, n, bl, bl2, bl3);
            if (bl) {
                T2KFontFactory.storeInMap(t2KFontFile.getFullName(), t2KFontFile);
                fileNameToT2KFontResourceMap.put(string2, t2KFontFile);
            }
            return t2KFontFile;
        }
        catch (Exception exception) {
            if (T2KFontFactory.debugFonts) {
                exception.printStackTrace();
            }
            return null;
        }
    }

    static T2KFontFile createFontResource(String string, String string2) {
        return T2KFontFile.createFontResource(string, string2, true, false, false);
    }

    static T2KFontFile createFontResource(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2.toLowerCase();
        if (string3.endsWith(".ttc")) {
            T2KFontFile t2KFontFile;
            int n = 0;
            T2KFontFile t2KFontFile2 = null;
            do {
                String string4 = (string2 + n).toLowerCase();
                try {
                    t2KFontFile = fileNameToT2KFontResourceMap.get(string4);
                    if (t2KFontFile != null) {
                        if (!string.equals(t2KFontFile.getFullName())) continue;
                        return t2KFontFile;
                    }
                    t2KFontFile = new T2KFontFile(string, string2, n, bl, bl2, bl3);
                }
                catch (Exception exception) {
                    if (T2KFontFactory.debugFonts) {
                        exception.printStackTrace();
                    }
                    return null;
                }
                String string5 = t2KFontFile.getFullName();
                if (bl) {
                    T2KFontFactory.storeInMap(string5, t2KFontFile);
                    fileNameToT2KFontResourceMap.put(string4, t2KFontFile);
                }
                if (n != 0 && !string.equals(string5)) continue;
                t2KFontFile2 = t2KFontFile;
            } while (++n < t2KFontFile.getFontCount());
            return t2KFontFile2;
        }
        return T2KFontFile.createFontResource(string2, 0, bl, bl2, bl3);
    }

    private T2KFontFile(String string, String string2, int n, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.filename = string2;
        this.isRegistered = bl;
        this.isCopy = bl2;
        this.isTracked = bl3;
        this.init(string, n);
    }

    private synchronized void initScaler() {
        if (this.pScaler == 0L && !this.scalerInited) {
            int n = 1;
            byte[] byArray = this.filename.getBytes();
            this.pScaler = this.initNativeScaler(n, this.fontIndex, false, this.filename, byArray, this.filesize, null);
            this.scalerInited = true;
            if (!this.isRegistered()) {
                this.scalerDisposer = new ScalerDisposer(this.pScaler);
                Disposer.addRecord(this, this.scalerDisposer);
            }
        }
    }

    private void invalidateScaler() {
        this.pScaler = 0L;
        if (this.scalerDisposer != null) {
            this.scalerDisposer.pScaler = 0L;
        }
    }

    WeakReference<T2KFontFile> createFileDisposer(T2KFontFactory t2KFontFactory) {
        FileDisposer fileDisposer = new FileDisposer(this.filename, this.isTracked);
        WeakReference weakReference = Disposer.addRecord(this, fileDisposer);
        fileDisposer.setFactory(t2KFontFactory, weakReference);
        return weakReference;
    }

    void setIsDecoded(boolean bl) {
        this.isDecoded = bl;
    }

    synchronized void disposeOnShutdown() {
        if (this.pScaler != 0L) {
            T2KFontFile.disposeNativeScaler(this.pScaler);
            if (T2KFontFactory.debugFonts) {
                System.err.println("pScaler freed: " + this.pScaler);
            }
            this.pScaler = 0L;
        }
        if (this.isCopy || this.isDecoded) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        new File(T2KFontFile.this.filename).delete();
                        T2KFontFile.this.isCopy = (T2KFontFile.this.isDecoded = false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
            if (T2KFontFactory.debugFonts) {
                System.err.println("Temp file deleted: " + this.filename);
            }
        }
    }

    @Override
    public int getDefaultAAMode() {
        return 0;
    }

    boolean isInstalledFont() {
        if (this.familyName.startsWith("Amble")) {
            return false;
        }
        if (this.fontInstallationType == -1) {
            this.fontInstallationType = T2KFontFactory.isInstalledFont(this.filename) ? 1 : 0;
        }
        return this.fontInstallationType > 0;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPSName() {
        if (this.psName == null) {
            this.psName = this.fullName;
        }
        return this.psName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public String getLocaleFullName() {
        return this.localeFullName;
    }

    @Override
    public String getLocaleFamilyName() {
        return this.localeFamilyName;
    }

    @Override
    public String getLocaleStyleName() {
        return this.localeStyleName;
    }

    @Override
    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            FontFileReader.Buffer buffer = this.readTable(1835104368);
            this.numGlyphs = buffer.getChar(4);
        }
        return this.numGlyphs;
    }

    @Override
    public Object getPeer() {
        return this.peer;
    }

    @Override
    public void setPeer(Object object) {
        this.peer = object;
    }

    static synchronized native void freePointer(long var0);

    private static native void initNativeIDs();

    private synchronized native long initNativeScaler(int var1, int var2, boolean var3, String var4, byte[] var5, int var6, int[] var7);

    private static native void disposeNativeScaler(long var0);

    synchronized long createScalerContext(double[] dArray, int n, int n2, boolean bl, float f, float f2) {
        this.initScaler();
        return this.createScalerContext(this.pScaler, dArray, n, n2, bl, f, f2);
    }

    private synchronized native long createScalerContext(long var1, double[] var3, int var4, int var5, boolean var6, float var7, float var8);

    synchronized Path2D getGlyphOutline(long l, int n) {
        return this.getGlyphOutline(this.pScaler, l, n);
    }

    private native Path2D getGlyphOutline(long var1, long var3, int var5);

    synchronized RectBounds getGlyphBounds(long l, int n) {
        return this.getGlyphBounds(this.pScaler, l, n);
    }

    private native RectBounds getGlyphBounds(long var1, long var3, int var5);

    synchronized float[] getGlyphMetrics(long l, int n) {
        return this.getGlyphMetrics(this.pScaler, l, n);
    }

    private native float[] getGlyphMetrics(long var1, long var3, int var5);

    synchronized long getGlyphImage(long l, int n) {
        return this.getGlyphImage(this.pScaler, l, n);
    }

    private native long getGlyphImage(long var1, long var3, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized FontFileReader.Buffer readTable(int n) {
        FontFileReader.Buffer buffer = null;
        boolean bl = false;
        try {
            bl = this.filereader.openFile();
            DirectoryEntry directoryEntry = this.getDirectoryEntry(n);
            if (directoryEntry != null) {
                buffer = this.filereader.readBlock(directoryEntry.offset, directoryEntry.length);
            }
        }
        catch (Exception exception) {
            if (T2KFontFactory.debugFonts) {
                exception.printStackTrace();
            }
        }
        finally {
            if (bl) {
                try {
                    this.filereader.closeFile();
                }
                catch (Exception exception) {}
            }
        }
        return buffer;
    }

    public int getFontCount() {
        return this.directoryCount;
    }

    DirectoryEntry getDirectoryEntry(int n) {
        for (int i = 0; i < this.numTables; ++i) {
            if (this.tableDirectory[i].tag != n) continue;
            return this.tableDirectory[i];
        }
        return null;
    }

    private final void init(String string, int n) throws Exception {
        this.filereader = new FontFileReader(this.filename);
        FontFileWriter fontFileWriter = null;
        try {
            FontFileReader.Buffer buffer;
            if (!this.filereader.openFile()) {
                throw new FileNotFoundException("Unable to create FontResource for file " + this.filename);
            }
            FontFileReader.Buffer buffer2 = this.filereader.readBlock(0, 12);
            int n2 = buffer2.getInt();
            if (n2 == 2001684038) {
                fontFileWriter = new WoffDecoder();
                File file = fontFileWriter.openFile();
                ((WoffDecoder)fontFileWriter).decode(this.filereader);
                fontFileWriter.closeFile();
                this.filereader.closeFile();
                this.filereader = new FontFileReader(file.getPath());
                if (!this.filereader.openFile()) {
                    throw new FileNotFoundException("Unable to create FontResource for file " + this.filename);
                }
                buffer2 = this.filereader.readBlock(0, 12);
                n2 = buffer2.getInt();
            }
            this.filesize = (int)this.filereader.getLength();
            int n3 = 0;
            switch (n2) {
                case 1953784678: {
                    buffer2.getInt();
                    this.directoryCount = buffer2.getInt();
                    if (n >= this.directoryCount) {
                        throw new Exception("Bad collection index");
                    }
                    this.fontIndex = n;
                    buffer2 = this.filereader.readBlock(12 + 4 * n, 4);
                    n3 = buffer2.getInt();
                    break;
                }
                case 65536: 
                case 1953658213: {
                    break;
                }
                case 0x4F54544F: {
                    this.isCFF = true;
                    break;
                }
                default: {
                    throw new Exception("Unsupported sfnt " + this.filename);
                }
            }
            buffer2 = this.filereader.readBlock(n3 + 4, 2);
            this.numTables = buffer2.getShort();
            int n4 = n3 + 12;
            FontFileReader.Buffer buffer3 = this.filereader.readBlock(n4, this.numTables * 16);
            this.tableDirectory = new DirectoryEntry[this.numTables];
            for (int i = 0; i < this.numTables; ++i) {
                DirectoryEntry directoryEntry;
                this.tableDirectory[i] = directoryEntry = new DirectoryEntry();
                directoryEntry.tag = buffer3.getInt();
                buffer3.skip(4);
                directoryEntry.offset = buffer3.getInt();
                directoryEntry.length = buffer3.getInt();
                if (directoryEntry.offset + directoryEntry.length <= this.filesize) continue;
                throw new Exception("bad table, tag=" + directoryEntry.tag);
            }
            DirectoryEntry directoryEntry = this.getDirectoryEntry(1751474532);
            FontFileReader.Buffer buffer4 = this.filereader.readBlock(directoryEntry.offset, directoryEntry.length);
            this.upem = buffer4.getShort(18) & 0xFFFF;
            if (this.upem < 16.0f || this.upem > 16384.0f) {
                this.upem = 2048.0f;
            }
            if ((buffer = this.readTable(1751672161)) == null) {
                this.numHMetrics = -1;
            } else {
                this.ascent = -((float)buffer.getShort(4));
                this.descent = -((float)buffer.getShort(6));
                this.linegap = buffer.getShort(8);
                this.numHMetrics = buffer.getChar(34) & 0xFFFF;
            }
            this.getNumGlyphs();
            this.setStyle();
            this.initNames();
            if (this.familyName == null || this.fullName == null) {
                String string2;
                String string3 = string2 = string != null ? string : "";
                if (this.fullName == null) {
                    String string4 = this.fullName = this.familyName != null ? this.familyName : string2;
                }
                if (this.familyName == null) {
                    this.familyName = this.fullName != null ? this.fullName : string2;
                }
                throw new Exception("Font name not found.");
            }
            if (fontFileWriter != null) {
                this.isDecoded = true;
                this.filename = this.filereader.getFilename();
                T2KFontFactory.getFontFactory().addDecodedFont(this);
            }
        }
        catch (Exception exception) {
            if (fontFileWriter != null) {
                fontFileWriter.deleteFile();
            }
            throw exception;
        }
        finally {
            this.filereader.closeFile();
        }
    }

    private void setStyle() {
        DirectoryEntry directoryEntry = this.getDirectoryEntry(1330851634);
        if (directoryEntry != null) {
            FontFileReader.Buffer buffer = this.filereader.readBlock(directoryEntry.offset, directoryEntry.length);
            int n = buffer.getChar(62) & 0xFFFF;
            this.isItalic = (n & 1) != 0;
            this.isBold = (n & 0x20) != 0;
            this.xHeight = 0.0f;
            if (directoryEntry.length >= 88) {
                this.xHeight = (float)(buffer.getChar(86) & 0xFFFF) / this.upem;
            }
        } else {
            DirectoryEntry directoryEntry2 = this.getDirectoryEntry(1751474532);
            FontFileReader.Buffer buffer = this.filereader.readBlock(directoryEntry2.offset, directoryEntry2.length);
            short s = buffer.getShort(44);
            this.isItalic = (s & 2) != 0;
            this.isBold = (s & 1) != 0;
        }
    }

    @Override
    public boolean isBold() {
        return this.isBold;
    }

    @Override
    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    void initNames() throws Exception {
        byte[] byArray = new byte[256];
        DirectoryEntry directoryEntry = this.getDirectoryEntry(1851878757);
        FontFileReader.Buffer buffer = this.filereader.readBlock(directoryEntry.offset, directoryEntry.length);
        buffer.skip(2);
        int n = buffer.getShort();
        int n2 = buffer.getShort() & 0xFFFF;
        for (int i = 0; i < n; ++i) {
            short s = buffer.getShort();
            if (s != 3 && s != 1) {
                buffer.skip(10);
                continue;
            }
            short s2 = buffer.getShort();
            if (s == 3 && s2 > 1 || s == 1 && s2 != 0) {
                buffer.skip(8);
                continue;
            }
            short s3 = buffer.getShort();
            if (s == 1 && s3 != 0) {
                buffer.skip(6);
                continue;
            }
            short s4 = buffer.getShort();
            int n3 = buffer.getShort() & 0xFFFF;
            int n4 = (buffer.getShort() & 0xFFFF) + n2;
            String string = null;
            switch (s4) {
                case 1: {
                    if (this.familyName != null && s3 != 1033 && s3 != nameLocaleID) break;
                    buffer.get(n4, byArray, 0, n3);
                    String string2 = s == 1 ? "US-ASCII" : "UTF-16BE";
                    string = new String(byArray, 0, n3, string2);
                    if (this.familyName == null || s3 == 1033) {
                        this.familyName = string;
                    }
                    if (s3 != nameLocaleID) break;
                    this.localeFamilyName = string;
                    break;
                }
                case 4: {
                    if (this.fullName != null && s3 != 1033 && s3 != nameLocaleID) break;
                    buffer.get(n4, byArray, 0, n3);
                    String string2 = s == 1 ? "US-ASCII" : "UTF-16BE";
                    string = new String(byArray, 0, n3, string2);
                    if (this.fullName == null || s3 == 1033) {
                        this.fullName = string;
                    }
                    if (s3 != nameLocaleID) break;
                    this.localeFullName = string;
                    break;
                }
                case 6: {
                    if (this.psName != null) break;
                    buffer.get(n4, byArray, 0, n3);
                    String string2 = s == 1 ? "US-ASCII" : "UTF-16BE";
                    this.psName = new String(byArray, 0, n3, string2);
                    break;
                }
                case 2: {
                    if (this.styleName != null && s3 != 1033 && s3 != nameLocaleID) break;
                    buffer.get(n4, byArray, 0, n3);
                    String string2 = s == 1 ? "US-ASCII" : "UTF-16BE";
                    string = new String(byArray, 0, n3, string2);
                    if (this.styleName == null || s3 == 1033) {
                        this.styleName = string;
                    }
                    if (s3 != nameLocaleID) break;
                    this.localeStyleName = string;
                    break;
                }
            }
            if (this.localeFamilyName == null) {
                this.localeFamilyName = this.familyName;
            }
            if (this.localeFullName == null) {
                this.localeFullName = this.fullName;
            }
            if (this.localeStyleName != null) continue;
            this.localeStyleName = this.styleName;
        }
    }

    private static void addLCIDMapEntry(Map<String, Short> map, String string, short s) {
        map.put(string, s);
    }

    private static synchronized void createLCIDMap() {
        if (lcidMap != null) {
            return;
        }
        HashMap<String, Short> hashMap = new HashMap<String, Short>(200);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar", (short)1025);
        T2KFontFile.addLCIDMapEntry(hashMap, "bg", (short)1026);
        T2KFontFile.addLCIDMapEntry(hashMap, "ca", (short)1027);
        T2KFontFile.addLCIDMapEntry(hashMap, "zh", (short)1028);
        T2KFontFile.addLCIDMapEntry(hashMap, "cs", (short)1029);
        T2KFontFile.addLCIDMapEntry(hashMap, "da", (short)1030);
        T2KFontFile.addLCIDMapEntry(hashMap, "de", (short)1031);
        T2KFontFile.addLCIDMapEntry(hashMap, "el", (short)1032);
        T2KFontFile.addLCIDMapEntry(hashMap, "es", (short)1034);
        T2KFontFile.addLCIDMapEntry(hashMap, "fi", (short)1035);
        T2KFontFile.addLCIDMapEntry(hashMap, "fr", (short)1036);
        T2KFontFile.addLCIDMapEntry(hashMap, "iw", (short)1037);
        T2KFontFile.addLCIDMapEntry(hashMap, "hu", (short)1038);
        T2KFontFile.addLCIDMapEntry(hashMap, "is", (short)1039);
        T2KFontFile.addLCIDMapEntry(hashMap, "it", (short)1040);
        T2KFontFile.addLCIDMapEntry(hashMap, "ja", (short)1041);
        T2KFontFile.addLCIDMapEntry(hashMap, "ko", (short)1042);
        T2KFontFile.addLCIDMapEntry(hashMap, "nl", (short)1043);
        T2KFontFile.addLCIDMapEntry(hashMap, "no", (short)1044);
        T2KFontFile.addLCIDMapEntry(hashMap, "pl", (short)1045);
        T2KFontFile.addLCIDMapEntry(hashMap, "pt", (short)1046);
        T2KFontFile.addLCIDMapEntry(hashMap, "rm", (short)1047);
        T2KFontFile.addLCIDMapEntry(hashMap, "ro", (short)1048);
        T2KFontFile.addLCIDMapEntry(hashMap, "ru", (short)1049);
        T2KFontFile.addLCIDMapEntry(hashMap, "hr", (short)1050);
        T2KFontFile.addLCIDMapEntry(hashMap, "sk", (short)1051);
        T2KFontFile.addLCIDMapEntry(hashMap, "sq", (short)1052);
        T2KFontFile.addLCIDMapEntry(hashMap, "sv", (short)1053);
        T2KFontFile.addLCIDMapEntry(hashMap, "th", (short)1054);
        T2KFontFile.addLCIDMapEntry(hashMap, "tr", (short)1055);
        T2KFontFile.addLCIDMapEntry(hashMap, "ur", (short)1056);
        T2KFontFile.addLCIDMapEntry(hashMap, "in", (short)1057);
        T2KFontFile.addLCIDMapEntry(hashMap, "uk", (short)1058);
        T2KFontFile.addLCIDMapEntry(hashMap, "be", (short)1059);
        T2KFontFile.addLCIDMapEntry(hashMap, "sl", (short)1060);
        T2KFontFile.addLCIDMapEntry(hashMap, "et", (short)1061);
        T2KFontFile.addLCIDMapEntry(hashMap, "lv", (short)1062);
        T2KFontFile.addLCIDMapEntry(hashMap, "lt", (short)1063);
        T2KFontFile.addLCIDMapEntry(hashMap, "fa", (short)1065);
        T2KFontFile.addLCIDMapEntry(hashMap, "vi", (short)1066);
        T2KFontFile.addLCIDMapEntry(hashMap, "hy", (short)1067);
        T2KFontFile.addLCIDMapEntry(hashMap, "eu", (short)1069);
        T2KFontFile.addLCIDMapEntry(hashMap, "mk", (short)1071);
        T2KFontFile.addLCIDMapEntry(hashMap, "tn", (short)1074);
        T2KFontFile.addLCIDMapEntry(hashMap, "xh", (short)1076);
        T2KFontFile.addLCIDMapEntry(hashMap, "zu", (short)1077);
        T2KFontFile.addLCIDMapEntry(hashMap, "af", (short)1078);
        T2KFontFile.addLCIDMapEntry(hashMap, "ka", (short)1079);
        T2KFontFile.addLCIDMapEntry(hashMap, "fo", (short)1080);
        T2KFontFile.addLCIDMapEntry(hashMap, "hi", (short)1081);
        T2KFontFile.addLCIDMapEntry(hashMap, "mt", (short)1082);
        T2KFontFile.addLCIDMapEntry(hashMap, "se", (short)1083);
        T2KFontFile.addLCIDMapEntry(hashMap, "gd", (short)1084);
        T2KFontFile.addLCIDMapEntry(hashMap, "ms", (short)1086);
        T2KFontFile.addLCIDMapEntry(hashMap, "kk", (short)1087);
        T2KFontFile.addLCIDMapEntry(hashMap, "ky", (short)1088);
        T2KFontFile.addLCIDMapEntry(hashMap, "sw", (short)1089);
        T2KFontFile.addLCIDMapEntry(hashMap, "tt", (short)1092);
        T2KFontFile.addLCIDMapEntry(hashMap, "bn", (short)1093);
        T2KFontFile.addLCIDMapEntry(hashMap, "pa", (short)1094);
        T2KFontFile.addLCIDMapEntry(hashMap, "gu", (short)1095);
        T2KFontFile.addLCIDMapEntry(hashMap, "ta", (short)1097);
        T2KFontFile.addLCIDMapEntry(hashMap, "te", (short)1098);
        T2KFontFile.addLCIDMapEntry(hashMap, "kn", (short)1099);
        T2KFontFile.addLCIDMapEntry(hashMap, "ml", (short)1100);
        T2KFontFile.addLCIDMapEntry(hashMap, "mr", (short)1102);
        T2KFontFile.addLCIDMapEntry(hashMap, "sa", (short)1103);
        T2KFontFile.addLCIDMapEntry(hashMap, "mn", (short)1104);
        T2KFontFile.addLCIDMapEntry(hashMap, "cy", (short)1106);
        T2KFontFile.addLCIDMapEntry(hashMap, "gl", (short)1110);
        T2KFontFile.addLCIDMapEntry(hashMap, "dv", (short)1125);
        T2KFontFile.addLCIDMapEntry(hashMap, "qu", (short)1131);
        T2KFontFile.addLCIDMapEntry(hashMap, "mi", (short)1153);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_IQ", (short)2049);
        T2KFontFile.addLCIDMapEntry(hashMap, "zh_CN", (short)2052);
        T2KFontFile.addLCIDMapEntry(hashMap, "de_CH", (short)2055);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_GB", (short)2057);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_MX", (short)2058);
        T2KFontFile.addLCIDMapEntry(hashMap, "fr_BE", (short)2060);
        T2KFontFile.addLCIDMapEntry(hashMap, "it_CH", (short)2064);
        T2KFontFile.addLCIDMapEntry(hashMap, "nl_BE", (short)2067);
        T2KFontFile.addLCIDMapEntry(hashMap, "no_NO_NY", (short)2068);
        T2KFontFile.addLCIDMapEntry(hashMap, "pt_PT", (short)2070);
        T2KFontFile.addLCIDMapEntry(hashMap, "ro_MD", (short)2072);
        T2KFontFile.addLCIDMapEntry(hashMap, "ru_MD", (short)2073);
        T2KFontFile.addLCIDMapEntry(hashMap, "sr_CS", (short)2074);
        T2KFontFile.addLCIDMapEntry(hashMap, "sv_FI", (short)2077);
        T2KFontFile.addLCIDMapEntry(hashMap, "az_AZ", (short)2092);
        T2KFontFile.addLCIDMapEntry(hashMap, "se_SE", (short)2107);
        T2KFontFile.addLCIDMapEntry(hashMap, "ga_IE", (short)2108);
        T2KFontFile.addLCIDMapEntry(hashMap, "ms_BN", (short)2110);
        T2KFontFile.addLCIDMapEntry(hashMap, "uz_UZ", (short)2115);
        T2KFontFile.addLCIDMapEntry(hashMap, "qu_EC", (short)2155);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_EG", (short)3073);
        T2KFontFile.addLCIDMapEntry(hashMap, "zh_HK", (short)3076);
        T2KFontFile.addLCIDMapEntry(hashMap, "de_AT", (short)3079);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_AU", (short)3081);
        T2KFontFile.addLCIDMapEntry(hashMap, "fr_CA", (short)3084);
        T2KFontFile.addLCIDMapEntry(hashMap, "sr_CS", (short)3098);
        T2KFontFile.addLCIDMapEntry(hashMap, "se_FI", (short)3131);
        T2KFontFile.addLCIDMapEntry(hashMap, "qu_PE", (short)3179);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_LY", (short)4097);
        T2KFontFile.addLCIDMapEntry(hashMap, "zh_SG", (short)4100);
        T2KFontFile.addLCIDMapEntry(hashMap, "de_LU", (short)4103);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_CA", (short)4105);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_GT", (short)4106);
        T2KFontFile.addLCIDMapEntry(hashMap, "fr_CH", (short)4108);
        T2KFontFile.addLCIDMapEntry(hashMap, "hr_BA", (short)4122);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_DZ", (short)5121);
        T2KFontFile.addLCIDMapEntry(hashMap, "zh_MO", (short)5124);
        T2KFontFile.addLCIDMapEntry(hashMap, "de_LI", (short)5127);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_NZ", (short)5129);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_CR", (short)5130);
        T2KFontFile.addLCIDMapEntry(hashMap, "fr_LU", (short)5132);
        T2KFontFile.addLCIDMapEntry(hashMap, "bs_BA", (short)5146);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_MA", (short)6145);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_IE", (short)6153);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_PA", (short)6154);
        T2KFontFile.addLCIDMapEntry(hashMap, "fr_MC", (short)6156);
        T2KFontFile.addLCIDMapEntry(hashMap, "sr_BA", (short)6170);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_TN", (short)7169);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_ZA", (short)7177);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_DO", (short)7178);
        T2KFontFile.addLCIDMapEntry(hashMap, "sr_BA", (short)7194);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_OM", (short)8193);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_JM", (short)8201);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_VE", (short)8202);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_YE", (short)9217);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_CO", (short)9226);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_SY", (short)10241);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_BZ", (short)10249);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_PE", (short)10250);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_JO", (short)11265);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_TT", (short)11273);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_AR", (short)11274);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_LB", (short)12289);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_ZW", (short)12297);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_EC", (short)12298);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_KW", (short)13313);
        T2KFontFile.addLCIDMapEntry(hashMap, "en_PH", (short)13321);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_CL", (short)13322);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_AE", (short)14337);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_UY", (short)14346);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_BH", (short)15361);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_PY", (short)15370);
        T2KFontFile.addLCIDMapEntry(hashMap, "ar_QA", (short)16385);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_BO", (short)16394);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_SV", (short)17418);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_HN", (short)18442);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_NI", (short)19466);
        T2KFontFile.addLCIDMapEntry(hashMap, "es_PR", (short)20490);
        lcidMap = hashMap;
    }

    private static short getLCIDFromLocale(Locale locale) {
        if (locale.equals(Locale.US) || locale.getLanguage().equals("en")) {
            return 1033;
        }
        if (lcidMap == null) {
            T2KFontFile.createLCIDMap();
        }
        String string = locale.toString();
        while (!string.isEmpty()) {
            Short s = lcidMap.get(string);
            if (s != null) {
                return s;
            }
            int n = string.lastIndexOf(95);
            if (n < 1) {
                return 1033;
            }
            string = string.substring(0, n);
        }
        return 1033;
    }

    private static short getSystemLCID() {
        if (T2KFontFactory.isWindows) {
            return T2KFontFactory.getSystemLCID();
        }
        return T2KFontFile.getLCIDFromLocale(Locale.getDefault());
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new OpenTypeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public FontStrike getStrike(PGFont pGFont, BaseTransform baseTransform) {
        return this.getStrike(pGFont.getSize(), baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform) {
        return this.getStrike(f, baseTransform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(PGFont pGFont, BaseTransform baseTransform, int n) {
        return this.getStrike(pGFont.getSize(), baseTransform, n);
    }

    @Override
    public FontStrike getStrike(float f, BaseTransform baseTransform, int n) {
        T2KFontStrikeDesc t2KFontStrikeDesc = new T2KFontStrikeDesc(f, baseTransform, n);
        WeakReference<T2KFontStrike> weakReference = this.strikeMap.get(t2KFontStrikeDesc);
        T2KFontStrike t2KFontStrike = null;
        if (weakReference != null) {
            t2KFontStrike = (T2KFontStrike)weakReference.get();
        }
        if (t2KFontStrike == null) {
            t2KFontStrike = new T2KFontStrike(this, f, baseTransform, t2KFontStrikeDesc);
            weakReference = t2KFontStrike.disposer != null ? Disposer.addRecord(t2KFontStrike, t2KFontStrike.disposer) : new WeakReference<T2KFontStrike>(t2KFontStrike);
            this.strikeMap.put(t2KFontStrikeDesc, weakReference);
        }
        return t2KFontStrike;
    }

    public Map getStrikeMap() {
        return this.strikeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getAdvance(int n, float f) {
        if (this.advanceWidths == null && this.numHMetrics > 0) {
            T2KFontFile t2KFontFile = this;
            synchronized (t2KFontFile) {
                FontFileReader.Buffer buffer = this.readTable(1752003704);
                if (buffer == null) {
                    this.numHMetrics = -1;
                    return 0.0f;
                }
                char[] cArray = new char[this.numHMetrics];
                for (int i = 0; i < this.numHMetrics; ++i) {
                    cArray[i] = buffer.getChar(i * 4);
                }
                this.advanceWidths = cArray;
            }
        }
        if (this.numHMetrics > 0) {
            char c = n < this.numHMetrics ? this.advanceWidths[n] : this.advanceWidths[this.numHMetrics - 1];
            return (float)(c & 0xFFFF) * f / this.upem;
        }
        return 0.0f;
    }

    private synchronized native int[] getGlyphBoundingBoxNative(long var1, int var3);

    @Override
    public float[] getGlyphBoundingBox(int n, float f, float[] fArray) {
        int[] nArray;
        if (this.bbArr == null) {
            this.bbArr = new int[this.numGlyphs][];
        }
        int[] nArray2 = nArray = n < this.numGlyphs ? this.bbArr[n] : EMPTY_BOUNDS;
        if (nArray == null) {
            if (this.pScaler == 0L) {
                this.initScaler();
            }
            if ((nArray = this.isCFF ? this.getGlyphBoundingBoxCFF(n, f) : this.getGlyphBoundingBoxNative(this.pScaler, n)) == null) {
                nArray = EMPTY_BOUNDS;
            }
            this.bbArr[n] = nArray;
        }
        if (fArray == null || fArray.length < 4) {
            fArray = new float[4];
        }
        float f2 = f / this.upem;
        fArray[0] = (float)nArray[0] * f2;
        fArray[1] = (float)nArray[1] * f2;
        fArray[2] = (float)nArray[2] * f2;
        fArray[3] = (float)nArray[3] * f2;
        return fArray;
    }

    private int[] getGlyphBoundingBoxCFF(int n, float f) {
        if (f < 1.0f || f > 48.0f) {
            f = 12.0f;
        }
        T2KFontStrike t2KFontStrike = (T2KFontStrike)this.getStrike(f, BaseTransform.IDENTITY_TRANSFORM);
        long l = t2KFontStrike.getScalerContext();
        RectBounds rectBounds = this.getGlyphBounds(this.pScaler, l, n);
        int[] nArray = new int[4];
        float f2 = this.upem / f;
        nArray[0] = Math.round(rectBounds.getMinX() * f2);
        nArray[1] = Math.round(rectBounds.getMinY() * f2);
        nArray[2] = Math.round(rectBounds.getMaxX() * f2);
        nArray[3] = Math.round(rectBounds.getMaxY() * f2);
        return nArray;
    }

    T2KMetrics getFontMetrics(long l, float f) {
        if (this.xHeight == 0.0f) {
            int n = this.getGlyphMapper().charToGlyph('x');
            if (this.mapper.getMissingGlyphCode() != n) {
                this.xHeight = this.getGlyphBounds(l, n).getHeight() / f;
            }
        }
        return new T2KMetrics(this.ascent * f / this.upem, this.descent * f / this.upem, this.linegap * f / this.upem, this.xHeight * f);
    }

    float[] getStyleMetrics(float f) {
        float[] fArray;
        if (this.styleMetrics == null) {
            fArray = new float[4];
            FontFileReader.Buffer buffer = this.readTable(1330851634);
            if (buffer == null || buffer.capacity() < 30 || this.upem < 0.0f) {
                fArray[0] = -0.4f;
                fArray[1] = 0.05f;
            } else {
                fArray[0] = (float)(-buffer.getShort(28)) / this.upem;
                fArray[1] = (float)buffer.getShort(26) / this.upem;
            }
            FontFileReader.Buffer buffer2 = this.readTable(1886352244);
            if (buffer2 == null || buffer2.capacity() < 12 || this.upem < 0.0f) {
                fArray[2] = 0.1f;
                fArray[3] = 0.05f;
            } else {
                fArray[2] = (float)(-buffer2.getShort(8)) / this.upem;
                fArray[3] = (float)buffer2.getShort(10) / this.upem;
            }
            this.styleMetrics = fArray;
        }
        fArray = new float[4];
        for (int i = 0; i < 4; ++i) {
            fArray[i] = this.styleMetrics[i] * f;
        }
        return fArray;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NativeLibLoader.loadLibrary("javafx-font");
                return null;
            }
        });
        T2KFontFile.initNativeIDs();
        fileNameToT2KFontResourceMap = new HashMap();
        nameLocaleID = T2KFontFile.getSystemLCID();
        EMPTY_BOUNDS = new int[4];
    }

    static class DirectoryEntry {
        int tag;
        int offset;
        int length;

        DirectoryEntry() {
        }
    }

    static class FileDisposer
    implements DisposerRecord {
        String fileName;
        boolean isTracked;
        T2KFontFactory factory;
        WeakReference<T2KFontFile> refKey;

        public FileDisposer(String string, boolean bl) {
            this.fileName = string;
            this.isTracked = bl;
        }

        public void setFactory(T2KFontFactory t2KFontFactory, WeakReference<T2KFontFile> weakReference) {
            this.factory = t2KFontFactory;
            this.refKey = weakReference;
        }

        @Override
        public synchronized void dispose() {
            if (this.fileName != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        block5: {
                            try {
                                Object t;
                                File file = new File(FileDisposer.this.fileName);
                                int n = (int)file.length();
                                file.delete();
                                if (FileDisposer.this.isTracked) {
                                    FontFileWriter.FontTracker.getTracker().subBytes(n);
                                }
                                if (FileDisposer.this.factory != null && FileDisposer.this.refKey != null && (t = FileDisposer.this.refKey.get()) == null) {
                                    FileDisposer.this.factory.removeTmpFont(FileDisposer.this.refKey);
                                    FileDisposer.this.factory = null;
                                    FileDisposer.this.refKey = null;
                                }
                                if (T2KFontFactory.debugFonts) {
                                    System.err.println("FileDisposer=" + FileDisposer.this.fileName);
                                }
                            }
                            catch (Exception exception) {
                                if (!T2KFontFactory.debugFonts) break block5;
                                exception.printStackTrace();
                            }
                        }
                        return null;
                    }
                });
                this.fileName = null;
            }
        }
    }

    static class ScalerDisposer
    implements DisposerRecord {
        long pScaler;

        public ScalerDisposer(long l) {
            this.pScaler = l;
        }

        @Override
        public synchronized void dispose() {
            if (this.pScaler != 0L) {
                T2KFontFile.disposeNativeScaler(this.pScaler);
                if (T2KFontFactory.debugFonts) {
                    System.err.println("ScalerDisposer=" + this.pScaler);
                }
                this.pScaler = 0L;
            }
        }
    }
}

