/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.control.Cell;

public class CellSkinBase<C extends Cell, B extends CellBehaviorBase<C>>
extends LabeledSkinBase<C, B> {
    private DoubleProperty cellSize;
    boolean cellSizeSet = false;
    static final double DEFAULT_CELL_SIZE = 24.0;

    public final double getCellSize() {
        return this.cellSize == null ? 24.0 : this.cellSize.get();
    }

    public final ReadOnlyDoubleProperty cellSizeProperty() {
        return this.cellSizePropertyImpl();
    }

    private DoubleProperty cellSizePropertyImpl() {
        if (this.cellSize == null) {
            this.cellSize = new StyleableDoubleProperty(24.0){

                @Override
                public void set(double d) {
                    CellSkinBase.this.cellSizeSet = true;
                    super.set(d);
                }

                @Override
                public Object getBean() {
                    return CellSkinBase.this;
                }

                @Override
                public String getName() {
                    return "cellSize";
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.CELL_SIZE;
                }
            };
        }
        return this.cellSize;
    }

    public CellSkinBase(C c, B b) {
        super(c, b);
        this.consumeMouseEvents(false);
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return CellSkinBase.impl_CSS_STYLEABLES();
    }

    private static class StyleableProperties {
        private static final StyleableProperty<CellSkinBase, Number> CELL_SIZE = new StyleableProperty<CellSkinBase, Number>("-fx-cell-size", (StyleConverter)SizeConverter.getInstance(), (Number)24.0){

            @Override
            public void set(CellSkinBase cellSkinBase, Number number) {
                double d = number == null ? 24.0 : number.doubleValue();
                super.set(cellSkinBase, d <= 0.0 ? 24.0 : d);
            }

            @Override
            public boolean isSettable(CellSkinBase cellSkinBase) {
                return cellSkinBase.cellSize == null || !cellSkinBase.cellSize.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(CellSkinBase cellSkinBase) {
                return cellSkinBase.cellSizePropertyImpl();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, CELL_SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

