/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.LocaleUtils;

public final class LangImporter {
    private static final Logger logger = Logger.getLogger(LangImporter.class);
    private static final String MSG_SUCCESS = "options.lang.importer.dialog.message.success";
    private static final String MSG_ERROR = "options.lang.importer.dialog.message.error";
    private static final String MSG_FILE_NOT_FOUND = "options.lang.importer.dialog.message.filenotfound";

    private LangImporter() {
    }

    public static String importLanguagePack(String string) {
        Pattern pattern = LangImporter.createIncludedFilesPattern();
        int n = 0;
        String string2 = "";
        File file = new File(string);
        try (ZipFile zipFile = new ZipFile(file.getAbsolutePath());){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                Throwable throwable = null;
                try {
                    byte[] byArray = new byte[2048];
                    String string3 = zipEntry.getName();
                    if (!pattern.matcher(string3).find()) continue;
                    ++n;
                    Path path = Paths.get(Constant.getZapInstall(), string3);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]), byArray.length);
                    Throwable throwable2 = null;
                    try {
                        int n2;
                        while ((n2 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                            bufferedOutputStream.write(byArray, 0, n2);
                        }
                        bufferedOutputStream.flush();
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bufferedOutputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (bufferedInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    bufferedInputStream.close();
                }
            }
            string2 = n > 0 ? MSG_SUCCESS : MSG_ERROR;
        }
        catch (IOException iOException) {
            string2 = MSG_FILE_NOT_FOUND;
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
        if (View.isInitialised()) {
            JOptionPane.showMessageDialog(null, MessageFormat.format(Constant.messages.getString(string2), n), Constant.messages.getString("options.lang.importer.dialog.title"), n > 0 ? 1 : 0);
        }
        return string2;
    }

    static Pattern createIncludedFilesPattern() {
        String string = LocaleUtils.createResourceFilesRegex("Messages", ".properties");
        String string2 = LocaleUtils.createResourceFilesRegex("vulnerabilities", ".xml");
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 1);
        stringBuilder.append(string).append('|').append(string2);
        return Pattern.compile(stringBuilder.toString());
    }
}

