/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.forceduser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.forceduser.ContextForcedUserPanel;
import org.zaproxy.zap.extension.forceduser.ForcedUserAPI;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Enableable;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.ZapToggleButton;

public class ExtensionForcedUser
extends ExtensionAdaptor
implements ContextPanelFactory,
HttpSenderListener,
ContextDataFactory {
    private static final List<Class<?>> EXTENSION_DEPENDENCIES;
    private static final String FORCED_USER_MODE_OFF_ICON_RESOURCE = "/resource/icon/16/forcedUserOff.png";
    private static final String FORCED_USER_MODE_ON_ICON_RESOURCE = "/resource/icon/16/forcedUserOn.png";
    private static final String BUTTON_LABEL_ON;
    private static final String BUTTON_LABEL_OFF;
    private static final String BUTTON_LABEL_DISABLED;
    public static final String NAME = "ExtensionForcedUser";
    private static final Logger log;
    private Map<Integer, ContextForcedUserPanel> contextPanelsMap = new HashMap<Integer, ContextForcedUserPanel>();
    private Map<Integer, User> contextForcedUsersMap = new HashMap<Integer, User>();
    private ExtensionUserManagement extensionUserManagement;
    private boolean forcedUserModeEnabled = false;
    private ZapToggleButton forcedUserModeButton;
    private ForcedUserAPI api;

    public ExtensionForcedUser() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(202);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        Model.getSingleton().addContextDataFactory(this);
        if (this.getView() != null) {
            this.getView().addContextPanelFactory(this);
            View.getSingleton().addMainToolbarButton(this.getForcedUserModeToggleButton());
        }
        HttpSender.addListener(this);
        this.api = new ForcedUserAPI(this);
        API.getInstance().registerApiImplementor(this.api);
    }

    private void updateForcedUserModeToggleButtonEnabledState() {
        if (this.getView() != null) {
            this.forcedUserModeButton.setSelected(this.forcedUserModeEnabled);
        }
    }

    protected void setForcedUserModeEnabled(boolean bl) {
        this.forcedUserModeEnabled = bl;
        this.updateForcedUserModeToggleButtonEnabledState();
    }

    private void setForcedUserModeToggleButtonState(boolean bl) {
        if (bl) {
            this.updateForcedUserModeToggleButtonEnabledState();
            this.getForcedUserModeToggleButton().setEnabled(true);
        } else {
            this.forcedUserModeEnabled = false;
            this.getForcedUserModeToggleButton().setSelected(false);
            this.getForcedUserModeToggleButton().setEnabled(false);
        }
    }

    private void updateForcedUserModeToggleButtonState() {
        if (this.contextForcedUsersMap.isEmpty()) {
            if (this.getForcedUserModeToggleButton().isEnabled()) {
                this.setForcedUserModeToggleButtonState(false);
            }
        } else if (!this.getForcedUserModeToggleButton().isEnabled()) {
            this.setForcedUserModeToggleButtonState(true);
        }
    }

    private JToggleButton getForcedUserModeToggleButton() {
        if (this.forcedUserModeButton == null) {
            this.forcedUserModeButton = new ZapToggleButton();
            this.forcedUserModeButton.setIcon(new ImageIcon(ExtensionForcedUser.class.getResource(FORCED_USER_MODE_OFF_ICON_RESOURCE)));
            this.forcedUserModeButton.setSelectedIcon(new ImageIcon(ExtensionForcedUser.class.getResource(FORCED_USER_MODE_ON_ICON_RESOURCE)));
            this.forcedUserModeButton.setToolTipText(BUTTON_LABEL_OFF);
            this.forcedUserModeButton.setSelectedToolTipText(BUTTON_LABEL_ON);
            this.forcedUserModeButton.setDisabledToolTipText(BUTTON_LABEL_DISABLED);
            this.forcedUserModeButton.setEnabled(false);
            this.forcedUserModeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionForcedUser.this.setForcedUserModeEnabled(ExtensionForcedUser.this.getForcedUserModeToggleButton().isSelected());
                }
            });
        }
        return this.forcedUserModeButton;
    }

    protected ExtensionUserManagement getUserManagementExtension() {
        if (this.extensionUserManagement == null) {
            this.extensionUserManagement = (ExtensionUserManagement)Control.getSingleton().getExtensionLoader().getExtension("ExtensionUserManagement");
        }
        return this.extensionUserManagement;
    }

    public boolean isForcedUserModeEnabled() {
        return this.forcedUserModeEnabled;
    }

    public void setForcedUser(int n, User user) {
        if (user != null) {
            this.contextForcedUsersMap.put(n, user);
        } else {
            this.contextForcedUsersMap.remove(n);
        }
        this.updateForcedUserModeToggleButtonState();
    }

    public void setForcedUser(int n, int n2) throws IllegalStateException {
        User user = this.getUserManagementExtension().getContextUserAuthManager(n).getUserById(n2);
        if (user == null) {
            throw new IllegalStateException("No user matching the provided id was found.");
        }
        this.setForcedUser(n, user);
    }

    public User getForcedUser(int n) {
        return this.contextForcedUsersMap.get(n);
    }

    @Override
    public List<Class<?>> getDependencies() {
        return EXTENSION_DEPENDENCIES;
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextForcedUserPanel contextForcedUserPanel = this.contextPanelsMap.get(context.getIndex());
        if (contextForcedUserPanel == null) {
            contextForcedUserPanel = new ContextForcedUserPanel(this, context.getIndex());
            this.contextPanelsMap.put(context.getIndex(), contextForcedUserPanel);
        }
        return contextForcedUserPanel;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public int getOrder() {
        return 67;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public void discardContexts() {
        this.contextForcedUsersMap.clear();
        this.contextPanelsMap.clear();
        this.updateForcedUserModeToggleButtonState();
    }

    @Override
    public void discardContext(Context context) {
        this.contextForcedUsersMap.remove(context.getIndex());
        this.contextPanelsMap.remove(context.getIndex());
        this.updateForcedUserModeToggleButtonState();
    }

    @Override
    public int getListenerOrder() {
        return 9998;
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage, int n, HttpSender httpSender) {
        if (!this.forcedUserModeEnabled || httpMessage.getResponseBody() == null || httpMessage.getRequestHeader().isImage() || n == 5 || n == 7) {
            return;
        }
        if (httpMessage.getRequestingUser() != null) {
            return;
        }
        List<Context> list = Model.getSingleton().getSession().getContexts();
        Enableable enableable = null;
        for (Context context : list) {
            if (!context.isInContext(httpMessage.getRequestHeader().getURI().toString()) || !this.contextForcedUsersMap.containsKey(context.getIndex())) continue;
            enableable = this.contextForcedUsersMap.get(context.getIndex());
            break;
        }
        if (enableable == null || !enableable.isEnabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying request message (" + httpMessage.getRequestHeader().getURI() + ") to match user: " + enableable));
        }
        httpMessage.setRequestingUser((User)enableable);
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage, int n, HttpSender httpSender) {
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            List<String> list = session.getContextDataStrings(context.getIndex(), 310);
            if (list != null && list.size() > 0) {
                int n = Integer.parseInt(list.get(0));
                this.setForcedUser(context.getIndex(), n);
            }
        }
        catch (Exception exception) {
            log.error((Object)"Unable to load forced user.", (Throwable)exception);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            if (this.getForcedUser(context.getIndex()) != null) {
                session.setContextData(context.getIndex(), 310, Integer.toString(this.getForcedUser(context.getIndex()).getId()));
            } else {
                session.clearContextDataForType(context.getIndex(), 310);
            }
        }
        catch (Exception exception) {
            log.error((Object)"Unable to persist forced user.", (Throwable)exception);
        }
    }

    @Override
    public void exportContextData(Context context, Configuration configuration) {
        User user = this.getForcedUser(context.getIndex());
        if (user != null) {
            configuration.setProperty("context.forceduser", (Object)user.getId());
        } else {
            configuration.setProperty("context.forceduser", (Object)-1);
        }
    }

    @Override
    public void importContextData(Context context, Configuration configuration) {
        int n = configuration.getInt("context.forceduser");
        if (n >= 0) {
            this.setForcedUser(context.getIndex(), n);
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionUserManagement>> arrayList = new ArrayList<Class<ExtensionUserManagement>>(1);
        arrayList.add(ExtensionUserManagement.class);
        EXTENSION_DEPENDENCIES = Collections.unmodifiableList(arrayList);
        BUTTON_LABEL_ON = Constant.messages.getString("forceduser.toolbar.button.on");
        BUTTON_LABEL_OFF = Constant.messages.getString("forceduser.toolbar.button.off");
        BUTTON_LABEL_DISABLED = Constant.messages.getString("forceduser.toolbar.button.disabled");
        log = Logger.getLogger(ExtensionForcedUser.class);
    }
}

