/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class JavaAPIGenerator {
    private static final String TARGET_PACKAGE = "org/zaproxy/clientapi/gen";
    private static final String DEFAULT_OUTPUT_DIR = "../zap-api-java/subprojects/zap-clientapi/src/main/java/org/zaproxy/clientapi/gen";
    private File dir;
    private boolean optional = false;
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public JavaAPIGenerator() {
        this.dir = new File(DEFAULT_OUTPUT_DIR);
    }

    public JavaAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    public void generateJavaFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generateJavaComponent(apiImplementor);
        }
    }

    private void generateJavaElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        boolean bl;
        block35: {
            bl = false;
            String string3 = apiElement.getDescriptionTag();
            if (string3 == null) {
                string3 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                Iterator<String> iterator = this.msgs.getString(string3);
                writer.write("\t/**\n");
                writer.write("\t * " + (String)((Object)iterator) + "\n");
                if (this.optional) {
                    writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write("\t */\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string3);
                if (!this.optional) break block35;
                writer.write("\t/**\n");
                writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                writer.write("\t */\n");
            }
        }
        if (string2.equals("other")) {
            writer.write("\tpublic byte[] " + JavaAPIGenerator.createMethodName(apiElement.getName()) + "(");
        } else {
            writer.write("\tpublic ApiResponse " + JavaAPIGenerator.createMethodName(apiElement.getName()) + "(");
        }
        if (string2.equals("action") || string2.equals("other")) {
            bl = true;
            writer.write("String ");
            writer.write(API.API_KEY_PARAM);
        }
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string4 : apiElement.getMandatoryParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                if (string4.toLowerCase().equals("boolean")) {
                    writer.write("boolean bool");
                    continue;
                }
                if (string4.toLowerCase().equals("integer")) {
                    writer.write("int i");
                    continue;
                }
                writer.write("String ");
                writer.write(string4.toLowerCase());
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string4 : apiElement.getOptionalParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                if (string4.toLowerCase().equals("boolean")) {
                    writer.write("boolean bool");
                    continue;
                }
                if (string4.toLowerCase().equals("integer")) {
                    writer.write("int i");
                    continue;
                }
                writer.write("String ");
                writer.write(string4.toLowerCase());
            }
        }
        writer.write(") throws ClientApiException {\n");
        writer.write("\t\tMap<String, String> map = null;\n");
        if (bl) {
            writer.write("\t\tmap = new HashMap<String, String>();\n");
            if (string2.equals("action") || string2.equals("other")) {
                writer.write("\t\tif (apikey != null) {\n");
                writer.write("\t\t\tmap.put(\"apikey\", apikey);\n");
                writer.write("\t\t}\n");
            }
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string4 : apiElement.getMandatoryParamNames()) {
                    writer.write("\t\tmap.put(\"" + string4 + "\", ");
                    if (string4.toLowerCase().equals("boolean")) {
                        writer.write("Boolean.toString(bool)");
                    } else if (string4.toLowerCase().equals("integer")) {
                        writer.write("Integer.toString(i)");
                    } else {
                        writer.write(string4.toLowerCase());
                    }
                    writer.write(");\n");
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string4 : apiElement.getOptionalParamNames()) {
                    writer.write("\t\tif (");
                    writer.write(string4.toLowerCase());
                    writer.write(" != null) {\n");
                    writer.write("\t\t\tmap.put(\"" + string4 + "\", ");
                    if (string4.toLowerCase().equals("boolean")) {
                        writer.write("Boolean.toString(bool)");
                    } else if (string4.toLowerCase().equals("integer")) {
                        writer.write("Integer.toString(i)");
                    } else {
                        writer.write(string4.toLowerCase());
                    }
                    writer.write(");\n");
                    writer.write("\t\t}\n");
                }
            }
        }
        if (string2.equals("other")) {
            writer.write("\t\treturn api.callApiOther(\"" + string + "\", \"" + string2 + "\", \"" + apiElement.getName() + "\", map);\n");
        } else {
            writer.write("\t\treturn api.callApi(\"" + string + "\", \"" + string2 + "\", \"" + apiElement.getName() + "\", map);\n");
        }
        writer.write("\t}\n\n");
    }

    private static String createMethodName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return JavaAPIGenerator.removeAllFullStopCharacters(string);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private void generateJavaComponent(ApiImplementor apiImplementor) throws IOException {
        String string = apiImplementor.getPrefix().substring(0, 1).toUpperCase() + apiImplementor.getPrefix().substring(1);
        File file = new File(this.dir, string + ".java");
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
        fileWriter.write("package org.zaproxy.clientapi.gen;\n\n");
        fileWriter.write("import java.util.HashMap;\n");
        fileWriter.write("import java.util.Map;\n");
        fileWriter.write("import org.zaproxy.clientapi.core.ApiResponse;\n");
        fileWriter.write("import org.zaproxy.clientapi.core.ClientApi;\n");
        fileWriter.write("import org.zaproxy.clientapi.core.ClientApiException;\n");
        fileWriter.write("\n");
        fileWriter.write("\n");
        fileWriter.write("/**\n");
        fileWriter.write(" * This file was automatically generated.\n");
        fileWriter.write(" */\n");
        fileWriter.write("public class " + string + " {\n\n");
        fileWriter.write("\tprivate ClientApi api = null;\n\n");
        fileWriter.write("\tpublic " + string + "(ClientApi api) {\n");
        fileWriter.write("\t\tthis.api = api;\n");
        fileWriter.write("\t}\n\n");
        for (ApiElement apiElement : apiImplementor.getApiViews()) {
            this.generateJavaElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiActions()) {
            this.generateJavaElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiOthers()) {
            this.generateJavaElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter);
        }
        fileWriter.write("}\n");
        fileWriter.close();
    }

    public static void main(String[] stringArray) throws Exception {
        if (!Files.exists(Paths.get(DEFAULT_OUTPUT_DIR, new String[0]), new LinkOption[0])) {
            System.err.println("The directory does not exist: " + Paths.get(DEFAULT_OUTPUT_DIR, new String[0]).toAbsolutePath());
            System.exit(1);
        }
        JavaAPIGenerator javaAPIGenerator = new JavaAPIGenerator();
        javaAPIGenerator.generateJavaFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

