/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.settings;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ScheduledRequest
implements Runnable {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Settings Processor");
    private static final int DELAY = 2000;
    private Object inst;
    private RequestProcessor.Task task;
    private FileLock lock;
    private final FileObject fobj;
    private final FileSystem.AtomicAction run;
    private boolean running = false;
    private int counter = 0;

    public ScheduledRequest(FileObject fileObject, FileSystem.AtomicAction atomicAction) {
        this.fobj = fileObject;
        this.run = atomicAction;
    }

    public boolean isRunning() {
        return this.running;
    }

    public FileLock getFileLock() {
        return this.lock;
    }

    public synchronized void schedule(Object object) {
        this.schedule(object, 2000);
    }

    private void schedule(Object object, int n) {
        if (object == null) {
            return;
        }
        if (this.inst != null && this.inst != object) {
            throw new IllegalStateException("Inconsistant state! File: " + this.fobj);
        }
        try {
            if (this.lock == null) {
                this.lock = this.fobj.lock();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(ScheduledRequest.class.getName()).log(Level.WARNING, null, iOException);
            return;
        }
        ++this.counter;
        if (this.task == null) {
            this.task = PROCESSOR.post((Runnable)this, n);
        } else {
            this.task.schedule(n);
        }
        this.inst = object;
    }

    public synchronized void runAndWait() throws IOException {
        if (this.task != null) {
            this.task.cancel();
            this.counter = 0;
            this.releaseResources();
        }
        this.lock = this.fobj.lock();
        this.performRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceToFinish() {
        RequestProcessor.Task task = null;
        ScheduledRequest scheduledRequest = this;
        synchronized (scheduledRequest) {
            if (this.task != null) {
                task = this.task;
                this.task.schedule(0);
            }
        }
        if (task != null) {
            task.waitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        RequestProcessor.Task task = this.task;
        if (task == null) {
            return;
        }
        if (this.isRunning()) {
            task.waitFinished();
        } else {
            ScheduledRequest scheduledRequest = this;
            synchronized (scheduledRequest) {
                task.cancel();
                this.counter = 0;
                this.releaseResources();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ScheduledRequest scheduledRequest = this;
        synchronized (scheduledRequest) {
            this.counter = 0;
        }
        try {
            this.performRequest();
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)this.fobj.toString());
            Logger.getLogger(ScheduledRequest.class.getName()).log(Level.WARNING, null, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest() throws IOException {
        RequestProcessor.Task task;
        boolean bl = false;
        ScheduledRequest scheduledRequest = this;
        synchronized (scheduledRequest) {
            bl = this.running;
            task = this.task;
            this.running = true;
        }
        if (bl) {
            task.waitFinished();
            return;
        }
        try {
            this.run.run();
        }
        finally {
            scheduledRequest = this;
            synchronized (scheduledRequest) {
                this.running = false;
                if (this.task == null || this.counter == 0) {
                    this.releaseResources();
                }
            }
        }
    }

    private void releaseResources() {
        if (this.lock != null) {
            this.lock.releaseLock();
            this.lock = null;
        }
        this.inst = null;
        this.task = null;
    }
}

