/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Pattern;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.ContentParser;
import org.icepdf.core.util.Library;

public class TilingPattern
extends Stream
implements Pattern {
    private static final Logger logger = Logger.getLogger(TilingPattern.class.toString());
    private int patternType;
    private int paintType;
    private Color unColored;
    public static final int PAINTING_TYPE_COLORED_TILING_PATTERN = 1;
    public static final int PAINTING_TYPE_UNCOLORED_TILING_PATTERN = 2;
    private int tilingType;
    private String type = this.library.getName(this.entries, "Type");
    public static final int TILING_TYPE_CONSTANT_SPACING = 1;
    public static final int TILING_TYPE_NO_DISTORTION = 2;
    public static final int TILING_TYPE_CONSTANT_SPACING_FASTER = 3;
    private Rectangle2D bBox;
    private float xStep;
    private float yStep;
    private Resources resources;
    private AffineTransform matrix;
    private Shapes shapes;
    public Color fillColour = null;
    private boolean inited;
    private TexturePaint texturePaint;
    private GraphicsState parentGraphicState;

    public TilingPattern(Library library, Hashtable hashtable, SeekableInputConstrainedWrapper seekableInputConstrainedWrapper) {
        super(library, hashtable, seekableInputConstrainedWrapper);
        this.patternType = this.library.getInt(this.entries, "PatternType");
        this.paintType = this.library.getInt(this.entries, "PaintType");
        this.tilingType = this.library.getInt(this.entries, "TilingType");
        this.bBox = this.library.getRectangle(this.entries, "BBox");
        this.xStep = this.library.getFloat(this.entries, "XStep");
        this.yStep = this.library.getFloat(this.entries, "YStep");
        this.resources = this.library.getResources(this.entries, "Resources");
        Vector vector = (Vector)this.library.getObject(this.entries, "Matrix");
        this.matrix = vector != null ? TilingPattern.getAffineTransform(vector) : new AffineTransform();
    }

    public String getType() {
        return this.type;
    }

    private static AffineTransform getAffineTransform(Vector vector) {
        float[] fArray = new float[6];
        for (int i = 0; i < 6; ++i) {
            fArray[i] = ((Number)vector.elementAt(i)).floatValue();
        }
        return new AffineTransform(fArray);
    }

    public Color getFirstColor() {
        if (this.shapes != null && this.unColored == null) {
            int n = this.shapes.shapes.size();
            for (int i = 0; i < n; ++i) {
                if (!(this.shapes.shapes.get(i) instanceof Color)) continue;
                this.unColored = (Color)this.shapes.shapes.get(i);
                return this.unColored;
            }
        }
        if (this.unColored == null) {
            this.unColored = Color.black;
            return this.unColored;
        }
        return this.unColored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.inited) {
            return;
        }
        Resources resources = this.library.getResources(this.entries, "Resources");
        if (resources != null) {
            this.resources = resources;
        }
        ContentParser contentParser = new ContentParser(this.library, resources);
        contentParser.setGraphicsState(this.parentGraphicState);
        InputStream inputStream = this.getInputStreamForDecodedStreamBytes();
        if (inputStream != null) {
            try {
                this.shapes = contentParser.parse(inputStream);
            }
            catch (Throwable throwable) {
                logger.log(Level.FINE, "Error processing tiling pattern.", throwable);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Paint getPaint() {
        return this.texturePaint;
    }

    public int getPatternType() {
        return this.patternType;
    }

    public void setPatternType(int n) {
        this.patternType = n;
    }

    public int getPaintType() {
        return this.paintType;
    }

    public void setPaintType(int n) {
        this.paintType = n;
    }

    public int getTilingType() {
        return this.tilingType;
    }

    public void setTilingType(int n) {
        this.tilingType = n;
    }

    public Rectangle2D getBBox() {
        return this.bBox;
    }

    public float getXStep() {
        return this.xStep;
    }

    public float getYStep() {
        return this.yStep;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public AffineTransform getInvMatrix() {
        try {
            return this.matrix.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }

    public void setMatrix(AffineTransform affineTransform) {
        this.matrix = affineTransform;
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public void setShapes(Shapes shapes) {
        this.shapes = shapes;
    }

    public void setParentGraphicState(GraphicsState graphicsState) {
        this.parentGraphicState = graphicsState;
    }

    public GraphicsState getParentGraphicState() {
        return this.parentGraphicState;
    }

    public Color getUnColored() {
        return this.unColored;
    }

    public void setUnColored(Color color) {
        this.unColored = color;
    }

    public String toString() {
        return "Tiling Pattern: \n           type: pattern \n    patternType: tilling\n      paintType: " + (this.paintType == 1 ? "colored" : "uncoloured") + "\n    tilingType: " + this.tilingType + "\n          bbox: " + this.bBox + "\n         xStep: " + this.xStep + "\n         yStep: " + this.yStep + "\n      resource: " + this.resources + "\n        matrix: " + this.matrix;
    }
}

