/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.Hibernate;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.type.Type;

public class BinaryArithmeticOperatorNode
extends AbstractSelectExpression
implements BinaryOperatorNode,
DisplayableNode {
    public void initialize() throws SemanticException {
        Node lhs = this.getLeftHandOperand();
        Node rhs = this.getRightHandOperand();
        if (lhs == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        if (rhs == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        Type lhType = lhs instanceof SqlNode ? ((SqlNode)lhs).getDataType() : null;
        Type rhType = rhs instanceof SqlNode ? ((SqlNode)rhs).getDataType() : null;
        if (ExpectedTypeAwareNode.class.isAssignableFrom(((Object)((Object)lhs)).getClass()) && rhType != null) {
            Type expectedType = null;
            expectedType = this.isDateTimeType(rhType) ? (this.getType() == 115 ? Hibernate.DOUBLE : rhType) : rhType;
            ((ExpectedTypeAwareNode)((Object)lhs)).setExpectedType(expectedType);
        } else if (ParameterNode.class.isAssignableFrom(((Object)((Object)rhs)).getClass()) && lhType != null) {
            Type expectedType = null;
            if (this.isDateTimeType(lhType)) {
                if (this.getType() == 115) {
                    expectedType = Hibernate.DOUBLE;
                }
            } else {
                expectedType = lhType;
            }
            ((ExpectedTypeAwareNode)((Object)rhs)).setExpectedType(expectedType);
        }
    }

    public Type getDataType() {
        if (super.getDataType() == null) {
            super.setDataType(this.resolveDataType());
        }
        return super.getDataType();
    }

    private Type resolveDataType() {
        Type rhType;
        Node lhs = this.getLeftHandOperand();
        Node rhs = this.getRightHandOperand();
        Type lhType = lhs instanceof SqlNode ? ((SqlNode)lhs).getDataType() : null;
        Type type = rhType = rhs instanceof SqlNode ? ((SqlNode)rhs).getDataType() : null;
        if (this.isDateTimeType(lhType) || this.isDateTimeType(rhType)) {
            return this.resolveDateTimeArithmeticResultType(lhType, rhType);
        }
        if (lhType == null) {
            if (rhType == null) {
                return Hibernate.DOUBLE;
            }
            return rhType;
        }
        if (rhType == null) {
            return lhType;
        }
        if (lhType == Hibernate.DOUBLE || rhType == Hibernate.DOUBLE) {
            return Hibernate.DOUBLE;
        }
        if (lhType == Hibernate.FLOAT || rhType == Hibernate.FLOAT) {
            return Hibernate.FLOAT;
        }
        if (lhType == Hibernate.BIG_DECIMAL || rhType == Hibernate.BIG_DECIMAL) {
            return Hibernate.BIG_DECIMAL;
        }
        if (lhType == Hibernate.BIG_INTEGER || rhType == Hibernate.BIG_INTEGER) {
            return Hibernate.BIG_INTEGER;
        }
        if (lhType == Hibernate.LONG || rhType == Hibernate.LONG) {
            return Hibernate.LONG;
        }
        if (lhType == Hibernate.INTEGER || rhType == Hibernate.INTEGER) {
            return Hibernate.INTEGER;
        }
        return lhType;
    }

    private boolean isDateTimeType(Type type) {
        if (type == null) {
            return false;
        }
        return Date.class.isAssignableFrom(type.getReturnedClass()) || Calendar.class.isAssignableFrom(type.getReturnedClass());
    }

    private Type resolveDateTimeArithmeticResultType(Type lhType, Type rhType) {
        boolean lhsIsDateTime = this.isDateTimeType(lhType);
        boolean rhsIsDateTime = this.isDateTimeType(rhType);
        if (this.getType() == 115) {
            return lhsIsDateTime ? lhType : rhType;
        }
        if (this.getType() == 116) {
            if (lhsIsDateTime && !rhsIsDateTime) {
                return lhType;
            }
            if (lhsIsDateTime && rhsIsDateTime) {
                return Hibernate.DOUBLE;
            }
        }
        return null;
    }

    public void setScalarColumnText(int i) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, i);
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }

    public String getDisplayText() {
        return "{dataType=" + this.getDataType() + "}";
    }
}

