/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Serializable;
import java.sql.Connection;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLLSInput;
import oracle.xml.parser.v2.XMLLSOutput;
import oracle.xml.parser.v2.XMLLSParser;
import oracle.xml.parser.v2.XMLLSSerializer;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class XMLDOMImplementation
implements DOMImplementation,
Serializable,
DOMImplementationLS {
    Connection conn = null;
    String kind;
    int flags;
    private static String XML_DTD = "http://www.w3.org/TR/REC-xml";
    private static String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public XMLDOMImplementation() {
        this.flags |= 1;
    }

    public boolean hasFeature(String string, String string2) {
        switch (this.flags & 3) {
            case 1: {
                if (string == "oracle.xml.AutoEvents") {
                    return (this.flags & 0x10000) == 65536;
                }
                if (!(string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("core") || string.equalsIgnoreCase("traversal") || string.equalsIgnoreCase("range") || string.equalsIgnoreCase("events") || string.equalsIgnoreCase("mutationevents") || string.equalsIgnoreCase("ls") || string.equalsIgnoreCase("ls-async"))) {
                    return false;
                }
                if (string2 == null || string2.equals("")) {
                    return true;
                }
                if (string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("core")) {
                    return string2.equals("1.0") || string2.equals("2.0") || string2.equals("3.0");
                }
                if (string.equalsIgnoreCase("ls") || string.equalsIgnoreCase("ls-async")) {
                    return string2.equals("3.0");
                }
                if (string.equalsIgnoreCase("traversal") || string.equalsIgnoreCase("range") || string.equalsIgnoreCase("events") || string.equalsIgnoreCase("mutationevents")) {
                    return string2.equals("2.0");
                }
                return false;
            }
            case 2: {
                if (!string.equalsIgnoreCase("xml") && !string.equalsIgnoreCase("core")) {
                    return false;
                }
                if (string2 == null || string2.equals("")) {
                    return true;
                }
                if (!string.equalsIgnoreCase("xml") && !string.equalsIgnoreCase("core")) break;
                return string2.equals("1.0") || string2.equals("2.0");
            }
        }
        return false;
    }

    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                XMLUtil.validateQualifiedName(string);
                DTD dTD = new DTD(string);
                dTD.xdkSetSystemId(string3);
                dTD.xdkSetPublicId(string2);
                dTD.setNodeFlag(131072);
                return dTD;
            }
            case 2: {
                throw new XMLDOMException(9, 21997, new XMLDocument().getXMLError());
            }
        }
        return null;
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        XMLDocument xMLDocument;
        if (this.conn == null) {
            xMLDocument = new XMLDocument();
            if (documentType != null) {
                DTD dTD = (DTD)documentType;
                if (!dTD.isNodeFlag(131072)) {
                    throw new XMLDOMException(4, 21006, xMLDocument.getXMLError());
                }
                dTD.setDocument(xMLDocument);
                xMLDocument.appendChild(dTD);
            }
        } else {
            xMLDocument = new XMLDocument(this.conn, 0L);
        }
        if (string2 != null) {
            if (string == null) {
                string = "";
            }
            XMLUtil.validateQualifiedName(string, string2);
            xMLDocument.appendChild(xMLDocument.createElementNS(string, string2));
        }
        return xMLDocument;
    }

    public void setFeature(String string) throws DOMException {
        String string2 = string.intern();
        if (string2 == "oracle.xml.AutoEvents") {
            this.flags |= 0x10000;
        }
    }

    public Object getFeature(String string, String string2) {
        if (!(string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("core") || string.equalsIgnoreCase("traversal") || string.equalsIgnoreCase("range") || string.equalsIgnoreCase("events") || string.equalsIgnoreCase("ls") || string.equalsIgnoreCase("ls-async"))) {
            return null;
        }
        if (string2 == null || string2.equals("")) {
            return this;
        }
        if (string.equalsIgnoreCase("xml") && string2.equals("1.0") || string.equalsIgnoreCase("ls") && string2.equals("3.0") || string.equalsIgnoreCase("ls-async") && string2.equals("3.0") || string.equalsIgnoreCase("traversal") && string2.equals("2.0") || string.equalsIgnoreCase("range") && string2.equals("2.0") || string.equalsIgnoreCase("events") && string2.equals("2.0") || string.equalsIgnoreCase("core") && (string2.equals("1.0") || string2.equals("2.0") || string2.equals("3.0"))) {
            return this;
        }
        return null;
    }

    public LSParser createLSParser(short s, String string) throws DOMException {
        switch (this.flags & 3) {
            case 1: {
                if (s != 2 && s != 1) {
                    throw new XMLDOMException(9, 21014, XMLDocument.defErr, "mode", Short.toString(s));
                }
                if (string != null && !string.equals(XML_DTD) && !string.equals(XML_SCHEMA)) {
                    throw new XMLDOMException(9, 21014, XMLDocument.defErr, "schema type", string);
                }
                return new XMLLSParser(s, string);
            }
            case 2: {
                throw new XMLDOMException(9, 21997, new XMLDocument().getXMLError());
            }
        }
        return null;
    }

    public LSSerializer createLSSerializer() {
        switch (this.flags & 3) {
            case 1: {
                return new XMLLSSerializer();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, new XMLDocument().getXMLError());
            }
        }
        return null;
    }

    public LSInput createLSInput() {
        switch (this.flags & 3) {
            case 1: {
                return new XMLLSInput();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, new XMLDocument().getXMLError());
            }
        }
        return null;
    }

    public LSOutput createLSOutput() {
        switch (this.flags & 3) {
            case 1: {
                return new XMLLSOutput();
            }
            case 2: {
                throw new XMLDOMException(9, 21997, new XMLDocument().getXMLError());
            }
        }
        return null;
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if ((string = string.intern()) == "oracle.xml.parser.XMLDocument.Connection" && object instanceof Connection) {
            this.conn = (Connection)object;
        } else if (string == "oracle.xml.parser.XMLDocument.Kind" && object instanceof String) {
            if (!object.equals("oracle.xml.parser.XMLDocument.THICK") && !object.equals("oracle.xml.parser.XMLDocument.THIN")) {
                throw new IllegalArgumentException();
            }
            this.kind = (String)object;
            if (object.equals("oracle.xml.parser.XMLDocument.THICK")) {
                this.flags &= 0xFFFFFFFE;
                this.flags |= 2;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }
}

