/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class REF {
    public static char[] INVALID_FILESYSTEM_CHARS = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', '=', '+', '.', ' ', '`', '~', '\'', '\"', ',', ';'};
    public static boolean IN_TESTS = false;
    public static boolean LOG_ENCODING_ERROR = true;
    public static Boolean isWinCache;

    public static boolean hasAttr(Object o, String attr) {
        try {
            o.getClass().getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        return true;
    }

    public static Field getAttrFromClass(Class<? extends Object> c, String attr) {
        try {
            return c.getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    public static Field getAttr(Object o, String attr) {
        try {
            return o.getClass().getDeclaredField(attr);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        return null;
    }

    public static Object getAttrObj(Object o, String attr) {
        return REF.getAttrObj(o, attr, false);
    }

    public static Object getAttrObj(Object o, String attr, boolean raiseExceptionIfNotAvailable) {
        block4: {
            try {
                Field field = REF.getAttr(o, attr);
                if (field != null) {
                    if ((field.getModifiers() & 1) == 0) {
                        field.setAccessible(true);
                    }
                    Object obj = field.get(o);
                    return obj;
                }
            }
            catch (Exception e) {
                if (!raiseExceptionIfNotAvailable) break block4;
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String getFileContents(File file) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            String string = (String)REF.getStreamContents(stream, null, null, ClassLiteral.getClass((String)"java/lang/String"));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    private static Object getStreamContents(InputStream contentStream, String encoding, IProgressMonitor monitor, Class<? extends Object> returnType) throws IOException {
        Reader in = null;
        try {
            if (encoding == null) {
                in = new BufferedReader(new InputStreamReader(contentStream), 15360);
            } else {
                try {
                    in = new BufferedReader(new InputStreamReader(contentStream, encoding), 15360);
                }
                catch (UnsupportedEncodingException e) {
                    Log.log(e);
                    in = new BufferedReader(new InputStreamReader(contentStream), 15360);
                }
            }
            FastStringBuffer buffer = new FastStringBuffer(15360);
            char[] readBuffer = new char[2048];
            int n = in.read(readBuffer);
            while (n > 0) {
                if (monitor != null && monitor.isCanceled()) {
                    return null;
                }
                buffer.append(readBuffer, 0, n);
                n = in.read(readBuffer);
            }
            if (returnType == null || returnType == ClassLiteral.getClass((String)"org/python/pydev/core/structure/FastStringBuffer")) {
                FastStringBuffer fastStringBuffer = buffer;
                return fastStringBuffer;
            }
            if (returnType == ClassLiteral.getClass((String)"org/eclipse/jface/text/IDocument")) {
                Document doc;
                Document document = doc = new Document(buffer.toString());
                return document;
            }
            if (returnType == ClassLiteral.getClass((String)"java/lang/String")) {
                String string = buffer.toString();
                return string;
            }
            throw new RuntimeException(new StringBuffer("Don't know how to handle return type: ").append(returnType).toString());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    public static String getObjAsStr(Object o) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(o);
            stream.close();
        }
        catch (Exception e) {
            Log.log(e);
            throw new RuntimeException(e);
        }
        return new String(REF.encodeBase64(out));
    }

    public static byte[] encodeBase64(ByteArrayOutputStream out) {
        byte[] byteArray = out.toByteArray();
        return REF.encodeBase64(byteArray);
    }

    public static byte[] encodeBase64(byte[] byteArray) {
        return Base64.encodeBase64((byte[])byteArray);
    }

    public static Object getStrAsObj(String persisted, ICallback<Object, ObjectInputStream> readFromFileMethod) throws IOException, ClassNotFoundException {
        ByteArrayInputStream input = new ByteArrayInputStream(REF.decodeBase64(persisted));
        Object o = REF.readFromInputStreamAndCloseIt(readFromFileMethod, input);
        return o;
    }

    public static Object readFromInputStreamAndCloseIt(ICallback<Object, ObjectInputStream> readFromFileMethod, InputStream input) {
        ObjectInputStream in = null;
        Object o = null;
        try {
            try {
                in = new ObjectInputStream(input);
                o = readFromFileMethod.call(in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                input.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return o;
    }

    public static byte[] decodeBase64(String persisted) {
        return Base64.decodeBase64((byte[])persisted.getBytes());
    }

    public static void appendStrToFile(String str, String file) {
        try {
            FileOutputStream stream = new FileOutputStream(file, true);
            try {
                stream.write(str.getBytes());
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeStrToFile(String str, String file) {
        REF.writeStrToFile(str, new File(file));
    }

    public static void writeStrToFile(String str, File file) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                stream.write(str.getBytes());
            }
            finally {
                stream.close();
            }
        }
        catch (FileNotFoundException e) {
            Log.log(e);
        }
        catch (IOException e) {
            Log.log(e);
        }
    }

    public static void writeToFile(Object o, File file) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            REF.writeToStreamAndCloseIt(o, out);
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    public static void writeToStreamAndCloseIt(Object o, OutputStream out) throws IOException {
        OutputStream b = null;
        b = out instanceof BufferedOutputStream || out instanceof ByteArrayOutputStream ? out : new BufferedOutputStream(out);
        try {
            try {
                ObjectOutputStream stream = new ObjectOutputStream(b);
                stream.writeObject(o);
                stream.close();
            }
            catch (Exception e) {
                Log.log(e);
                throw new RuntimeException(e);
            }
        }
        finally {
            b.close();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object readFromFile(File file) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                Object object;
                ObjectInputStream stream = new ObjectInputStream(in);
                try {
                    Object o;
                    object = o = stream.readObject();
                }
                catch (Throwable throwable) {
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return object;
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            Log.log(e);
            return null;
        }
    }

    public static String getFileAbsolutePath(String f) {
        return REF.getFileAbsolutePath(new File(f));
    }

    public static String getFileAbsolutePath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException iOException) {
            return f.getAbsolutePath();
        }
    }

    public static Object invoke(Object obj, String name, Object ... args) {
        Method m = REF.findMethod(obj, name, args);
        return REF.invoke(obj, m, args);
    }

    public static Object invoke(Object obj, Method m, Object ... args) {
        try {
            return m.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findMethod(Object obj, String name, Object ... args) {
        return REF.findMethod(obj.getClass(), name, args);
    }

    public static Method findMethod(Class<? extends Object> class_, String name, Object ... args) {
        try {
            Method[] methods;
            Method[] methodArray = methods = class_.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (method.getName().equals(name) && parameterTypes.length == args.length) {
                    int i = 0;
                    Class<?>[] classArray = parameterTypes;
                    int n3 = parameterTypes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> param = classArray[n4];
                        if (param.isInstance(args[i])) {
                            ++i;
                        }
                        ++n4;
                    }
                    return method;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException(new StringBuffer("The method with name: ").append(name).append(" was not found (or maybe it was found but the parameters didn't match).").toString());
    }

    public static String getValidProjectName(IProject project) {
        String name = project.getName();
        char[] cArray = INVALID_FILESYSTEM_CHARS;
        int n = INVALID_FILESYSTEM_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            name = name.replace(c, '_');
            ++n2;
        }
        return name;
    }

    public static boolean nullEq(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static IDocument getDocFromFile(File f) throws IOException {
        return REF.getDocFromFile(f, true);
    }

    public static String getStringFromZip(File f, String pathInZip) throws Exception {
        return (String)REF.getCustomReturnFromZip(f, pathInZip, ClassLiteral.getClass((String)"java/lang/String"));
    }

    public static IDocument getDocFromZip(File f, String pathInZip) throws Exception {
        return (IDocument)REF.getCustomReturnFromZip(f, pathInZip, ClassLiteral.getClass((String)"org/eclipse/jface/text/IDocument"));
    }

    public static Object getCustomReturnFromZip(File f, String pathInZip, Class<? extends Object> returnType) throws Exception {
        ZipFile zipFile = new ZipFile(f, 1);
        try {
            Object object;
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(pathInZip));
            try {
                object = REF.getStreamContents(inputStream, null, null, returnType);
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return object;
        }
        finally {
            zipFile.close();
        }
    }

    public static String getStringFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (String)REF.getCustomReturnFromFile(f, loadIfNotInWorkspace, ClassLiteral.getClass((String)"java/lang/String"));
    }

    public static IDocument getDocFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (IDocument)REF.getCustomReturnFromFile(f, loadIfNotInWorkspace, ClassLiteral.getClass((String)"org/eclipse/jface/text/IDocument"));
    }

    public static Object getCustomReturnFromFile(File f, boolean loadIfNotInWorkspace, Class<? extends Object> returnType) throws IOException {
        IPath path = Path.fromOSString((String)REF.getFileAbsolutePath(f));
        IDocument doc = REF.getDocFromPath(path);
        if (doc != null) {
            if (returnType == null || returnType == ClassLiteral.getClass((String)"org/eclipse/jface/text/IDocument")) {
                return doc;
            }
            if (returnType == ClassLiteral.getClass((String)"java/lang/String")) {
                return doc.get();
            }
            if (returnType == ClassLiteral.getClass((String)"org/python/pydev/core/structure/FastStringBuffer")) {
                return new FastStringBuffer(doc.get(), 16);
            }
            throw new RuntimeException(new StringBuffer("Don't know how to treat requested return type: ").append(returnType).toString());
        }
        if (doc == null && loadIfNotInWorkspace) {
            FileInputStream stream = new FileInputStream(f);
            try {
                String encoding = REF.getPythonFileEncoding(f);
                Object object = REF.getStreamContents(stream, encoding, null, returnType);
                return object;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
        return doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITextFileBuffer getBufferFromPath(IPath path) {
        try {
            ITextFileBuffer textFileBuffer;
            ITextFileBufferManager textFileBufferManager = ITextFileBufferManager.DEFAULT;
            if (textFileBufferManager == null || (textFileBuffer = textFileBufferManager.getTextFileBuffer(path, LocationKind.LOCATION)) == null) return null;
            return textFileBuffer;
        }
        catch (Throwable e) {
            try {
                ITextFileBuffer textFileBuffer;
                if (!(e instanceof ClassNotFoundException) && !(e instanceof LinkageError) && !(e instanceof NoSuchMethodException) && !(e instanceof NoSuchMethodError) && !(e instanceof NoClassDefFoundError)) throw e;
                ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
                if (textFileBufferManager == null || (textFileBuffer = textFileBufferManager.getTextFileBuffer(path)) == null) return null;
                return textFileBuffer;
            }
            catch (Throwable throwable) {
                if (IN_TESTS) return null;
                Log.log("Unable to get doc from text file buffer");
                return null;
            }
        }
    }

    public static IDocument getDocFromPath(IPath path) {
        ITextFileBuffer buffer = REF.getBufferFromPath(path);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return null;
    }

    public static IDocument getDocFromResource(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && resource instanceof IFile && resource.exists()) {
            IFile file = (IFile)resource;
            try {
                IPath path;
                IDocument doc;
                if (file.exists() && !file.isSynchronized(0)) {
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((doc = REF.getDocFromPath(path = file.getFullPath())) == null) {
                    doc = (IDocument)REF.getStreamContents(file.getContents(), null, null, ClassLiteral.getClass((String)"org/eclipse/jface/text/IDocument"));
                }
                return doc;
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        return null;
    }

    public static String getPythonFileEncoding(IDocument doc, String fileLocation) throws IllegalCharsetNameException {
        StringReader inputStreamReader = new StringReader(doc.get());
        return REF.getPythonFileEncoding(inputStreamReader, fileLocation);
    }

    public static String getPythonFileEncoding(File f) throws IllegalCharsetNameException {
        String string;
        FileInputStream fileInputStream = new FileInputStream(f);
        try {
            String pythonFileEncoding;
            InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(fileInputStream));
            string = pythonFileEncoding = REF.getPythonFileEncoding(inputStreamReader, f.getAbsolutePath());
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {
                    Log.log(e);
                }
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        try {
            fileInputStream.close();
        }
        catch (Exception e) {
            Log.log(e);
        }
        return string;
    }

    public static String getPythonFileEncoding(Reader inputStreamReader, String fileLocation) throws IllegalCharsetNameException {
        String ret;
        block21: {
            ret = null;
            BufferedReader reader = new BufferedReader(inputStreamReader);
            try {
                try {
                    String l1 = reader.readLine();
                    String l2 = reader.readLine();
                    String lEnc = null;
                    if (l1 != null && l1.indexOf("coding") != -1) {
                        lEnc = l1;
                    } else if (l2 != null && l2.indexOf("coding") != -1) {
                        lEnc = l2;
                    } else {
                        ret = null;
                    }
                    if (lEnc != null) {
                        Pattern p;
                        Matcher matcher;
                        if ((lEnc = lEnc.trim()).length() == 0) {
                            ret = null;
                        } else if (lEnc.charAt(0) == '#' && (matcher = (p = Pattern.compile("coding[:=]+[\\s]*[\\w[\\-]]+[\\s]*")).matcher(lEnc)).find()) {
                            char c;
                            lEnc = lEnc.substring(matcher.start() + 6);
                            while (lEnc.length() > 0 && ((c = lEnc.charAt(0)) == ' ' || c == ':' || c == '=')) {
                                lEnc = lEnc.substring(1);
                            }
                            FastStringBuffer buffer = new FastStringBuffer();
                            while (lEnc.length() > 0 && ((c = lEnc.charAt(0)) != ' ' || c == '-' || c == '*')) {
                                buffer.append(c);
                                lEnc = lEnc.substring(1);
                            }
                            ret = buffer.toString().trim();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    break block21;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        ret = REF.getValidEncoding(ret, fileLocation);
        return ret;
    }

    static String getValidEncoding(String ret, String fileLocation) {
        block9: {
            if (ret == null) {
                return ret;
            }
            String lower = ret.trim().toLowerCase();
            if (lower.startsWith("latin") && lower.indexOf("1") != -1) {
                return "latin1";
            }
            if (lower.startsWith("utf") && lower.endsWith("8")) {
                return "UTF-8";
            }
            if (lower.equals("iso-latin-1-unix")) {
                return "latin1";
            }
            try {
                if (Charset.isSupported(ret)) break block9;
                if (LOG_ENCODING_ERROR) {
                    String msg = new StringBuffer("The encoding found: >>").append(ret).append("<< on ").append(fileLocation).append(" is not a valid encoding.").toString();
                    Log.log(4, msg, new UnsupportedEncodingException(msg));
                }
                return null;
            }
            catch (IllegalCharsetNameException ex) {
                if (LOG_ENCODING_ERROR) {
                    String msg = new StringBuffer("The encoding found: >>").append(ret).append("<< on ").append(fileLocation).append(" is not a valid encoding.").toString();
                    Log.log(4, msg, ex);
                }
                return null;
            }
        }
        return ret;
    }

    public static boolean isWindowsPlatform() {
        if (isWinCache == null) {
            try {
                isWinCache = Autobox.valueOf((boolean)Platform.getOS().equals("win32"));
            }
            catch (NullPointerException nullPointerException) {
                String env = System.getProperty("os.name");
                isWinCache = env.toLowerCase().indexOf("win") != -1 ? Autobox.valueOf((boolean)true) : Autobox.valueOf((boolean)false);
            }
        }
        return isWinCache;
    }

    public static void copyFile(String srcFilename, String dstFilename) {
        try {
            FileChannel srcChannel = new FileInputStream(srcFilename).getChannel();
            FileChannel dstChannel = new FileOutputStream(dstFilename).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyDirectory(File srcPath, File dstPath, ICallback<Boolean, File> filter, ICallback<String, String> changeFileContents) throws IOException {
        if (srcPath.isDirectory()) {
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            int i = 0;
            while (i < files.length) {
                REF.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]), filter, changeFileContents);
                ++i;
            }
        } else if (srcPath.exists()) {
            if (filter != null && filter.call(srcPath).booleanValue()) {
                return;
            }
            if (changeFileContents == null) {
                REF.copyFile(srcPath.getAbsolutePath(), dstPath.getAbsolutePath());
            } else {
                String fileContents = REF.getFileContents(srcPath);
                fileContents = changeFileContents.call(fileContents);
                REF.writeStrToFile(fileContents, dstPath);
            }
        }
    }
}

