/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathEvent;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbPathListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BreadcrumbBarModel<T> {
    private LinkedList<BreadcrumbItem<T>> items = new LinkedList();
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean isCumulative = false;
    protected int smallestCumulativeIndex = -1;

    public int indexOf(BreadcrumbItem<T> breadcrumbItem) {
        return this.items.indexOf(breadcrumbItem);
    }

    public void removeLast() {
        this.items.removeLast();
        this.firePathChanged(this.items.size());
    }

    public void reset() {
        this.items.clear();
        this.firePathChanged(0);
    }

    public List<BreadcrumbItem<T>> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public BreadcrumbItem<T> getItem(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.getItemCount()) {
            return null;
        }
        return this.items.get(n);
    }

    public void replace(List<BreadcrumbItem<T>> list) {
        this.items.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.items.addLast(list.get(i));
        }
        this.firePathChanged(0);
    }

    public void addLast(BreadcrumbItem<T> breadcrumbItem) {
        this.items.addLast(breadcrumbItem);
        this.firePathChanged(this.items.size() - 1);
    }

    public void setCumulative(boolean bl) {
        boolean bl2 = this.isCumulative && !bl;
        this.isCumulative = bl;
        if (bl2) {
            this.firePathChanged(Math.max(0, this.smallestCumulativeIndex));
            this.smallestCumulativeIndex = -1;
        }
    }

    public void addPathListener(BreadcrumbPathListener breadcrumbPathListener) {
        this.listenerList.add(BreadcrumbPathListener.class, breadcrumbPathListener);
    }

    public void removePathListener(BreadcrumbPathListener breadcrumbPathListener) {
        this.listenerList.remove(BreadcrumbPathListener.class, breadcrumbPathListener);
    }

    protected void firePathChanged(int n) {
        if (this.isCumulative) {
            this.smallestCumulativeIndex = this.smallestCumulativeIndex == -1 ? n : Math.min(this.smallestCumulativeIndex, n);
            return;
        }
        BreadcrumbPathEvent breadcrumbPathEvent = new BreadcrumbPathEvent(this, n);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != BreadcrumbPathListener.class) continue;
            ((BreadcrumbPathListener)objectArray[i + 1]).breadcrumbPathEvent(breadcrumbPathEvent);
        }
    }
}

