/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.TreeMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.VarMeta;

final class Var2Data
extends MPPComponent {
    private TreeMap<Integer, byte[]> m_map = new TreeMap();
    private VarMeta m_meta;

    Var2Data(VarMeta varMeta, InputStream inputStream) throws IOException {
        this.m_meta = varMeta;
        int n = this.m_meta.getItemCount();
        for (int i = 0; i < n; ++i) {
            int n2 = varMeta.getOffset(i);
            inputStream.reset();
            inputStream.skip(n2);
            int n3 = this.readInt(inputStream);
            byte[] byArray = this.readByteArray(inputStream, n3);
            this.m_map.put(n2, byArray);
        }
    }

    public byte[] getByteArray(Integer n) {
        byte[] byArray = null;
        if (n != null) {
            byArray = this.m_map.get(n);
        }
        return byArray;
    }

    public byte[] getByteArray(Integer n, Integer n2) {
        return this.getByteArray(this.m_meta.getOffset(n, n2));
    }

    public String getUnicodeString(Integer n) {
        byte[] byArray;
        String string = null;
        if (n != null && (byArray = this.m_map.get(n)) != null) {
            string = MPPUtility.getUnicodeString(byArray, 0);
        }
        return string;
    }

    public String getUnicodeString(Integer n, Integer n2) {
        return this.getUnicodeString(this.m_meta.getOffset(n, n2));
    }

    public Date getTimestamp(Integer n, Integer n2) {
        byte[] byArray;
        Date date = null;
        Integer n3 = this.m_meta.getOffset(n, n2);
        if (n3 != null && (byArray = this.m_map.get(n3)) != null && byArray.length >= 4) {
            date = MPPUtility.getTimestamp(byArray, 0);
        }
        return date;
    }

    public String getString(Integer n) {
        byte[] byArray;
        String string = null;
        if (n != null && (byArray = this.m_map.get(n)) != null) {
            string = MPPUtility.getString(byArray, 0);
        }
        return string;
    }

    public String getString(Integer n, Integer n2) {
        return this.getString(this.m_meta.getOffset(n, n2));
    }

    public int getShort(Integer n, Integer n2) {
        byte[] byArray;
        int n3 = 0;
        Integer n4 = this.m_meta.getOffset(n, n2);
        if (n4 != null && (byArray = this.m_map.get(n4)) != null && byArray.length >= 2) {
            n3 = MPPUtility.getShort(byArray, 0);
        }
        return n3;
    }

    public int getByte(Integer n, Integer n2) {
        byte[] byArray;
        int n3 = 0;
        Integer n4 = this.m_meta.getOffset(n, n2);
        if (n4 != null && (byArray = this.m_map.get(n4)) != null) {
            n3 = MPPUtility.getByte(byArray, 0);
        }
        return n3;
    }

    public int getInt(Integer n, Integer n2) {
        byte[] byArray;
        int n3 = 0;
        Integer n4 = this.m_meta.getOffset(n, n2);
        if (n4 != null && (byArray = this.m_map.get(n4)) != null && byArray.length >= 4) {
            n3 = MPPUtility.getInt(byArray, 0);
        }
        return n3;
    }

    public int getInt(Integer n, int n2, Integer n3) {
        byte[] byArray;
        int n4 = 0;
        Integer n5 = this.m_meta.getOffset(n, n3);
        if (n5 != null && (byArray = this.m_map.get(n5)) != null && byArray.length >= n2 + 4) {
            n4 = MPPUtility.getInt(byArray, n2);
        }
        return n4;
    }

    public long getLong(Integer n, Integer n2) {
        byte[] byArray;
        long l = 0L;
        Integer n3 = this.m_meta.getOffset(n, n2);
        if (n3 != null && (byArray = this.m_map.get(n3)) != null && byArray.length >= 8) {
            l = MPPUtility.getLong(byArray, 0);
        }
        return l;
    }

    public double getDouble(Integer n, Integer n2) {
        double d = Double.longBitsToDouble(this.getLong(n, n2));
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public VarMeta getVarMeta() {
        return this.m_meta;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN Var2Data");
        for (Integer n : this.m_map.keySet()) {
            byte[] byArray = this.m_map.get(n);
            printWriter.println("   Data at offset: " + n + " size: " + byArray.length);
            printWriter.println(MPPUtility.hexdump(byArray, true, 16, "   "));
        }
        printWriter.println("END Var2Data");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }

    public String toString(Integer n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN Var2Data for " + n);
        for (Integer n2 : this.m_meta.getTypes(n)) {
            Integer n3 = this.m_meta.getOffset(n, n2);
            byte[] byArray = this.m_map.get(n3);
            printWriter.println("   Data at offset: " + n3 + " size: " + byArray.length);
            printWriter.println(MPPUtility.hexdump(byArray, true, 16, "   "));
        }
        printWriter.println("END Var2Data for " + n);
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

