/*
 * Decompiled with CFR 0.152.
 */
package com.projity.menu;

import com.projity.help.HelpUtil;
import com.projity.util.BrowserControl;
import java.awt.BorderLayout;
import javax.swing.JEditorPane;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.ToolTipUI;

public class HyperLinkToolTip
extends JToolTip {
    private static final long serialVersionUID = 1L;
    private JEditorPane theEditorPane;
    private static final String htmlPrefix = "<html><font face=\"Dialog\" size=\"2\">";

    public HyperLinkToolTip() {
        this.setLayout(new BorderLayout());
        LookAndFeel.installBorder(this, "ToolTip.border");
        LookAndFeel.installColors(this, "ToolTip.background", "ToolTip.foreground");
        this.theEditorPane = new JEditorPane();
        this.theEditorPane.setContentType("text/html");
        this.theEditorPane.setEditable(false);
        this.theEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserControl.displayURL(hyperlinkEvent.getURL().toExternalForm());
                }
            }
        });
        this.add(this.theEditorPane);
    }

    public void setTipText(String string) {
        this.theEditorPane.setText(string);
    }

    public void updateUI() {
        this.setUI(new ToolTipUI(){});
    }

    public static String helpTipText(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(htmlPrefix);
        stringBuffer.append(string);
        if (string4 != null) {
            stringBuffer.append("<br>").append(HelpUtil.helpTipImg);
        }
        stringBuffer.append("</font></html>");
        return stringBuffer.toString();
    }

    public static String extractTip(String string) {
        if (!string.startsWith("<html>")) {
            return string;
        }
        String string2 = string.substring(htmlPrefix.length());
        string2 = string2.substring(0, string2.indexOf(60));
        return string2;
    }
}

