/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.verifytest;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.sdk.verifytest.TestPermutation;
import liquibase.sdk.verifytest.VerifiedTest;
import liquibase.sdk.verifytest.VerifiedTestReader;
import liquibase.sdk.verifytest.VerifiedTestWriter;

public class VerifiedTestFactory {
    private static final VerifiedTestFactory instance = new VerifiedTestFactory();
    Map<File, VerifiedTest> filesToWrite = new HashMap<File, VerifiedTest>();
    Map<String, File> baseDirectoriesByClass = new HashMap<String, File>();

    public static VerifiedTestFactory getInstance() {
        return instance;
    }

    private VerifiedTestFactory() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Map.Entry<File, VerifiedTest> entry : VerifiedTestFactory.this.filesToWrite.entrySet()) {
                    File file = entry.getKey();
                    VerifiedTest testToWrite = entry.getValue();
                    file.getParentFile().mkdirs();
                    try {
                        if (testToWrite.hasGroups()) {
                            for (String group : testToWrite.getGroups()) {
                                String groupValue = group.split(": ", 2)[1];
                                File groupFile = new File(file.getAbsolutePath().replaceFirst("\\.accepted.md$", "-" + VerifiedTestFactory.this.escapeFileName(groupValue) + ".accepted.md"));
                                FileWriter fileWriter = new FileWriter(groupFile);
                                try {
                                    new VerifiedTestWriter().write(testToWrite, fileWriter, group);
                                }
                                finally {
                                    fileWriter.flush();
                                    fileWriter.close();
                                }
                            }
                            continue;
                        }
                        FileWriter fileWriter = new FileWriter(file);
                        try {
                            new VerifiedTestWriter().write(testToWrite, fileWriter, null);
                        }
                        finally {
                            fileWriter.flush();
                            fileWriter.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UnexpectedLiquibaseException(e);
                    }
                }
            }
        }));
    }

    public TestPermutation getSavedRun(VerifiedTest test, TestPermutation testPermutation) throws Exception {
        VerifiedTest readTest;
        File file = this.getFile(test);
        if (this.filesToWrite.containsKey(file)) {
            readTest = this.filesToWrite.get(file);
        } else {
            if (!file.exists()) {
                return null;
            }
            FileReader reader = new FileReader(file);
            readTest = new VerifiedTestReader().read(reader);
        }
        return readTest.getPermutation(testPermutation.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRun(VerifiedTest test, TestPermutation testPermutation) throws Exception {
        VerifiedTest testToWrite;
        File file = this.getFile(test);
        if (this.filesToWrite.containsKey(file)) {
            testToWrite = this.filesToWrite.get(file);
        } else if (file.exists()) {
            FileReader reader = new FileReader(file);
            try {
                testToWrite = new VerifiedTestReader().read(reader);
            }
            finally {
                reader.close();
            }
        } else {
            testToWrite = test;
        }
        testToWrite.replacePermutation(testPermutation);
        this.filesToWrite.put(file, testToWrite);
    }

    protected File getBaseDirectory(VerifiedTest test) {
        String testClassName = test.getTestClass().replace(".", "/") + ".class";
        if (!this.baseDirectoriesByClass.containsKey(testClassName)) {
            URL resource = this.getClass().getClassLoader().getResource(testClassName);
            if (resource == null) {
                return new File(".").getAbsoluteFile();
            }
            File testClass = new File(resource.getFile());
            File classesRoot = new File(testClass.getAbsolutePath().replace(testClassName.replace("/", File.separator), ""));
            this.baseDirectoriesByClass.put(testClassName, new File(classesRoot.getParentFile().getParentFile(), "src/test/resources"));
        }
        return this.baseDirectoriesByClass.get(testClassName);
    }

    protected File getFile(VerifiedTest test) {
        String testPackageDir = test.getTestClass().replaceFirst("\\.[^\\.]*$", "").replace(".", "/");
        String fileName = test.getTestClass().replaceFirst(".*\\.", "") + "." + this.escapeFileName(test.getTestName()) + ".accepted.md";
        return new File(new File(this.getBaseDirectory(test), testPackageDir), fileName);
    }

    private String escapeFileName(String name) {
        return name.replaceAll("\\s+", "_").replaceAll("[\\-\\.]", "");
    }
}

