/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.XInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class XInputStreamToInputStreamAdapter
extends InputStream {
    private final XInputStream xin;

    public XInputStreamToInputStreamAdapter(XInputStream xInputStream) {
        this.xin = xInputStream;
    }

    public int available() throws IOException {
        int n;
        try {
            n = this.xin.available();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return n;
    }

    public void close() throws IOException {
        try {
            this.xin.closeInput();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public int read() throws IOException {
        byte[][] byArray = new byte[1][1];
        try {
            long l = this.xin.readBytes(byArray, 1);
            if (l <= 0L) {
                return -1;
            }
            int n = byArray[0][0];
            if (n < 0) {
                n = 256 + n;
            }
            return n;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        byte[][] byArray2 = new byte[1][byArray.length];
        try {
            n = this.xin.readBytes(byArray2, byArray.length);
            if (n <= 0) {
                return -1;
            }
            if (n < byArray.length) {
                System.arraycopy(byArray2[0], 0, byArray, 0, n);
            } else {
                System.arraycopy(byArray2[0], 0, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        byte[][] byArray2 = new byte[1][byArray.length];
        try {
            int n3 = this.xin.available();
            long l = n3 != 0 && n2 > n3 ? (long)this.xin.readBytes(byArray2, n3) : (long)this.xin.readBytes(byArray2, n2);
            if (l <= 0L) {
                return -1;
            }
            if (l < (long)n2) {
                System.arraycopy(byArray2[0], 0, byArray, n, (int)l);
            } else {
                System.arraycopy(byArray2[0], 0, byArray, n, n2);
            }
            return (int)l;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public long skip(long l) throws IOException {
        int n;
        long l2 = l;
        try {
            n = this.xin.available();
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
        do {
            int n2 = l2 >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
            l2 -= (long)n2;
            try {
                this.xin.skipBytes(n2);
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        } while (l2 > 0L);
        if (n != 0 && (long)n < l) {
            return n;
        }
        return l;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
    }
}

