/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.action.GetPropertyAction;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public final class RSAKeyFactory
extends KeyFactorySpi {
    private static final Class<?> rsaPublicKeySpecClass = RSAPublicKeySpec.class;
    private static final Class<?> rsaPrivateKeySpecClass = RSAPrivateKeySpec.class;
    private static final Class<?> rsaPrivateCrtKeySpecClass = RSAPrivateCrtKeySpec.class;
    private static final Class<?> x509KeySpecClass = X509EncodedKeySpec.class;
    private static final Class<?> pkcs8KeySpecClass = PKCS8EncodedKeySpec.class;
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean restrictExpLen = "true".equalsIgnoreCase(AccessController.doPrivileged(new GetPropertyAction("sun.security.rsa.restrictRSAExponent", "true")));
    private static final RSAKeyFactory INSTANCE = new RSAKeyFactory();

    public static RSAKey toRSAKey(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateKeyImpl || key instanceof RSAPrivateCrtKeyImpl || key instanceof RSAPublicKeyImpl) {
            return (RSAKey)((Object)key);
        }
        return (RSAKey)((Object)INSTANCE.engineTranslateKey(key));
    }

    static void checkRSAProviderKeyLengths(int n, BigInteger bigInteger) throws InvalidKeyException {
        RSAKeyFactory.checkKeyLengths(n + 7 & 0xFFFFFFF8, bigInteger, 512, Integer.MAX_VALUE);
    }

    public static void checkKeyLengths(int n, BigInteger bigInteger, int n2, int n3) throws InvalidKeyException {
        if (n2 > 0 && n < n2) {
            throw new InvalidKeyException("RSA keys must be at least " + n2 + " bits long");
        }
        int n4 = Math.min(n3, 16384);
        if (n > n4) {
            throw new InvalidKeyException("RSA keys must be no longer than " + n4 + " bits");
        }
        if (restrictExpLen && bigInteger != null && n > 3072 && bigInteger.bitLength() > 64) {
            throw new InvalidKeyException("RSA exponents can be no longer than 64 bits  if modulus is greater than 3072 bits");
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        String string = key.getAlgorithm();
        if (!string.equals("RSA")) {
            throw new InvalidKeyException("Not an RSA key: " + string);
        }
        if (key instanceof PublicKey) {
            return this.translatePublicKey((PublicKey)key);
        }
        if (key instanceof PrivateKey) {
            return this.translatePrivateKey((PrivateKey)key);
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePublic(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw invalidKeySpecException;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidKeySpecException(generalSecurityException);
        }
    }

    private PublicKey translatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof RSAPublicKey) {
            if (publicKey instanceof RSAPublicKeyImpl) {
                return publicKey;
            }
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            try {
                return new RSAPublicKeyImpl(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeyException("Invalid key", runtimeException);
            }
        }
        if ("X.509".equals(publicKey.getFormat())) {
            byte[] byArray = publicKey.getEncoded();
            return new RSAPublicKeyImpl(byArray);
        }
        throw new InvalidKeyException("Public keys must be instance of RSAPublicKey or have X.509 encoding");
    }

    private PrivateKey translatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            if (privateKey instanceof RSAPrivateCrtKeyImpl) {
                return privateKey;
            }
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
            try {
                return new RSAPrivateCrtKeyImpl(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeyException("Invalid key", runtimeException);
            }
        }
        if (privateKey instanceof RSAPrivateKey) {
            if (privateKey instanceof RSAPrivateKeyImpl) {
                return privateKey;
            }
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            try {
                return new RSAPrivateKeyImpl(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            catch (RuntimeException runtimeException) {
                throw new InvalidKeyException("Invalid key", runtimeException);
            }
        }
        if ("PKCS#8".equals(privateKey.getFormat())) {
            byte[] byArray = privateKey.getEncoded();
            return RSAPrivateCrtKeyImpl.newKey(byArray);
        }
        throw new InvalidKeyException("Private keys must be instance of RSAPrivate(Crt)Key or have PKCS#8 encoding");
    }

    private PublicKey generatePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            return new RSAPublicKeyImpl(x509EncodedKeySpec.getEncoded());
        }
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKeyImpl(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
    }

    private PrivateKey generatePrivate(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec;
            return RSAPrivateCrtKeyImpl.newKey(pKCS8EncodedKeySpec.getEncoded());
        }
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKeyImpl(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ(), rSAPrivateCrtKeySpec.getPrimeExponentP(), rSAPrivateCrtKeySpec.getPrimeExponentQ(), rSAPrivateCrtKeySpec.getCrtCoefficient());
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
            return new RSAPrivateKeyImpl(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        throw new InvalidKeySpecException("Only RSAPrivate(Crt)KeySpec and PKCS8EncodedKeySpec supported for RSA private keys");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> clazz) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException);
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            if (rsaPublicKeySpecClass.isAssignableFrom(clazz)) {
                return (T)new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            if (x509KeySpecClass.isAssignableFrom(clazz)) {
                return (T)new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("KeySpec must be RSAPublicKeySpec or X509EncodedKeySpec for RSA public keys");
        }
        if (key instanceof RSAPrivateKey) {
            if (pkcs8KeySpecClass.isAssignableFrom(clazz)) {
                return (T)new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (rsaPrivateCrtKeySpecClass.isAssignableFrom(clazz)) {
                if (key instanceof RSAPrivateCrtKey) {
                    RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)key;
                    return (T)new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
                }
                throw new InvalidKeySpecException("RSAPrivateCrtKeySpec can only be used with CRT keys");
            }
            if (rsaPrivateKeySpecClass.isAssignableFrom(clazz)) {
                RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
                return (T)new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
            }
            throw new InvalidKeySpecException("KeySpec must be RSAPrivate(Crt)KeySpec or PKCS8EncodedKeySpec for RSA private keys");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }
}

