/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import sun.java2d.xr.XRUtils;

public class XRColor {
    public static final XRColor FULL_ALPHA = new XRColor(65535, 0, 0, 0);
    public static final XRColor NO_ALPHA = new XRColor(0, 0, 0, 0);
    int red;
    int green;
    int blue;
    int alpha;

    public XRColor() {
        this.red = 0;
        this.green = 0;
        this.blue = 0;
        this.alpha = 0;
    }

    public XRColor(int n, int n2, int n3, int n4) {
        this.alpha = n;
        this.red = n2;
        this.green = n3;
        this.blue = n4;
    }

    public XRColor(Color color) {
    }

    public void setColorValues(Color color) {
        this.alpha = XRColor.byteToXRColorValue(color.getAlpha());
        this.red = XRColor.byteToXRColorValue((int)((double)(color.getRed() * color.getAlpha()) / 255.0));
        this.green = XRColor.byteToXRColorValue((int)((double)(color.getGreen() * color.getAlpha()) / 255.0));
        this.blue = XRColor.byteToXRColorValue((int)((double)(color.getBlue() * color.getAlpha()) / 255.0));
    }

    public static int[] ARGBPrePixelToXRColors(int[] nArray) {
        int[] nArray2 = new int[nArray.length * 4];
        XRColor xRColor = new XRColor();
        for (int i = 0; i < nArray.length; ++i) {
            xRColor.setColorValues(nArray[i], true);
            nArray2[i * 4 + 0] = xRColor.alpha;
            nArray2[i * 4 + 1] = xRColor.red;
            nArray2[i * 4 + 2] = xRColor.green;
            nArray2[i * 4 + 3] = xRColor.blue;
        }
        return nArray2;
    }

    public void setColorValues(int n, boolean bl) {
        long l = XRUtils.intToULong(n);
        this.alpha = (int)(((l & 0xFFFFFFFFFF000000L) >> 16) + 255L);
        this.red = (int)(((l & 0xFF0000L) >> 8) + 255L);
        this.green = (int)(((l & 0xFF00L) >> 0) + 255L);
        this.blue = (int)(((l & 0xFFL) << 8) + 255L);
        if (this.alpha == 255) {
            this.alpha = 0;
        }
        if (!bl) {
            double d = XRUtils.XFixedToDouble(this.alpha);
            this.red = (int)((double)this.red * d);
            this.green = (int)((double)this.green * d);
            this.blue = (int)((double)this.blue * d);
        }
    }

    public static int byteToXRColorValue(int n) {
        int n2 = 0;
        if (n != 0) {
            n2 = n == 255 ? 65535 : (n << 8) + 255;
        }
        return n2;
    }

    public String toString() {
        return "A:" + this.alpha + "  R:" + this.red + "  G:" + this.green + " B:" + this.blue;
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }
}

