/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class PropMap
implements SortedMap<Object, Object> {
    private final TreeMap<Object, Object> theMap = new TreeMap();
    private final List<PropertyChangeListener> listenerList = new ArrayList<PropertyChangeListener>(1);
    private static Map<Object, Object> defaultProps;

    void addListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(propertyChangeListener);
    }

    void removeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(propertyChangeListener);
    }

    void addListeners(ArrayList<PropertyChangeListener> arrayList) {
        this.listenerList.addAll(arrayList);
    }

    void removeListeners(ArrayList<PropertyChangeListener> arrayList) {
        this.listenerList.removeAll(arrayList);
    }

    @Override
    public Object put(Object object, Object object2) {
        Object object3 = this.theMap.put(object, object2);
        if (object2 != object3 && !this.listenerList.isEmpty()) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, (String)object, object3, object2);
            for (PropertyChangeListener propertyChangeListener : this.listenerList) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }
        return object3;
    }

    PropMap() {
        this.theMap.putAll(defaultProps);
    }

    SortedMap<Object, Object> prefixMap(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        char c = (char)(string.charAt(n - 1) + '\u0001');
        String string2 = string.substring(0, n - 1) + c;
        return this.subMap(string, string2);
    }

    String getProperty(String string) {
        return (String)this.get(string);
    }

    String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    String setProperty(String string, String string2) {
        return (String)this.put(string, string2);
    }

    List getProperties(String string) {
        Collection<Object> collection = this.prefixMap(string).values();
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        arrayList.addAll(collection);
        while (arrayList.remove(null)) {
        }
        return arrayList;
    }

    private boolean toBoolean(String string) {
        return Boolean.valueOf(string);
    }

    boolean getBoolean(String string) {
        return this.toBoolean(this.getProperty(string));
    }

    boolean setBoolean(String string, boolean bl) {
        return this.toBoolean(this.setProperty(string, String.valueOf(bl)));
    }

    int toInteger(String string) {
        if (string == null) {
            return 0;
        }
        if ("true".equals(string)) {
            return 1;
        }
        if ("false".equals(string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    int getInteger(String string) {
        return this.toInteger(this.getProperty(string));
    }

    int setInteger(String string, int n) {
        return this.toInteger(this.setProperty(string, String.valueOf(n)));
    }

    long toLong(String string) {
        try {
            return string == null ? 0L : Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String string) {
        return this.toLong(this.getProperty(string));
    }

    long setLong(String string, long l) {
        return this.toLong(this.setProperty(string, String.valueOf(l)));
    }

    int getTime(String string) {
        String string2 = this.getProperty(string, "0");
        if ("now".equals(string2)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long l = this.toLong(string2);
        if (l < 10000000000L && !"0".equals(string2)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + string2);
        }
        return (int)((l + 500L) / 1000L);
    }

    void list(PrintStream printStream) {
        PrintWriter printWriter = new PrintWriter(printStream);
        this.list(printWriter);
        printWriter.flush();
    }

    void list(PrintWriter printWriter) {
        printWriter.println("#PACK200[");
        Set<Map.Entry<Object, Object>> set = defaultProps.entrySet();
        for (Map.Entry<Object, Object> entry : this.theMap.entrySet()) {
            if (set.contains(entry)) continue;
            printWriter.println("  " + entry.getKey() + " = " + entry.getValue());
        }
        printWriter.println("#]");
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.theMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.theMap.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        return this.theMap.get(object);
    }

    @Override
    public Object remove(Object object) {
        return this.theMap.remove(object);
    }

    @Override
    public void putAll(Map map) {
        this.theMap.putAll(map);
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.theMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.theMap.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.theMap.entrySet();
    }

    @Override
    public Comparator<Object> comparator() {
        return this.theMap.comparator();
    }

    @Override
    public SortedMap<Object, Object> subMap(Object object, Object object2) {
        return this.theMap.subMap(object, object2);
    }

    @Override
    public SortedMap<Object, Object> headMap(Object object) {
        return this.theMap.headMap(object);
    }

    @Override
    public SortedMap<Object, Object> tailMap(Object object) {
        return this.theMap.tailMap(object);
    }

    @Override
    public Object firstKey() {
        return this.theMap.firstKey();
    }

    @Override
    public Object lastKey() {
        return this.theMap.lastKey();
    }

    static {
        Properties properties = new Properties();
        properties.put("com.sun.java.util.jar.pack.disable.native", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.disable.native")));
        properties.put("com.sun.java.util.jar.pack.verbose", String.valueOf(Integer.getInteger("com.sun.java.util.jar.pack.verbose", 0)));
        properties.put("com.sun.java.util.jar.pack.default.timezone", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.default.timezone")));
        properties.put("pack.segment.limit", "-1");
        properties.put("pack.keep.file.order", "true");
        properties.put("pack.modification.time", "keep");
        properties.put("pack.deflate.hint", "keep");
        properties.put("pack.unknown.attribute", "pass");
        properties.put("pack.effort", "5");
        String string = "intrinsic.properties";
        try {
            Throwable object = null;
            try (InputStream inputStream = PackerImpl.class.getResourceAsStream(string);){
                if (inputStream == null) {
                    throw new RuntimeException(string + " cannot be loaded");
                }
                properties.load(inputStream);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        for (Map.Entry entry : properties.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (!string2.startsWith("attribute.")) continue;
            entry.setValue(Attribute.normalizeLayoutString(string3));
        }
        defaultProps = new HashMap<Object, Object>(properties);
    }
}

