/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SystemOfMeasurement;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.layer.geoimage.ThumbsLoader;
import org.openstreetmap.josm.tools.ExifReader;

public final class ImageEntry
implements Comparable<ImageEntry>,
Cloneable {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Date exifTime;
    private boolean isNewGpsData;
    private Date exifGpsTime;
    private Image thumbnail;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Date gpsTime;
    ImageEntry tmp;

    public ImageEntry() {
    }

    public ImageEntry(File file) {
        this.setFile(file);
    }

    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    public Date getGpsTime() {
        if (this.tmp != null) {
            return ImageEntry.getDefensiveDate(this.tmp.gpsTime);
        }
        return ImageEntry.getDefensiveDate(this.gpsTime);
    }

    public boolean hasGpsTime() {
        return this.tmp != null && this.tmp.gpsTime != null || this.gpsTime != null;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getExifOrientation() {
        return this.exifOrientation;
    }

    public Date getExifTime() {
        return ImageEntry.getDefensiveDate(this.exifTime);
    }

    public boolean hasExifTime() {
        return this.exifTime != null;
    }

    public Date getExifGpsTime() {
        return ImageEntry.getDefensiveDate(this.exifGpsTime);
    }

    public boolean hasExifGpsTime() {
        return this.exifGpsTime != null;
    }

    private static Date getDefensiveDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public LatLon getExifCoor() {
        return this.exifCoor;
    }

    public Double getExifImgDir() {
        if (this.tmp != null) {
            return this.tmp.exifImgDir;
        }
        return this.exifImgDir;
    }

    public boolean hasThumbnail() {
        return this.thumbnail != null;
    }

    public Image getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(Image image) {
        this.thumbnail = image;
    }

    public void loadThumbnail() {
        if (this.thumbnail == null) {
            new ThumbsLoader(Collections.singleton(this)).run();
        }
    }

    public void setPos(CachedLatLon cachedLatLon) {
        this.pos = cachedLatLon;
    }

    public void setPos(LatLon latLon) {
        this.setPos(latLon != null ? new CachedLatLon(latLon) : null);
    }

    public void setSpeed(Double d) {
        this.speed = d;
    }

    public void setElevation(Double d) {
        this.elevation = d;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExifOrientation(Integer n) {
        this.exifOrientation = n;
    }

    public void setExifTime(Date date) {
        this.exifTime = ImageEntry.getDefensiveDate(date);
    }

    public void setExifGpsTime(Date date) {
        this.exifGpsTime = ImageEntry.getDefensiveDate(date);
    }

    public void setGpsTime(Date date) {
        this.gpsTime = ImageEntry.getDefensiveDate(date);
    }

    public void setExifCoor(LatLon latLon) {
        this.exifCoor = latLon;
    }

    public void setExifImgDir(Double d) {
        this.exifImgDir = d;
    }

    public ImageEntry clone() {
        try {
            return (ImageEntry)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    @Override
    public int compareTo(ImageEntry imageEntry) {
        if (this.exifTime != null && imageEntry.exifTime != null) {
            return this.exifTime.compareTo(imageEntry.exifTime);
        }
        if (this.exifTime == null && imageEntry.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public void createTmp() {
        this.tmp = this.clone();
        this.tmp.tmp = null;
    }

    public ImageEntry getTmp() {
        if (this.tmp == null) {
            this.createTmp();
        }
        return this.tmp;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.exifImgDir = this.tmp.exifImgDir;
            this.tmp = null;
        }
    }

    public void discardTmp() {
        this.tmp = null;
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        return this.file.getName() + ": " + "pos = " + this.pos + " | " + "exifCoor = " + this.exifCoor + " | " + (this.tmp == null ? " tmp==null" : " [tmp] pos = " + this.tmp.pos);
    }

    public void flagNewGpsData() {
        this.isNewGpsData = true;
    }

    public void unflagNewGpsData() {
        this.isNewGpsData = false;
    }

    public boolean hasNewGpsData() {
        return this.isNewGpsData;
    }

    public void extractExif() {
        Object object;
        GpsDirectory gpsDirectory;
        ExifIFD0Directory exifIFD0Directory;
        if (this.file == null) {
            return;
        }
        try {
            this.setExifTime(ExifReader.readTime(this.file));
        }
        catch (RuntimeException runtimeException) {
            Main.warn(runtimeException);
            this.setExifTime(null);
        }
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(this.file);
            exifIFD0Directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
            gpsDirectory = metadata.getFirstDirectoryOfType(GpsDirectory.class);
        }
        catch (CompoundException | IOException exception) {
            Main.warn(exception);
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        try {
            if (exifIFD0Directory != null) {
                int n = exifIFD0Directory.getInt(274);
                this.setExifOrientation(n);
            }
        }
        catch (MetadataException metadataException) {
            Main.debug(metadataException);
        }
        if (gpsDirectory == null) {
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        try {
            double d = gpsDirectory.getDouble(13);
            String string = gpsDirectory.getString(12);
            if ("M".equalsIgnoreCase(string)) {
                d *= SystemOfMeasurement.IMPERIAL.bValue / 1000.0;
            } else if ("N".equalsIgnoreCase(string)) {
                d *= SystemOfMeasurement.NAUTICAL_MILE.bValue / 1000.0;
            }
            this.setSpeed(d);
        }
        catch (MetadataException metadataException) {
            Main.debug(metadataException);
        }
        try {
            double d = gpsDirectory.getDouble(6);
            int n = gpsDirectory.getInt(5);
            if (n == 1) {
                d *= -1.0;
            }
            this.setElevation(d);
        }
        catch (MetadataException metadataException) {
            Main.debug(metadataException);
        }
        try {
            object = ExifReader.readLatLon(gpsDirectory);
            this.setExifCoor((LatLon)object);
            this.setPos(this.getExifCoor());
        }
        catch (MetadataException | IndexOutOfBoundsException exception) {
            Main.error("Error reading EXIF from file: " + exception);
            this.setExifCoor(null);
            this.setPos(null);
        }
        try {
            object = ExifReader.readDirection(gpsDirectory);
            if (object != null) {
                this.setExifImgDir((Double)object);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Main.debug(indexOutOfBoundsException);
        }
        object = gpsDirectory.getIntArray(7);
        if (object != null) {
            Object object2 = object[0];
            Object object3 = object[1];
            Object object4 = object[2];
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            String string = gpsDirectory.getString(29);
            if (string != null && string.matches("^\\d+:\\d+:\\d+$")) {
                String[] stringArray = string.split(":");
                gregorianCalendar.set(1, Integer.parseInt(stringArray[0]));
                gregorianCalendar.set(2, Integer.parseInt(stringArray[1]) - 1);
                gregorianCalendar.set(5, Integer.parseInt(stringArray[2]));
            } else if (this.hasExifTime()) {
                gregorianCalendar.setTime(this.getExifTime());
            }
            gregorianCalendar.set(11, (int)object2);
            gregorianCalendar.set(12, (int)object3);
            gregorianCalendar.set(13, (int)object4);
            this.setExifGpsTime(gregorianCalendar.getTime());
        }
    }
}

