/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class LogRecord
implements Serializable {
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient Object[] parameters;
    private transient ResourceBundle bundle;
    static final long serialVersionUID = 5372048053134512534L;
    private static long lastSeqNum;

    public LogRecord(Level level, String message) {
        this.level = level;
        this.message = message;
        this.millis = System.currentTimeMillis();
        this.threadID = System.identityHashCode(Thread.currentThread());
        this.sequenceNumber = LogRecord.allocateSeqNum();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        in.readByte();
        in.readByte();
        int numParams = in.readInt();
        if (numParams >= 0) {
            this.parameters = new Object[numParams];
            int i = 0;
            while (i < numParams) {
                this.parameters[i] = in.readObject();
                ++i;
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeByte(0);
        out.writeByte(0);
        if (this.parameters == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.parameters.length);
            int i = 0;
            while (i < this.parameters.length) {
                if (this.parameters[i] == null) {
                    out.writeObject(null);
                } else {
                    out.writeObject(this.parameters[i].toString());
                }
                ++i;
            }
        }
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String name) {
        this.loggerName = name;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
        this.resourceBundleName = null;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String name) {
        this.resourceBundleName = name;
        this.bundle = null;
        try {
            if (this.resourceBundleName != null) {
                this.bundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
        }
        catch (MissingResourceException missingResourceException) {}
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    private static synchronized long allocateSeqNum() {
        return ++lastSeqNum;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long seqNum) {
        this.sequenceNumber = seqNum;
    }

    public String getSourceClassName() {
        if (this.sourceClassName != null) {
            return this.sourceClassName;
        }
        return null;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getSourceMethodName() {
        if (this.sourceMethodName != null) {
            return this.sourceMethodName;
        }
        return null;
    }

    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int threadID) {
        this.threadID = threadID;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable thrown) {
        this.thrown = thrown;
    }
}

