/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientKeyExchange;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.nio.ByteBuffer;

public class ClientKeyExchangeBuilder
extends ClientKeyExchange
implements Builder {
    public ClientKeyExchangeBuilder(CipherSuite suite, ProtocolVersion version) {
        super(ByteBuffer.allocate(512), suite, version);
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().position(0).limit(this.length())).slice();
    }

    public void setExchangeKeys(ByteBuffer exchangeKeys) {
        if (this.buffer.capacity() < exchangeKeys.remaining() || this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.RSA && this.version == ProtocolVersion.SSL_3) {
            this.buffer = ByteBuffer.allocate(exchangeKeys.remaining());
        }
        ((ByteBuffer)this.buffer.duplicate().position(0)).put(exchangeKeys);
    }
}

