/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.significant.InternalSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicStreams;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class SignificantLongTerms
extends InternalSignificantTerms<SignificantLongTerms, Bucket> {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("significant_terms", "siglterms");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public SignificantLongTerms readResult(StreamInput in) throws IOException {
            SignificantLongTerms buckets = new SignificantLongTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };
    private static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Bucket buckets = new Bucket((Long)context.attributes().get("subsetSize"), (Long)context.attributes().get("supersetSize"), context.formatter());
            buckets.readFrom(in);
            return buckets;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("subsetSize", bucket.subsetSize);
            attributes.put("supersetSize", bucket.supersetSize);
            context.attributes(attributes);
            context.formatter(bucket.formatter);
            return context;
        }
    };
    private ValueFormatter formatter;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    SignificantLongTerms() {
    }

    public SignificantLongTerms(long subsetSize, long supersetSize, String name, ValueFormatter formatter, int requiredSize, long minDocCount, SignificanceHeuristic significanceHeuristic, List<? extends InternalSignificantTerms.Bucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(subsetSize, supersetSize, name, requiredSize, minDocCount, significanceHeuristic, buckets, pipelineAggregators, metaData);
        this.formatter = formatter;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public SignificantLongTerms create(List<Bucket> buckets) {
        return new SignificantLongTerms(this.subsetSize, this.supersetSize, this.name, this.formatter, this.requiredSize, this.minDocCount, this.significanceHeuristic, buckets, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.subsetDf, prototype.subsetSize, prototype.supersetDf, prototype.supersetSize, prototype.term, aggregations, prototype.formatter);
    }

    @Override
    protected SignificantLongTerms create(long subsetSize, long supersetSize, List<InternalSignificantTerms.Bucket> buckets, InternalSignificantTerms prototype) {
        return new SignificantLongTerms(subsetSize, supersetSize, prototype.getName(), ((SignificantLongTerms)prototype).formatter, prototype.requiredSize, prototype.minDocCount, prototype.significanceHeuristic, buckets, prototype.pipelineAggregators(), prototype.getMetaData());
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.requiredSize = SignificantLongTerms.readSize(in);
        this.minDocCount = in.readVLong();
        this.subsetSize = in.readVLong();
        this.supersetSize = in.readVLong();
        this.significanceHeuristic = SignificanceHeuristicStreams.read(in);
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            Bucket bucket = new Bucket(this.subsetSize, this.supersetSize, this.formatter);
            bucket.readFrom(in);
            buckets.add(bucket);
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.formatter, out);
        SignificantLongTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        out.writeVLong(this.subsetSize);
        out.writeVLong(this.supersetSize);
        this.significanceHeuristic.writeTo(out);
        out.writeVInt(this.buckets.size());
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("doc_count", this.subsetSize);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalSignificantTerms.Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    static class Bucket
    extends InternalSignificantTerms.Bucket {
        long term;
        private final transient ValueFormatter formatter;

        public Bucket(long subsetSize, long supersetSize, ValueFormatter formatter) {
            super(subsetSize, supersetSize);
            this.formatter = formatter;
        }

        public Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, long term, InternalAggregations aggregations, ValueFormatter formatter) {
            super(subsetDf, subsetSize, supersetDf, supersetSize, aggregations);
            this.formatter = formatter;
            this.term = term;
        }

        public Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, long term, InternalAggregations aggregations, double score) {
            this(subsetDf, subsetSize, supersetDf, supersetSize, term, aggregations, null);
            this.score = score;
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        int compareTerm(SignificantTerms.Bucket other) {
            return Long.compare(this.term, ((Number)other.getKey()).longValue());
        }

        @Override
        public String getKeyAsString() {
            return Long.toString(this.term);
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        Bucket newBucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            return new Bucket(subsetDf, subsetSize, supersetDf, supersetSize, this.term, aggregations, this.formatter);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.subsetDf = in.readVLong();
            this.supersetDf = in.readVLong();
            this.term = in.readLong();
            this.score = in.readDouble();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.subsetDf);
            out.writeVLong(this.supersetDf);
            out.writeLong(this.term);
            out.writeDouble(this.getSignificanceScore());
            this.aggregations.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, this.term);
            if (this.formatter != null) {
                builder.field(InternalAggregation.CommonFields.KEY_AS_STRING, this.formatter.format(this.term));
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.getDocCount());
            builder.field("score", this.score);
            builder.field("bg_count", this.supersetDf);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }
    }
}

