/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class JvmInfo
implements Streamable,
ToXContent {
    private static JvmInfo INSTANCE;
    long pid = -1L;
    String version = "";
    String vmName = "";
    String vmVersion = "";
    String vmVendor = "";
    long startTime = -1L;
    Mem mem;
    String[] inputArguments;
    String bootClassPath;
    String classPath;
    Map<String, String> systemProperties;
    String[] gcCollectors = Strings.EMPTY_ARRAY;
    String[] memoryPools = Strings.EMPTY_ARRAY;
    private String useCompressedOops;

    public static JvmInfo jvmInfo() {
        return INSTANCE;
    }

    private JvmInfo() {
    }

    public long pid() {
        return this.pid;
    }

    public long getPid() {
        return this.pid;
    }

    public String version() {
        return this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public int versionAsInteger() {
        try {
            int i;
            String sVersion = "";
            for (i = 0; i < this.version.length() && (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.'); ++i) {
                if (this.version.charAt(i) == '.') continue;
                sVersion = sVersion + this.version.charAt(i);
            }
            if (i == 0) {
                return -1;
            }
            return Integer.parseInt(sVersion);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int versionUpdatePack() {
        try {
            int from;
            int i;
            String sVersion = "";
            for (i = 0; i < this.version.length() && (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.'); ++i) {
                if (this.version.charAt(i) == '.') continue;
                sVersion = sVersion + this.version.charAt(i);
            }
            if (i == 0) {
                return -1;
            }
            Integer.parseInt(sVersion);
            if (this.version.charAt(i) == '_') {
                from = ++i;
            } else if (this.version.charAt(i) == '-' && this.version.charAt(i + 1) == 'u') {
                from = i += 2;
            } else {
                return -1;
            }
            while (i < this.version.length() && (Character.isDigit(this.version.charAt(i)) || this.version.charAt(i) == '.')) {
                ++i;
            }
            if (from == i) {
                return -1;
            }
            return Integer.parseInt(this.version.substring(from, i));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Mem getMem() {
        return this.mem;
    }

    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public String useCompressedOops() {
        return this.useCompressedOops;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.JVM);
        builder.field(Fields.PID, this.pid);
        builder.field(Fields.VERSION, this.version);
        builder.field(Fields.VM_NAME, this.vmName);
        builder.field(Fields.VM_VERSION, this.vmVersion);
        builder.field(Fields.VM_VENDOR, this.vmVendor);
        builder.dateValueField(Fields.START_TIME_IN_MILLIS, Fields.START_TIME, this.startTime);
        builder.startObject(Fields.MEM);
        builder.byteSizeField(Fields.HEAP_INIT_IN_BYTES, Fields.HEAP_INIT, this.mem.heapInit);
        builder.byteSizeField(Fields.HEAP_MAX_IN_BYTES, Fields.HEAP_MAX, this.mem.heapMax);
        builder.byteSizeField(Fields.NON_HEAP_INIT_IN_BYTES, Fields.NON_HEAP_INIT, this.mem.nonHeapInit);
        builder.byteSizeField(Fields.NON_HEAP_MAX_IN_BYTES, Fields.NON_HEAP_MAX, this.mem.nonHeapMax);
        builder.byteSizeField(Fields.DIRECT_MAX_IN_BYTES, Fields.DIRECT_MAX, this.mem.directMemoryMax);
        builder.endObject();
        builder.field(Fields.GC_COLLECTORS, this.gcCollectors);
        builder.field(Fields.MEMORY_POOLS, this.memoryPools);
        if (this.useCompressedOops != null) {
            builder.field(Fields.USING_COMPRESSED_OOPS, this.useCompressedOops);
        }
        builder.endObject();
        return builder;
    }

    public static JvmInfo readJvmInfo(StreamInput in) throws IOException {
        JvmInfo jvmInfo = new JvmInfo();
        jvmInfo.readFrom(in);
        return jvmInfo;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.pid = in.readLong();
        this.version = in.readString();
        this.vmName = in.readString();
        this.vmVersion = in.readString();
        this.vmVendor = in.readString();
        this.startTime = in.readLong();
        this.inputArguments = new String[in.readInt()];
        for (int i = 0; i < this.inputArguments.length; ++i) {
            this.inputArguments[i] = in.readString();
        }
        this.bootClassPath = in.readString();
        this.classPath = in.readString();
        this.systemProperties = new HashMap<String, String>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.systemProperties.put(in.readString(), in.readString());
        }
        this.mem = new Mem();
        this.mem.readFrom(in);
        this.gcCollectors = in.readStringArray();
        this.memoryPools = in.readStringArray();
        this.useCompressedOops = in.getVersion().onOrAfter(Version.V_2_2_0) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pid);
        out.writeString(this.version);
        out.writeString(this.vmName);
        out.writeString(this.vmVersion);
        out.writeString(this.vmVendor);
        out.writeLong(this.startTime);
        out.writeInt(this.inputArguments.length);
        for (String inputArgument : this.inputArguments) {
            out.writeString(inputArgument);
        }
        out.writeString(this.bootClassPath);
        out.writeString(this.classPath);
        out.writeInt(this.systemProperties.size());
        for (Map.Entry entry : this.systemProperties.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeString((String)entry.getValue());
        }
        this.mem.writeTo(out);
        out.writeStringArray(this.gcCollectors);
        out.writeStringArray(this.memoryPools);
        if (out.getVersion().onOrAfter(Version.V_2_2_0)) {
            out.writeOptionalString(this.useCompressedOops);
        }
    }

    static {
        JvmInfo info;
        RuntimeMXBean runtimeMXBean;
        block10: {
            long pid;
            runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            String xPid = runtimeMXBean.getName();
            try {
                xPid = xPid.split("@")[0];
                pid = Long.parseLong(xPid);
            }
            catch (Exception e) {
                pid = -1L;
            }
            info = new JvmInfo();
            info.pid = pid;
            info.startTime = runtimeMXBean.getStartTime();
            info.version = runtimeMXBean.getSystemProperties().get("java.version");
            info.vmName = runtimeMXBean.getVmName();
            info.vmVendor = runtimeMXBean.getVmVendor();
            info.vmVersion = runtimeMXBean.getVmVersion();
            (info.mem = new Mem()).heapInit = memoryMXBean.getHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getInit();
            info.mem.heapMax = memoryMXBean.getHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getHeapMemoryUsage().getMax();
            info.mem.nonHeapInit = memoryMXBean.getNonHeapMemoryUsage().getInit() < 0L ? 0L : memoryMXBean.getNonHeapMemoryUsage().getInit();
            info.mem.nonHeapMax = memoryMXBean.getNonHeapMemoryUsage().getMax() < 0L ? 0L : memoryMXBean.getNonHeapMemoryUsage().getMax();
            try {
                Class<?> vmClass = Class.forName("sun.misc.VM");
                info.mem.directMemoryMax = (Long)vmClass.getMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable vmClass) {
                // empty catch block
            }
            info.inputArguments = runtimeMXBean.getInputArguments().toArray(new String[runtimeMXBean.getInputArguments().size()]);
            try {
                info.bootClassPath = runtimeMXBean.getBootClassPath();
            }
            catch (UnsupportedOperationException e) {
                info.bootClassPath = System.getProperty("sun.boot.class.path");
                if (info.bootClassPath != null) break block10;
                info.bootClassPath = "<unknown>";
            }
        }
        info.classPath = runtimeMXBean.getClassPath();
        info.systemProperties = runtimeMXBean.getSystemProperties();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        info.gcCollectors = new String[gcMxBeans.size()];
        for (int i = 0; i < gcMxBeans.size(); ++i) {
            GarbageCollectorMXBean gcMxBean = gcMxBeans.get(i);
            info.gcCollectors[i] = gcMxBean.getName();
        }
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        info.memoryPools = new String[memoryPoolMXBeans.size()];
        for (int i = 0; i < memoryPoolMXBeans.size(); ++i) {
            MemoryPoolMXBean memoryPoolMXBean = memoryPoolMXBeans.get(i);
            info.memoryPools[i] = memoryPoolMXBean.getName();
        }
        try {
            Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            Class<?> vmOptionClazz = Class.forName("com.sun.management.VMOption");
            Object hotSpotDiagnosticMXBean = ManagementFactory.getPlatformMXBean(clazz);
            Method vmOptionMethod = clazz.getMethod("getVMOption", String.class);
            Object useCompressedOopsVmOption = vmOptionMethod.invoke(hotSpotDiagnosticMXBean, "UseCompressedOops");
            Method valueMethod = vmOptionClazz.getMethod("getValue", new Class[0]);
            info.useCompressedOops = (String)valueMethod.invoke(useCompressedOopsVmOption, new Object[0]);
        }
        catch (Throwable t) {
            info.useCompressedOops = "unknown";
        }
        INSTANCE = info;
    }

    public static class Mem
    implements Streamable {
        long heapInit = 0L;
        long heapMax = 0L;
        long nonHeapInit = 0L;
        long nonHeapMax = 0L;
        long directMemoryMax = 0L;

        Mem() {
        }

        public ByteSizeValue getHeapInit() {
            return new ByteSizeValue(this.heapInit);
        }

        public ByteSizeValue getHeapMax() {
            return new ByteSizeValue(this.heapMax);
        }

        public ByteSizeValue getNonHeapInit() {
            return new ByteSizeValue(this.nonHeapInit);
        }

        public ByteSizeValue getNonHeapMax() {
            return new ByteSizeValue(this.nonHeapMax);
        }

        public ByteSizeValue getDirectMemoryMax() {
            return new ByteSizeValue(this.directMemoryMax);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.heapInit = in.readVLong();
            this.heapMax = in.readVLong();
            this.nonHeapInit = in.readVLong();
            this.nonHeapMax = in.readVLong();
            this.directMemoryMax = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.heapInit);
            out.writeVLong(this.heapMax);
            out.writeVLong(this.nonHeapInit);
            out.writeVLong(this.nonHeapMax);
            out.writeVLong(this.directMemoryMax);
        }
    }

    static final class Fields {
        static final XContentBuilderString JVM = new XContentBuilderString("jvm");
        static final XContentBuilderString PID = new XContentBuilderString("pid");
        static final XContentBuilderString VERSION = new XContentBuilderString("version");
        static final XContentBuilderString VM_NAME = new XContentBuilderString("vm_name");
        static final XContentBuilderString VM_VERSION = new XContentBuilderString("vm_version");
        static final XContentBuilderString VM_VENDOR = new XContentBuilderString("vm_vendor");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString START_TIME_IN_MILLIS = new XContentBuilderString("start_time_in_millis");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString HEAP_INIT = new XContentBuilderString("heap_init");
        static final XContentBuilderString HEAP_INIT_IN_BYTES = new XContentBuilderString("heap_init_in_bytes");
        static final XContentBuilderString HEAP_MAX = new XContentBuilderString("heap_max");
        static final XContentBuilderString HEAP_MAX_IN_BYTES = new XContentBuilderString("heap_max_in_bytes");
        static final XContentBuilderString NON_HEAP_INIT = new XContentBuilderString("non_heap_init");
        static final XContentBuilderString NON_HEAP_INIT_IN_BYTES = new XContentBuilderString("non_heap_init_in_bytes");
        static final XContentBuilderString NON_HEAP_MAX = new XContentBuilderString("non_heap_max");
        static final XContentBuilderString NON_HEAP_MAX_IN_BYTES = new XContentBuilderString("non_heap_max_in_bytes");
        static final XContentBuilderString DIRECT_MAX = new XContentBuilderString("direct_max");
        static final XContentBuilderString DIRECT_MAX_IN_BYTES = new XContentBuilderString("direct_max_in_bytes");
        static final XContentBuilderString GC_COLLECTORS = new XContentBuilderString("gc_collectors");
        static final XContentBuilderString MEMORY_POOLS = new XContentBuilderString("memory_pools");
        static final XContentBuilderString USING_COMPRESSED_OOPS = new XContentBuilderString("using_compressed_ordinary_object_pointers");

        Fields() {
        }
    }
}

