/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.explain.ExplainResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.rescore.Rescorer;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportExplainAction
extends TransportSingleShardAction<ExplainRequest, ExplainResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;

    @Inject
    public TransportExplainAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/explain", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ExplainRequest.class, "get");
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
    }

    @Override
    protected void doExecute(ExplainRequest request, ActionListener<ExplainResponse> listener) {
        request.nowInMillis = System.currentTimeMillis();
        super.doExecute(request, listener);
    }

    @Override
    protected boolean resolveIndex(ExplainRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        ((ExplainRequest)request.request()).filteringAlias(this.indexNameExpressionResolver.filteringAliases(state, request.concreteIndex(), ((ExplainRequest)request.request()).index()));
        if (((ExplainRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((ExplainRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((ExplainRequest)request.request()).type(), ((ExplainRequest)request.request()).id());
        }
    }

    @Override
    protected ExplainResponse shardOperation(ExplainRequest request, ShardId shardId) {
        Term uidTerm;
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        Engine.GetResult result = indexShard.get(new Engine.Get(false, uidTerm = new Term("_uid", Uid.createUidAsBytes(request.type(), request.id()))));
        if (!result.exists()) {
            return new ExplainResponse(shardId.getIndex(), request.type(), request.id(), false);
        }
        DefaultSearchContext context = new DefaultSearchContext(0L, new ShardSearchLocalRequest(new String[]{request.type()}, request.nowInMillis, request.filteringAlias()), null, result.searcher(), indexService, indexShard, this.scriptService, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), this.parseFieldMatcher, SearchService.NO_TIMEOUT);
        SearchContext.setCurrent(context);
        try {
            ((SearchContext)context).parsedQuery(indexService.queryParserService().parseQuery(request.source()));
            ((SearchContext)context).preProcess();
            int topLevelDocId = result.docIdAndVersion().docId + result.docIdAndVersion().context.docBase;
            Explanation explanation = ((SearchContext)context).searcher().explain(((SearchContext)context).query(), topLevelDocId);
            for (RescoreSearchContext ctx : ((SearchContext)context).rescore()) {
                Rescorer rescorer = ctx.rescorer();
                explanation = rescorer.explain(topLevelDocId, context, ctx, explanation);
            }
            if (request.fields() != null || request.fetchSourceContext() != null && request.fetchSourceContext().fetchSource()) {
                GetResult getResult = indexShard.getService().get(result, request.id(), request.type(), request.fields(), request.fetchSourceContext(), false);
                ExplainResponse explainResponse = new ExplainResponse(shardId.getIndex(), request.type(), request.id(), true, explanation, getResult);
                return explainResponse;
            }
            ExplainResponse explainResponse = new ExplainResponse(shardId.getIndex(), request.type(), request.id(), true, explanation);
            return explainResponse;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not explain", (Throwable)e, new Object[0]);
        }
        finally {
            context.close();
            SearchContext.removeCurrent();
        }
    }

    @Override
    protected ExplainResponse newResponse() {
        return new ExplainResponse();
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((ExplainRequest)request.request()).type(), ((ExplainRequest)request.request()).id(), ((ExplainRequest)request.request()).routing(), ((ExplainRequest)request.request()).preference());
    }
}

