/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.connection.internal.ui.filter;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilterImpl;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

/**
 * @author ledunnel
 */
public class SchemaFilterWizardPage extends RDBFilterWizardPage {

    private ConnectionInfo connectionInfo;
    
    private Collator collator = Collator.getInstance(Locale.getDefault());

    /**
     * @param pageName
     */
    public SchemaFilterWizardPage(String pageName) {
        super(pageName);
    }

    protected ConnectionFilter getConnectionFilter() {
        ConnectionFilter connFilter = null;
        if (connectionInfo != null) {
            connFilter = connectionInfo
                    .getFilter(ConnectionFilter.SCHEMA_FILTER);
        }
        return connFilter;
    }

    protected void populateSelectionTable() {
	    // Clear filter
	 	ConnectionFilter filter = getConnectionFilter();
	 	setConnectionFilter(null);
      if (connectionInfo != null)
      {
         //((ICatalogObject) connectionInfo.getSharedDatabase()).refresh();
         Database sdb = (Database) connectionInfo.getSharedDatabase();
         if (sdb != null)
         {
            ((ICatalogObject)sdb).refresh();
            selectionTable.removeAll();
            if (connectionInfo != null) {
               // sort schemas
               ArrayList sqlObjectList = new ArrayList(sdb.getSchemas());
               Collections.sort(sqlObjectList, new Comparator(){
   				public int compare(Object sqlObject1, Object sqlObject2) {
   					return collator.getCollationKey(((SQLObject)sqlObject1).getName()).compareTo(collator.getCollationKey(((SQLObject)sqlObject2).getName()));
   				}});
               Iterator schemas = sqlObjectList.iterator();
     
               while (schemas.hasNext()) {
                  TableItem tableItem = new TableItem(selectionTable, SWT.NONE);
                  tableItem.setText(((SQLObject) schemas.next()).getName());
               }
               isSelectionListPopulated = true;
            }
         }
         // Re-apply filter
         setConnectionFilter(filter);
         ((ICatalogObject) connectionInfo.getSharedDatabase()).refresh();	 	
      }
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        initializeValues();
    }

    public void applyFilter(){
    	if (connectionInfo != null) {
		 	ConnectionFilter connFilter = null;
		 	if (this.isFilterSpecified()){
		 		connFilter = new ConnectionFilterImpl();
		 		connFilter.setPredicate(this.getPredicate());
		 	}
		 	setConnectionFilter(connFilter);
    	}
    }
    
    public void setConnectionFilter(ConnectionFilter connFilter) {
        if (connectionInfo != null) {
            if (connFilter == null) {
                connectionInfo.removeFilter(ConnectionFilter.SCHEMA_FILTER);
            } else {
                connectionInfo.addFilter(ConnectionFilter.SCHEMA_FILTER,
                        connFilter);
            }
        }
    }
}