/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.util;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.core.util.ISimpleDialogsHelper;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;

public class SimpleDialogsHelper
implements ISimpleDialogsHelper {
    public boolean promptYesNo(String title, String question, boolean yesIsDefault) {
        MessageDialogRunnable mdr = new MessageDialogRunnable(null, title, null, question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, yesIsDefault ? 0 : 1);
        SVNUIPlugin.getStandardDisplay().syncExec((Runnable)mdr);
        return mdr.getResult() == 0;
    }

    public boolean promptYesCancel(String title, String question, boolean yesIsDefault) {
        MessageDialogRunnable mdr = new MessageDialogRunnable(null, title, null, question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, yesIsDefault ? 0 : 1);
        SVNUIPlugin.getStandardDisplay().syncExec((Runnable)mdr);
        return mdr.getResult() == 0;
    }

    private static class MessageDialogRunnable
    implements Runnable {
        final Shell shell;
        final String title;
        final String message;
        final Image image;
        final int imageType;
        final int defaultButton;
        final String[] buttonLabels;
        int result;

        MessageDialogRunnable(Shell shell, String title, Image image, String message, int imageType, String[] buttonLabels, int defaultButton) {
            this.shell = shell;
            this.title = title;
            this.image = image;
            this.message = message;
            this.imageType = imageType;
            this.buttonLabels = buttonLabels;
            this.defaultButton = defaultButton;
        }

        public void run() {
            this.result = new MessageDialog(this.shell != null ? this.shell : Display.getCurrent().getActiveShell(), this.title, this.image, this.message, this.imageType, this.buttonLabels, this.defaultButton).open();
        }

        public int getResult() {
            return this.result;
        }
    }
}

