/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.GotoMatchingBracketAction;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAbstractEditor;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyAnnotationIterator;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubySourceViewer;
import org.rubypeople.rdt.internal.ui.rubyeditor.ToggleCommentAction;
import org.rubypeople.rdt.internal.ui.text.RubyHeuristicScanner;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.actions.FormatAction;
import org.rubypeople.rdt.ui.actions.RubyActionGroup;
import org.rubypeople.rdt.ui.actions.SurroundWithBeginRescueAction;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;

public class RubyEditor
extends RubyAbstractEditor {
    protected RubyActionGroup actionGroup;
    private ProjectionSupport fProjectionSupport;
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    private static final String CLOSE_BRACES = "closeBraces";
    private final Object fReconcilerLock = new Object();
    private IRubyFoldingStructureProvider fProjectionModelUpdater;
    private boolean fIsUpdatingAnnotationViews = false;
    private IMarker fLastMarkerTarget = null;
    private ToggleFoldingRunner fFoldingRunner;
    private BracketInserter fBracketInserter = new BracketInserter();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public RubyEditor() {
        this.setDocumentProvider((IDocumentProvider)RubyPlugin.getDefault().getRubyDocumentProvider());
        this.setRulerContextMenuId("org.rubypeople.rdt.ui.rubyeditor.rulerContextMenu");
        this.setEditorContextMenuId("org.rubypeople.rdt.ui.rubyeditor.contextMenu");
        this.setKeyBindingScopes(new String[]{"org.rubypeople.rdt.ui.rubyEditorScope"});
        this.setOutlinerContextMenuId("#RubyScriptOutlinerContext");
    }

    protected void createActions() {
        super.createActions();
        Object object = new ContentAssistAction(RubyUIMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        object.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.content.assist.proposals");
        this.setAction("ContentAssistProposal", (IAction)object);
        object = new TextOperationAction(RubyUIMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11);
        object.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.comment");
        this.setAction("Comment", (IAction)object);
        object = new TextOperationAction(RubyUIMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12);
        object.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.uncomment");
        this.setAction("Uncomment", (IAction)object);
        object = new ToggleCommentAction(RubyUIMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        object.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.toggle.comment");
        this.setAction("ToggleComment", (IAction)object);
        this.markAsStateDependentAction("ToggleComment", true);
        WorkbenchHelp.setHelp((IAction)object, (String)"org.rubypeople.rdt.ui.toggle_comment_action");
        this.configureToggleCommentAction();
        object = new GotoMatchingBracketAction(this);
        object.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)object);
        object = new FormatAction(RubyUIMessages.getResourceBundle(), "Format.", (ITextEditor)this);
        object.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.format");
        this.setAction("Format", (IAction)object);
        ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
        ISelection iSelection = iSelectionProvider.getSelection();
        SurroundWithBeginRescueAction surroundWithBeginRescueAction = new SurroundWithBeginRescueAction(this);
        surroundWithBeginRescueAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.surround.with.begin.rescue");
        surroundWithBeginRescueAction.update(iSelection);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)surroundWithBeginRescueAction);
        this.setAction("SurroundWithBeginRescue", (IAction)surroundWithBeginRescueAction);
        this.actionGroup = new RubyActionGroup(this, "group.edit");
    }

    private void configureToggleCommentAction() {
        IAction iAction = this.getAction("ToggleComment");
        if (iAction instanceof ToggleCommentAction) {
            ISourceViewer iSourceViewer = this.getSourceViewer();
            SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)iAction).configure(iSourceViewer, sourceViewerConfiguration);
        }
    }

    public void createPartControl(Composite composite) {
        ISourceViewer iSourceViewer;
        super.createPartControl(composite);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = RubyPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
        }
        if (this.isFoldingEnabled()) {
            projectionViewer.doOperation(19);
        }
        if ((iSourceViewer = this.getSourceViewer()) instanceof ITextViewerExtension) {
            IPreferenceStore iPreferenceStore = this.getPreferenceStore();
            boolean bl = iPreferenceStore.getBoolean(CLOSE_BRACKETS);
            boolean bl2 = iPreferenceStore.getBoolean(CLOSE_BRACES);
            boolean bl3 = iPreferenceStore.getBoolean(CLOSE_STRINGS);
            this.fBracketInserter.setCloseBracketsEnabled(bl);
            this.fBracketInserter.setCloseBracesEnabled(bl2);
            this.fBracketInserter.setCloseStringsEnabled(bl3);
            ((ITextViewerExtension)iSourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
    }

    private Annotation getAnnotation(int n, int n2) {
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        RubyAnnotationIterator rubyAnnotationIterator = new RubyAnnotationIterator(iAnnotationModel, true, true);
        while (rubyAnnotationIterator.hasNext()) {
            Position position;
            Annotation annotation = (Annotation)rubyAnnotationIterator.next();
            if (!this.isNavigationTarget(annotation) || (position = iAnnotationModel.getPosition(annotation)) == null || !position.overlapsWith(n, n2)) continue;
            return annotation;
        }
        return null;
    }

    private Annotation getNextAnnotation(int n, int n2, boolean bl, Position position) {
        Annotation annotation = null;
        Position position2 = null;
        Annotation annotation2 = null;
        Position position3 = null;
        boolean bl2 = false;
        IDocument iDocument = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int n3 = iDocument.getLength();
        int n4 = Integer.MAX_VALUE;
        IAnnotationModel iAnnotationModel = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        RubyAnnotationIterator rubyAnnotationIterator = new RubyAnnotationIterator(iAnnotationModel, true, true);
        while (rubyAnnotationIterator.hasNext()) {
            Position position4;
            Annotation annotation3 = (Annotation)rubyAnnotationIterator.next();
            if (annotation3 instanceof IRubyAnnotation && ((IRubyAnnotation)annotation3).hasOverlay() || !this.isNavigationTarget(annotation3) || (position4 = iAnnotationModel.getPosition(annotation3)) == null) continue;
            if (bl && position4.offset == n || !bl && position4.offset + position4.getLength() == n + n2) {
                if (annotation2 != null && (!bl || position4.length < position3.length) && (bl || position4.length < position3.length)) continue;
                annotation2 = annotation3;
                position3 = position4;
                bl2 = position4.length == n2;
                continue;
            }
            int n5 = 0;
            if (bl) {
                n5 = position4.getOffset() - n;
                if (n5 < 0) {
                    n5 = n3 + n5;
                }
                if (n5 >= n4 && (n5 != n4 || position4.length >= position2.length)) continue;
                n4 = n5;
                annotation = annotation3;
                position2 = position4;
                continue;
            }
            n5 = n + n2 - (position4.getOffset() + position4.length);
            if (n5 < 0) {
                n5 = n3 + n5;
            }
            if (n5 >= n4 && (n5 != n4 || position4.length >= position2.length)) continue;
            n4 = n5;
            annotation = annotation3;
            position2 = position4;
        }
        if (!(position3 == null || bl2 && annotation != null)) {
            position.setOffset(position3.getOffset());
            position.setLength(position3.getLength());
            return annotation2;
        }
        if (position2 != null) {
            position.setOffset(position2.getOffset());
            position.setLength(position2.getLength());
        }
        return annotation;
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String string;
        Preferences preferences = EditorsUI.getPluginPreferences();
        AnnotationPreference annotationPreference = this.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string2 = string = annotationPreference == null ? null : annotationPreference.getIsGoToNextNavigationTargetKey();
        return string != null && preferences.getBoolean(string);
    }

    public Annotation gotoAnnotation(boolean bl) {
        Annotation annotation = null;
        ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        annotation = this.getNextAnnotation(iTextSelection.getOffset(), iTextSelection.getLength(), bl, position);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateAnnotationViews(annotation);
            this.selectAndReveal(position.getOffset(), position.getLength());
            this.setStatusLineMessage(annotation.getText());
        }
        return annotation;
    }

    private void updateAnnotationViews(Annotation annotation) {
        block13: {
            Object object;
            Iterator iterator;
            IMarker iMarker = null;
            if (annotation instanceof MarkerAnnotation) {
                iMarker = ((MarkerAnnotation)annotation).getMarker();
            } else if (annotation instanceof IRubyAnnotation && (iterator = ((IRubyAnnotation)annotation).getOverlaidIterator()) != null) {
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!(object instanceof MarkerAnnotation)) continue;
                    iMarker = ((MarkerAnnotation)object).getMarker();
                    break;
                }
            }
            if (iMarker != null && !iMarker.equals((Object)this.fLastMarkerTarget)) {
                try {
                    boolean bl = iMarker.isSubtypeOf("org.eclipse.core.resources.problemmarker");
                    object = this.getSite().getPage();
                    IViewPart iViewPart = object.findView(bl ? "org.eclipse.ui.views.ProblemView" : "org.eclipse.ui.views.TaskList");
                    if (iViewPart == null) break block13;
                    Class<?> clazz = iViewPart.getClass();
                    Class[] classArray = new Class[2];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.IStructuredSelection");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    classArray[1] = Boolean.TYPE;
                    Method method = clazz.getMethod("setSelection", classArray);
                    method.invoke((Object)iViewPart, new StructuredSelection((Object)iMarker), Boolean.TRUE);
                }
                catch (CoreException coreException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
    }

    public void gotoMarker(IMarker iMarker) {
        this.fLastMarkerTarget = iMarker;
        if (!this.fIsUpdatingAnnotationViews) {
            super.gotoMarker(iMarker);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateStatusLine() {
        ITextSelection iTextSelection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(iTextSelection.getOffset(), iTextSelection.getLength());
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            try {
                this.fIsUpdatingAnnotationViews = true;
                this.updateAnnotationViews(annotation);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fIsUpdatingAnnotationViews = false;
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.fIsUpdatingAnnotationViews = false;
            }
            if (annotation instanceof IRubyAnnotation && ((IRubyAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
    }

    protected void setStatusLineErrorMessage(String string) {
        IEditorStatusLine iEditorStatusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            iEditorStatusLine.setMessage(true, string, null);
        }
    }

    protected void setStatusLineMessage(String string) {
        IEditorStatusLine iEditorStatusLine;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iEditorStatusLine = (IEditorStatusLine)this.getAdapter(clazz)) != null) {
            iEditorStatusLine.setMessage(false, string, null);
        }
    }

    boolean isFoldingEnabled() {
        return RubyPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public void dispose() {
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)iSourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        super.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean bl = projectionViewer.isProjectionMode();
            if (bl) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (bl) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            projectionViewer.setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        projectionViewer.setRedraw(true);
    }

    public Object getAdapter(Class clazz) {
        Object object;
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(clazz)) {
            return this.createRubyOutlinePage();
        }
        if (this.fProjectionSupport != null && (object = this.fProjectionSupport.getAdapter(this.getSourceViewer(), clazz)) != null) {
            return object;
        }
        return super.getAdapter(clazz);
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.doSetInput(iEditorInput);
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager iMenuManager) {
        super.editorContextMenuAboutToShow(iMenuManager);
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.rubypeople.rdt.ui.editorPopupExtender");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                SelectionEnabler selectionEnabler = new SelectionEnabler(iConfigurationElement);
                if (selectionEnabler.isEnabledForSelection(this.getSelectionProvider().getSelection())) {
                    try {
                        Object object;
                        Object object2 = iConfigurationElement.createExecutableExtension("class");
                        if (!(object2 instanceof ActionGroup)) {
                            object = "The editorPopupExtender" + iConfigurationElement.getName() + " is of type " + object2.getClass().getName() + " , but should be of type ActionGroup";
                            RubyPlugin.log(4, (String)object, null);
                        } else {
                            object = (ActionGroup)object2;
                            object.setContext(new ActionContext(this.getSelectionProvider().getSelection()));
                            object.fillContextMenu(iMenuManager);
                        }
                    }
                    catch (CoreException coreException) {
                        RubyPlugin.log(coreException);
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.actionGroup.fillContextMenu(iMenuManager);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        super.handlePreferenceStoreChanged(propertyChangeEvent);
        String string = propertyChangeEvent.getProperty();
        if ("formatUseTab".equals(string) || "formatIndentation".equals(string)) {
            if (this.getSourceViewer() instanceof RubySourceViewer) {
                ((RubySourceViewer)this.getSourceViewer()).initializeTabReplace();
            }
            if (this.getSourceViewer() instanceof ISourceViewerExtension2) {
                ((ISourceViewerExtension2)this.getSourceViewer()).unconfigure();
                this.getSourceViewer().configure(this.getSourceViewerConfiguration());
            }
        }
        if (CLOSE_BRACKETS.equals(string)) {
            this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(string));
            return;
        }
        if (CLOSE_BRACES.equals(string)) {
            this.fBracketInserter.setCloseBracesEnabled(this.getPreferenceStore().getBoolean(string));
            return;
        }
        if (CLOSE_STRINGS.equals(string)) {
            this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(string));
            return;
        }
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer == null) {
            return;
        }
        if ("editor_folding_provider".equals(string)) {
            if (iSourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)iSourceViewer;
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
                this.fProjectionModelUpdater = RubyPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
            }
            return;
        }
        if ("editor_folding_enabled".equals(string)) {
            if (iSourceViewer instanceof ProjectionViewer) {
                new ToggleFoldingRunner().runWhenNextVisible();
            }
            return;
        }
    }

    protected ISourceViewer createRubySourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n, IPreferenceStore iPreferenceStore) {
        return new RubyAbstractEditor.AdaptedSourceViewer(composite, iVerticalRuler, iOverviewRuler, bl, n, iPreferenceStore);
    }

    public Object getReconcilerLock() {
        return this.fReconcilerLock;
    }

    private static char getEscapeCharacter(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return c;
            }
            case '\'': {
                return c;
            }
        }
        throw new IllegalArgumentException();
    }

    public void setCaretPosition(CaretPosition caretPosition) {
        try {
            int n = this.getSourceViewer().getDocument().getLineOffset(caretPosition.line);
            this.selectAndReveal(n + caretPosition.column, 0);
        }
        catch (BadLocationException badLocationException) {}
    }

    public CaretPosition getCaretPosition() {
        StyledText styledText = this.getSourceViewer().getTextWidget();
        int n = RubyEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)styledText.getCaretOffset());
        IDocument iDocument = this.getSourceViewer().getDocument();
        try {
            int n2 = iDocument.getLineOfOffset(n);
            int n3 = iDocument.getLineOffset(n2);
            return new CaretPosition(n2, n - n3);
        }
        catch (BadLocationException badLocationException) {
            return new CaretPosition(0, 0);
        }
    }

    protected IRubyElement getElementAt(int n, boolean bl) {
        block5: {
            IWorkingCopyManager iWorkingCopyManager = RubyPlugin.getDefault().getWorkingCopyManager();
            IRubyScript iRubyScript = iWorkingCopyManager.getWorkingCopy(this.getEditorInput());
            if (iRubyScript != null) {
                try {
                    if (bl) {
                        RubyModelUtil.reconcile(iRubyScript);
                        return iRubyScript.getElementAt(n);
                    }
                    if (iRubyScript.isConsistent()) {
                        return iRubyScript.getElementAt(n);
                    }
                }
                catch (RubyModelException rubyModelException) {
                    if (rubyModelException.isDoesNotExist()) break block5;
                    RubyPlugin.log(rubyModelException.getStatus());
                }
            }
        }
        return null;
    }

    protected IRubyElement getElementAt(int n) {
        return this.getElementAt(n, true);
    }

    public void gotoMatchingBracket() {
        IRegion iRegion;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        IRegion iRegion2 = this.getSignedSelection(iSourceViewer);
        int n = Math.abs(iRegion2.getLength());
        if (n > 1) {
            this.setStatusLineErrorMessage(RubyEditorMessages.GotoMatchingBracket_error_invalidSelection);
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int n2 = iRegion2.getOffset() + iRegion2.getLength();
        if (RubyEditor.isSurroundedByBrackets(iDocument, n2)) {
            n2 -= iRegion2.getLength();
        }
        if ((iRegion = this.fBracketMatcher.match(iDocument, n2)) == null) {
            this.setStatusLineErrorMessage(RubyEditorMessages.GotoMatchingBracket_error_noMatchingBracket);
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int n3 = iRegion.getOffset();
        int n4 = iRegion.getLength();
        if (n4 < 1) {
            return;
        }
        int n5 = this.fBracketMatcher.getAnchor();
        int n6 = n5 == 0 ? n3 + 1 : n3 + n4;
        boolean bl = false;
        if (iSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
            bl = iTextViewerExtension5.modelOffset2WidgetOffset(n6) > -1;
        } else {
            IRegion iRegion3 = iSourceViewer.getVisibleRegion();
            boolean bl2 = bl = n6 >= iRegion3.getOffset() && n6 <= iRegion3.getOffset() + iRegion3.getLength();
        }
        if (!bl) {
            this.setStatusLineErrorMessage(RubyEditorMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            iSourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (iRegion2.getLength() < 0) {
            n6 -= iRegion2.getLength();
        }
        iSourceViewer.setSelectedRange(n6, iRegion2.getLength());
        iSourceViewer.revealRange(n6, iRegion2.getLength());
    }

    protected IRegion getSignedSelection(ISourceViewer iSourceViewer) {
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getSelectionRange();
        if (styledText.getCaretOffset() == point.x) {
            point.x += point.y;
            point.y = -point.y;
        }
        point.x = RubyEditor.widgetOffset2ModelOffset((ISourceViewer)iSourceViewer, (int)point.x);
        return new Region(point.x, point.y);
    }

    private static boolean isSurroundedByBrackets(IDocument iDocument, int n) {
        if (n == 0 || n == iDocument.getLength()) {
            return false;
        }
        try {
            return RubyEditor.isBracket(iDocument.getChar(n - 1)) && RubyEditor.isBracket(iDocument.getChar(n));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean isBracket(char c) {
        int n = 0;
        while (n != BRACKETS.length) {
            if (c == BRACKETS[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public class CaretPosition {
        private int line;
        private int column;

        protected CaretPosition(int n, int n2) {
            this.line = n;
            this.column = n2;
        }

        protected int getColumn() {
            return this.column;
        }

        protected int getLine() {
            return this.line;
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char c, char c2, Stack stack) {
            this.fExitCharacter = c;
            this.fEscapeCharacter = c2;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel linkedModeModel, VerifyEvent verifyEvent, int n, int n2) {
            if (verifyEvent.character == this.fExitCharacter && this.fSize == this.fStack.size() && !this.isMasked(n)) {
                BracketLevel bracketLevel = (BracketLevel)this.fStack.peek();
                if (bracketLevel.fFirstPosition.offset > n || bracketLevel.fSecondPosition.offset < n) {
                    return null;
                }
                if (bracketLevel.fSecondPosition.offset == n && n2 == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int n) {
            IDocument iDocument = RubyEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == iDocument.getChar(n - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String string) {
            this.fCategory = string;
        }

        public void update(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = documentEvent.getText() == null ? 0 : documentEvent.getText().length();
            int n4 = n3 - n2;
            try {
                Position[] positionArray = documentEvent.getDocument().getPositions(this.fCategory);
                int n5 = 0;
                while (n5 != positionArray.length) {
                    Position position = positionArray[n5];
                    if (!position.isDeleted()) {
                        int n6 = position.getOffset();
                        int n7 = position.getLength();
                        int n8 = n6 + n7;
                        if (n6 >= n + n2) {
                            position.setOffset(n6 + n4);
                        } else if (n8 > n) {
                            int n9;
                            if (n6 <= n && n8 >= n + n2) {
                                position.setLength(n7 + n4);
                            } else if (n6 < n) {
                                n9 = n;
                                position.setLength(n9 - n6);
                            } else if (n8 > n + n2) {
                                n9 = n + n3;
                                position.setOffset(n9);
                                position.setLength(n8 - n9);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++n5;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private boolean fCloseBraces = true;
        private final String CATEGORY = this.toString();
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
        private Stack fBracketLevelStack = new Stack();

        BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean bl) {
            this.fCloseBrackets = bl;
        }

        public void setCloseStringsEnabled(boolean bl) {
            this.fCloseStrings = bl;
        }

        public void setCloseBracesEnabled(boolean bl) {
            this.fCloseBraces = bl;
        }

        public void verifyKey(VerifyEvent verifyEvent) {
            if (!verifyEvent.doit) {
                return;
            }
            switch (verifyEvent.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer iSourceViewer = RubyEditor.this.getSourceViewer();
            IDocument iDocument = iSourceViewer.getDocument();
            Point point = iSourceViewer.getSelectedRange();
            int n = point.x;
            int n2 = point.y;
            try {
                ITypedRegion iTypedRegion;
                IRegion iRegion = iDocument.getLineInformationOfOffset(n);
                IRegion iRegion2 = iDocument.getLineInformationOfOffset(n + n2);
                RubyHeuristicScanner rubyHeuristicScanner = new RubyHeuristicScanner(iDocument);
                int n3 = rubyHeuristicScanner.nextToken(n + n2, iRegion2.getOffset() + iRegion2.getLength());
                String string = n3 == -1 ? null : iDocument.get(n, rubyHeuristicScanner.getPosition() - n).trim();
                int n4 = rubyHeuristicScanner.previousToken(n - 1, iRegion.getOffset());
                int n5 = rubyHeuristicScanner.getPosition() + 1;
                String string2 = n4 == -1 ? null : iDocument.get(n5, n - n5).trim();
                switch (verifyEvent.character) {
                    case '(': {
                        if (this.fCloseBrackets && n3 != 5 && n3 != 2000 && (string == null || string.length() <= 1)) break;
                        return;
                    }
                    case '{': {
                        if (this.fCloseBraces && n3 != 1 && n3 != 2000 && (string == null || string.length() <= 1)) break;
                        return;
                    }
                    case '[': {
                        if (this.fCloseBrackets && n3 != 2000 && (string == null || string.length() <= 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        if (this.fCloseStrings && n3 != 2000 && n4 != 2000 && (string == null || string.length() <= 1) && (string2 == null || string2.length() <= 1)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!"__dftl_partition_content_type".equals((iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)"___ruby_partitioning", (int)n, (boolean)true)).getType())) {
                    return;
                }
                if (!RubyEditor.this.validateEditorInputState()) {
                    return;
                }
                char c = verifyEvent.character;
                char c2 = RubyEditor.getPeerCharacter(c);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                stringBuffer.append(c2);
                iDocument.replace(n, n2, stringBuffer.toString());
                BracketLevel bracketLevel = new BracketLevel();
                this.fBracketLevelStack.push(bracketLevel);
                LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                linkedPositionGroup.addPosition(new LinkedPosition(iDocument, n + 1, 0, -1));
                LinkedModeModel linkedModeModel = new LinkedModeModel();
                linkedModeModel.addLinkingListener((ILinkedModeListener)this);
                linkedModeModel.addGroup(linkedPositionGroup);
                linkedModeModel.forceInstall();
                bracketLevel.fOffset = n;
                bracketLevel.fLength = 2;
                if (this.fBracketLevelStack.size() == 1) {
                    iDocument.addPositionCategory(this.CATEGORY);
                    iDocument.addPositionUpdater(this.fUpdater);
                }
                bracketLevel.fFirstPosition = new Position(n, 1);
                bracketLevel.fSecondPosition = new Position(n + 1, 1);
                iDocument.addPosition(this.CATEGORY, bracketLevel.fFirstPosition);
                iDocument.addPosition(this.CATEGORY, bracketLevel.fSecondPosition);
                bracketLevel.fUI = new EditorLinkedModeUI(linkedModeModel, (ITextViewer)iSourceViewer);
                bracketLevel.fUI.setSimpleMode(true);
                bracketLevel.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(c2, RubyEditor.getEscapeCharacter(c2), this.fBracketLevelStack));
                bracketLevel.fUI.setExitPosition((ITextViewer)iSourceViewer, n + 2, 0, Integer.MAX_VALUE);
                bracketLevel.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                bracketLevel.fUI.enter();
                IRegion iRegion3 = bracketLevel.fUI.getSelectedRegion();
                iSourceViewer.setSelectedRange(iRegion3.getOffset(), iRegion3.getLength());
                verifyEvent.doit = false;
            }
            catch (BadLocationException badLocationException) {
                RubyPlugin.log(badLocationException);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                RubyPlugin.log(badPositionCategoryException);
            }
        }

        public void left(LinkedModeModel linkedModeModel, int n) {
            BracketLevel bracketLevel = (BracketLevel)this.fBracketLevelStack.pop();
            if (n != 8) {
                return;
            }
            ISourceViewer iSourceViewer = RubyEditor.this.getSourceViewer();
            IDocument iDocument = iSourceViewer.getDocument();
            if (iDocument instanceof IDocumentExtension) {
                IDocumentExtension iDocumentExtension = (IDocumentExtension)iDocument;
                iDocumentExtension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(this, bracketLevel, iDocument){
                    final /* synthetic */ BracketInserter this$1;
                    private final /* synthetic */ BracketLevel val$level;
                    private final /* synthetic */ IDocument val$document;
                    {
                        this.this$1 = bracketInserter;
                        this.val$level = bracketLevel;
                        this.val$document = iDocument;
                    }

                    public void perform(IDocument iDocument, IDocumentListener iDocumentListener) {
                        if ((this.val$level.fFirstPosition.isDeleted || this.val$level.fFirstPosition.length == 0) && !this.val$level.fSecondPosition.isDeleted && this.val$level.fSecondPosition.offset == this.val$level.fFirstPosition.offset) {
                            try {
                                this.val$document.replace(this.val$level.fSecondPosition.offset, this.val$level.fSecondPosition.length, null);
                            }
                            catch (BadLocationException badLocationException) {
                                RubyPlugin.log(badLocationException);
                            }
                        }
                        if (BracketInserter.access$0(this.this$1).size() == 0) {
                            this.val$document.removePositionUpdater(BracketInserter.access$1(this.this$1));
                            try {
                                this.val$document.removePositionCategory(BracketInserter.access$2(this.this$1));
                            }
                            catch (BadPositionCategoryException badPositionCategoryException) {
                                RubyPlugin.log(badPositionCategoryException);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel linkedModeModel) {
        }

        public void resume(LinkedModeModel linkedModeModel, int n) {
        }

        static /* synthetic */ Stack access$0(BracketInserter bracketInserter) {
            return bracketInserter.fBracketLevelStack;
        }

        static /* synthetic */ IPositionUpdater access$1(BracketInserter bracketInserter) {
            return bracketInserter.fUpdater;
        }

        static /* synthetic */ String access$2(BracketInserter bracketInserter) {
            return bracketInserter.CATEGORY;
        }
    }

    private final class ToggleFoldingRunner
    implements IPartListener2 {
        private IWorkbenchPage fPage;

        ToggleFoldingRunner() {
        }

        private void toggleFolding() {
            ProjectionViewer projectionViewer;
            ISourceViewer iSourceViewer = RubyEditor.this.getSourceViewer();
            if (iSourceViewer instanceof ProjectionViewer && (projectionViewer = (ProjectionViewer)iSourceViewer).isProjectionMode() != RubyEditor.this.isFoldingEnabled() && projectionViewer.canDoOperation(19)) {
                projectionViewer.doOperation(19);
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage iWorkbenchPage;
            if (RubyEditor.this.fFoldingRunner != null) {
                RubyEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite iWorkbenchPartSite = RubyEditor.this.getSite();
            if (iWorkbenchPartSite != null && !(iWorkbenchPage = iWorkbenchPartSite.getPage()).isPartVisible((IWorkbenchPart)RubyEditor.this)) {
                this.fPage = iWorkbenchPage;
                RubyEditor.this.fFoldingRunner = this;
                iWorkbenchPage.addPartListener((IPartListener2)this);
                return;
            }
            this.toggleFolding();
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (RubyEditor.this.fFoldingRunner == this) {
                RubyEditor.this.fFoldingRunner = null;
            }
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (((Object)((Object)RubyEditor.this)).equals(iWorkbenchPartReference.getPart(false))) {
                this.cancel();
                this.toggleFolding();
            }
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
            if (((Object)((Object)RubyEditor.this)).equals(iWorkbenchPartReference.getPart(false))) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    }
}

