/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.debug.ui.RubySourceLocator;
import org.rubypeople.rdt.testunit.TestunitPlugin;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.testunit.views.TestUnitView;

public class OpenEditorAtLineAction
extends Action {
    private int fLineNumber;
    private String fileName;
    private TestUnitView fTestRunner;

    public OpenEditorAtLineAction(TestUnitView testUnitView, String string, int n) {
        super(TestUnitMessages.getString("OpenEditorAction.action.label"));
        this.fLineNumber = n;
        this.fTestRunner = testUnitView;
        this.fileName = string;
    }

    public void run() {
        try {
            IEditorInput iEditorInput = this.getInput();
            if (iEditorInput == null) {
                if (TestunitPlugin.getDefault().isDebugging()) {
                    System.out.println("Could not create editor input for stack trace: " + this.fileName);
                }
                return;
            }
            IEditorPart iEditorPart = this.getEditorPart(iEditorInput);
            this.setEditorToLine(iEditorPart, iEditorInput);
        }
        catch (CoreException coreException) {
            TestunitPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.testunit", 0, "Could not open editor or set line in editor." + this.fileName, (Throwable)coreException));
        }
    }

    private IEditorPart getEditorPart(IEditorInput iEditorInput) throws PartInitException {
        ISourceLocator iSourceLocator = this.getSourceLocator();
        if (!(iSourceLocator instanceof RubySourceLocator)) {
            return null;
        }
        RubySourceLocator rubySourceLocator = (RubySourceLocator)iSourceLocator;
        Object object = rubySourceLocator.getSourceElement(this.fileName);
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(iEditorInput, rubySourceLocator.getEditorId(iEditorInput, object));
    }

    private void setEditorToLine(IEditorPart iEditorPart, IEditorInput iEditorInput) throws CoreException {
        IDocumentProvider iDocumentProvider;
        block5: {
            if (!(iEditorPart instanceof ITextEditor)) {
                return;
            }
            if (this.fLineNumber > 0) {
                --this.fLineNumber;
            }
            if (this.fLineNumber == 0) {
                return;
            }
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            iDocumentProvider = iTextEditor.getDocumentProvider();
            iDocumentProvider.connect((Object)iEditorInput);
            IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
            try {
                IRegion iRegion = iDocument.getLineInformation(this.fLineNumber);
                iTextEditor.selectAndReveal(iRegion.getOffset(), iRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
                if (!TestunitPlugin.getDefault().isDebugging()) break block5;
                System.out.println("Could not set editor to line: " + this.fLineNumber);
            }
        }
        iDocumentProvider.disconnect((Object)iEditorInput);
    }

    protected void reveal(ITextEditor iTextEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                iTextEditor.selectAndReveal(iDocument.getLineOffset(this.fLineNumber - 1), iDocument.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected IRubyElement findElement(IRubyProject iRubyProject, String string) throws CoreException {
        return iRubyProject.findType(string);
    }

    public boolean isEnabled() {
        return this.getInput() != null;
    }

    private IEditorInput getInput() {
        ISourceLocator iSourceLocator = this.getSourceLocator();
        if (!(iSourceLocator instanceof RubySourceLocator)) {
            return null;
        }
        RubySourceLocator rubySourceLocator = (RubySourceLocator)iSourceLocator;
        Object object = rubySourceLocator.getSourceElement(this.fileName);
        IEditorInput iEditorInput = rubySourceLocator.getEditorInput(object);
        return iEditorInput;
    }

    private ISourceLocator getSourceLocator() {
        ILaunch iLaunch = this.fTestRunner.getLastLaunch();
        if (iLaunch == null) {
            return null;
        }
        return iLaunch.getSourceLocator();
    }

    protected Shell getShell() {
        return this.fTestRunner.getSite().getShell();
    }

    protected IRubyProject getLaunchedProject() {
        return this.fTestRunner.getLaunchedProject();
    }
}

