/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCheckReturnAnnotationDatabase
extends AnnotationVisitor {
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private static final Map<String, String> defaultKind = new HashMap<String, String>();

    static String lastPortion(String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    public void visit(JavaClass obj) {
        if (obj.isSynthetic()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addSyntheticElement((Object)this.getDottedClassName());
        }
    }

    public void visit(Field f) {
        if (f.isSynthetic()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addSyntheticElement((Object)XFactory.createXField((PreorderVisitor)this));
        }
    }

    public void visit(Method m) {
        if (m.isSynthetic()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addSyntheticElement((Object)XFactory.createXMethod((PreorderVisitor)this));
        }
    }

    public void visit(Synthetic a) {
        if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addSyntheticElement((Object)XFactory.createXMethod((PreorderVisitor)this));
        } else if (this.visitingField()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addSyntheticElement((Object)XFactory.createXField((PreorderVisitor)this));
        } else {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addSyntheticElement((Object)this.getDottedClassName());
        }
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        CheckReturnValueAnnotation n = CheckReturnValueAnnotation.parse((String)(annotationClass = BuildCheckReturnAnnotationDatabase.lastPortion(annotationClass)), (String)((String)map.get("priority")));
        if (n == null) {
            if (annotationClass.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
                Object v = map.get("value");
                if (v == null || !(v instanceof Object[])) {
                    return;
                }
                String annotationTarget = defaultKind.get(annotationClass = annotationClass.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
                if (annotationTarget != null) {
                    for (Object aClass : (Object[])v) {
                        n = CheckReturnValueAnnotation.parse((String)((String)aClass), (String)((String)map.get("priority")));
                        if (n == null) continue;
                        AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDefaultAnnotation(annotationTarget, this.getDottedClassName(), (AnnotationEnumeration)n);
                    }
                }
            }
        } else if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDirectAnnotation((Object)XFactory.createXMethod((PreorderVisitor)this), (AnnotationEnumeration)n);
        }
    }

    static {
        defaultKind.put("", "Any");
        defaultKind.put("ForParameters", "Parameter");
        defaultKind.put("ForMethods", "Method");
        defaultKind.put("ForFields", "Field");
    }
}

